/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.pkg.dslplatform.json;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class RawJsonWriter {
    private int position;
    private byte[] buffer;
    public static final byte OBJECT_START = 123;
    public static final byte OBJECT_END = 125;
    public static final byte ARRAY_START = 91;
    public static final byte ARRAY_END = 93;
    public static final byte COMMA = 44;
    public static final byte SEMI = 58;
    public static final byte QUOTE = 34;
    public static final byte ESCAPE = 92;

    public RawJsonWriter(int capacity) {
        this.buffer = new byte[capacity];
    }

    final byte[] ensureCapacity(int free) {
        if (this.position + free >= this.buffer.length) {
            this.enlargeOrFlush(this.position, free);
        }
        return this.buffer;
    }

    void advance(int size) {
        this.position += size;
    }

    private void enlargeOrFlush(int size, int padding) {
        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length + this.buffer.length / 2 + padding);
    }

    public final void writeByte(byte value) {
        if (this.position == this.buffer.length) {
            this.enlargeOrFlush(this.position, 0);
        }
        this.buffer[this.position++] = value;
    }

    public final void writeString(String value) {
        int len = value.length();
        if (this.position + (len << 2) + (len << 1) + 2 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, (len << 2) + (len << 1) + 2);
        }
        byte[] _result = this.buffer;
        _result[this.position] = 34;
        int cur = this.position + 1;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c <= '\u001f' || c == '\"' || c == '\\' || c >= '~') {
                this.writeQuotedString(value, i, cur, len);
                return;
            }
            _result[cur++] = (byte)c;
        }
        _result[cur] = 34;
        this.position = cur + 1;
    }

    private void writeQuotedString(CharSequence str, int i, int cur, int len) {
        byte[] _result = this.buffer;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\"') {
                _result[cur++] = 92;
                _result[cur++] = 34;
            } else if (c == '\\') {
                _result[cur++] = 92;
                _result[cur++] = 92;
            } else if (c < ' ') {
                if (c == '\b') {
                    _result[cur++] = 92;
                    _result[cur++] = 98;
                } else if (c == '\t') {
                    _result[cur++] = 92;
                    _result[cur++] = 116;
                } else if (c == '\n') {
                    _result[cur++] = 92;
                    _result[cur++] = 110;
                } else if (c == '\f') {
                    _result[cur++] = 92;
                    _result[cur++] = 102;
                } else if (c == '\r') {
                    _result[cur++] = 92;
                    _result[cur++] = 114;
                } else {
                    _result[cur] = 92;
                    _result[cur + 1] = 117;
                    _result[cur + 2] = 48;
                    _result[cur + 3] = 48;
                    switch (c) {
                        case '\u0000': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 48;
                            break;
                        }
                        case '\u0001': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 49;
                            break;
                        }
                        case '\u0002': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 50;
                            break;
                        }
                        case '\u0003': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 51;
                            break;
                        }
                        case '\u0004': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 52;
                            break;
                        }
                        case '\u0005': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 53;
                            break;
                        }
                        case '\u0006': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 54;
                            break;
                        }
                        case '\u0007': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 55;
                            break;
                        }
                        case '\u000b': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 66;
                            break;
                        }
                        case '\u000e': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 69;
                            break;
                        }
                        case '\u000f': {
                            _result[cur + 4] = 48;
                            _result[cur + 5] = 70;
                            break;
                        }
                        case '\u0010': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 48;
                            break;
                        }
                        case '\u0011': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 49;
                            break;
                        }
                        case '\u0012': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 50;
                            break;
                        }
                        case '\u0013': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 51;
                            break;
                        }
                        case '\u0014': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 52;
                            break;
                        }
                        case '\u0015': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 53;
                            break;
                        }
                        case '\u0016': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 54;
                            break;
                        }
                        case '\u0017': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 55;
                            break;
                        }
                        case '\u0018': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 56;
                            break;
                        }
                        case '\u0019': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 57;
                            break;
                        }
                        case '\u001a': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 65;
                            break;
                        }
                        case '\u001b': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 66;
                            break;
                        }
                        case '\u001c': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 67;
                            break;
                        }
                        case '\u001d': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 68;
                            break;
                        }
                        case '\u001e': {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 69;
                            break;
                        }
                        default: {
                            _result[cur + 4] = 49;
                            _result[cur + 5] = 70;
                        }
                    }
                    cur += 6;
                }
            } else if (c < '\u007f') {
                _result[cur++] = (byte)c;
            } else {
                int cp = Character.codePointAt(str, i);
                if (Character.isSupplementaryCodePoint(cp)) {
                    ++i;
                }
                if (cp == 127) {
                    _result[cur++] = (byte)cp;
                } else if (cp <= 2047) {
                    _result[cur++] = (byte)(0xC0 | cp >> 6 & 0x1F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp < 55296 || cp > 57343 && cp <= 65535) {
                    _result[cur++] = (byte)(0xE0 | cp >> 12 & 0xF);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else if (cp >= 65536 && cp <= 0x10FFFF) {
                    _result[cur++] = (byte)(0xF0 | cp >> 18 & 7);
                    _result[cur++] = (byte)(0x80 | cp >> 12 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp >> 6 & 0x3F);
                    _result[cur++] = (byte)(0x80 | cp & 0x3F);
                } else {
                    throw new IllegalArgumentException("Unknown unicode codepoint in string! " + Integer.toHexString(cp));
                }
            }
            ++i;
        }
        _result[cur] = 34;
        this.position = cur + 1;
    }

    public final void writeQuotedAscii(String value) {
        int len = value.length() + 2;
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        byte[] _result = this.buffer;
        _result[this.position] = 34;
        value.getBytes(0, len - 2, _result, this.position + 1);
        _result[this.position + len - 1] = 34;
        this.position += len;
    }

    public final void writeRawAscii(String value) {
        int len = value.length();
        if (this.position + len >= this.buffer.length) {
            this.enlargeOrFlush(this.position, len);
        }
        value.getBytes(0, len, this.buffer, this.position);
        this.position += len;
    }

    public final void writeBoolean(boolean value) {
        if (value) {
            this.writeRawAscii("true");
        } else {
            this.writeRawAscii("false");
        }
    }

    public final void writeNull() {
        if (this.position + 4 >= this.buffer.length) {
            this.enlargeOrFlush(this.position, 0);
        }
        int s = this.position;
        byte[] _result = this.buffer;
        _result[s] = 110;
        _result[s + 1] = 117;
        _result[s + 2] = 108;
        _result[s + 3] = 108;
        this.position += 4;
    }

    public final byte[] toByteArray() {
        byte[] r = Arrays.copyOf(this.buffer, this.position);
        this.reset();
        return r;
    }

    public void toByteBuffer(ByteBuffer b) {
        b.put(this.buffer, 0, this.position);
        b.flip();
        this.reset();
    }

    public String toString() {
        String r = new String(this.buffer, 0, this.position, StandardCharsets.UTF_8);
        this.reset();
        return r;
    }

    public final int size() {
        return this.position;
    }

    public final void reset() {
        this.position = 0;
    }
}

