/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.pipeline;

public class ExponentialBackoff {
    private final long minDelay;
    private final long maxDelay;
    private long currentDelay;

    public ExponentialBackoff(long minDelay, long maxDelay) {
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.currentDelay = minDelay;
    }

    public long nextDelay() {
        if (this.currentDelay >= this.maxDelay) {
            return this.maxDelay;
        }
        long delay = this.currentDelay;
        this.currentDelay *= 2L;
        return delay;
    }

    public void reset() {
        this.currentDelay = this.minDelay;
    }

    public String toString() {
        return "ExponentialBackoff [minDelay=" + this.minDelay + ", maxDelay=" + this.maxDelay + ", currentDelay=" + this.currentDelay + "]";
    }
}

