/*
 * Decompiled with CFR 0.152.
 */
package com.liys.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.BlurMaskFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.liys.view.R;
import java.text.DecimalFormat;

public abstract class BaseProView
extends View {
    protected Context context;
    protected int width;
    protected int height;
    protected int progressSize;
    protected int progressColorBackground;
    protected int progressColor;
    protected String text = "";
    protected int textSize;
    protected int textColor;
    protected boolean textShow;
    protected int textDecimalNum;
    protected int lightColor;
    protected boolean lightShow;
    protected int strokeWidth;
    protected int strokeColor;
    protected boolean strokeShow;
    protected Paint progressBgPaint = new Paint();
    protected Paint progressPaint = new Paint();
    protected Paint textPaint = new Paint();
    protected Paint lightPaint = new Paint();
    protected Paint strokePaint = new Paint();
    protected double maxProgress;
    protected double progress;
    protected int blankSpace;

    public BaseProView(Context context) {
        this(context, null);
    }

    public BaseProView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseProView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initBaseAttrs(attrs);
        this.initBaseView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.width = w;
        this.height = h;
        if (this.progressSize == 0) {
            this.progressSize = this.height;
        }
        this.blankSpace = (this.height - this.progressSize) / 2;
        this.refreshLight();
        this.beforeInit();
        this.init();
    }

    public void beforeInit() {
    }

    public abstract void init();

    @SuppressLint(value={"CustomViewStyleable"})
    private void initBaseAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.context.obtainStyledAttributes(attrs, R.styleable.BaseProgressView);
        this.maxProgress = typedArray.getInteger(R.styleable.BaseProgressView_progress_max, 100);
        this.progress = typedArray.getInteger(R.styleable.BaseProgressView_progress_value, 0);
        this.progressSize = typedArray.getDimensionPixelOffset(R.styleable.BaseProgressView_progress_size, 0);
        this.progressColorBackground = typedArray.getColor(R.styleable.BaseProgressView_progress_color_background, -7829368);
        this.progressColor = typedArray.getColor(R.styleable.BaseProgressView_progress_color, -256);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.BaseProgressView_text_size, this.sp2px(10.0f));
        this.textColor = typedArray.getColor(R.styleable.BaseProgressView_text_color, -1);
        this.textShow = typedArray.getBoolean(R.styleable.BaseProgressView_text_show, false);
        this.textDecimalNum = typedArray.getInt(R.styleable.BaseProgressView_text_decimal_num, 0);
        this.lightColor = typedArray.getColor(R.styleable.BaseProgressView_light_color, -1);
        this.lightShow = typedArray.getBoolean(R.styleable.BaseProgressView_light_show, false);
        this.strokeColor = typedArray.getColor(R.styleable.BaseProgressView_stroke_color, -1);
        this.strokeWidth = typedArray.getDimensionPixelOffset(R.styleable.BaseProgressView_stroke_width, this.dp2px(1.0f));
        this.strokeShow = typedArray.getBoolean(R.styleable.BaseProgressView_stroke_show, false);
        typedArray.recycle();
        this.refreshText();
    }

    private void initBaseView() {
        this.progressBgPaint.setAntiAlias(true);
        this.progressBgPaint.setColor(this.progressColorBackground);
        this.progressPaint.setAntiAlias(true);
        this.progressPaint.setColor(this.progressColor);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize((float)this.textSize);
        this.lightPaint.setAntiAlias(true);
        this.lightPaint.setColor(this.lightColor);
        this.strokePaint.setStrokeWidth((float)this.strokeWidth);
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setColor(this.strokeColor);
        this.strokePaint.setStyle(Paint.Style.STROKE);
    }

    protected void refreshLight() {
        if (this.lightShow && this.blankSpace > 0) {
            BlurMaskFilter progressMaskFilter = new BlurMaskFilter((float)this.blankSpace, BlurMaskFilter.Blur.SOLID);
            BlurMaskFilter lightMaskFilter = new BlurMaskFilter((float)this.blankSpace, BlurMaskFilter.Blur.OUTER);
            this.lightPaint.setMaskFilter((MaskFilter)lightMaskFilter);
            this.progressPaint.setMaskFilter((MaskFilter)progressMaskFilter);
            this.setLayerType(1, null);
        }
    }

    public void setOutGradient(boolean isProDirection, int ... colors) {
    }

    public void setOutGradient(int ... colors) {
        this.setOutGradient(true, colors);
    }

    protected Rect getTextRect(String text) {
        Rect rect = new Rect();
        this.textPaint.getTextBounds(text, 0, text.length(), rect);
        return rect;
    }

    protected int getBaseline(Paint paint) {
        return this.getBaseline(paint, this.getMeasuredHeight());
    }

    protected int getBaseline(Paint paint, int totalHeight) {
        Paint.FontMetricsInt fontMetrics = paint.getFontMetricsInt();
        int fontTotalHeight = fontMetrics.bottom - fontMetrics.top;
        int offY = fontTotalHeight / 2 - fontMetrics.bottom;
        int baseline = (totalHeight + fontTotalHeight) / 2 - offY;
        return baseline;
    }

    public void setProgress(double progress) {
        this.progress = progress;
        this.refreshText();
    }

    public void setMaxProgress(double maxProgress) {
        this.maxProgress = maxProgress;
        this.refreshText();
    }

    protected void refreshText() {
        this.text = this.keepDecimals(this.progress / this.maxProgress * 100.0) + "%";
        this.postInvalidate();
    }

    protected String keepDecimals(double value) {
        if (this.textDecimalNum == 0) {
            return (int)value + "";
        }
        String format = "";
        for (int i = 0; i < this.textDecimalNum; ++i) {
            format = i == 0 ? "0.0" : format + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(value);
    }

    public int sp2px(float sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public int dp2px(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public int getProgressSize() {
        return this.progressSize;
    }

    public void setProgressSize(int progressSize) {
        this.progressSize = progressSize;
    }

    public int getProgressColorBackground() {
        return this.progressColorBackground;
    }

    public void setProgressColorBackground(int progressColorBackground) {
        this.progressColorBackground = progressColorBackground;
    }

    public int getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(int progressColor) {
        this.progressColor = progressColor;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public boolean isTextShow() {
        return this.textShow;
    }

    public void setTextShow(boolean textShow) {
        this.textShow = textShow;
    }

    public int getTextDecimalNum() {
        return this.textDecimalNum;
    }

    public void setTextDecimalNum(int textDecimalNum) {
        this.textDecimalNum = textDecimalNum;
    }

    public int getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(int lightColor) {
        this.lightColor = lightColor;
    }

    public boolean isLightShow() {
        return this.lightShow;
    }

    public void setLightShow(boolean lightShow) {
        this.lightShow = lightShow;
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
    }

    public boolean isStrokeShow() {
        return this.strokeShow;
    }

    public void setStrokeShow(boolean strokeShow) {
        this.strokeShow = strokeShow;
    }

    public double getMaxProgress() {
        return this.maxProgress;
    }

    public double getProgress() {
        return this.progress;
    }

    public Paint getProgressBgPaint() {
        return this.progressBgPaint;
    }

    public void setProgressBgPaint(Paint progressBgPaint) {
        this.progressBgPaint = progressBgPaint;
    }

    public Paint getProgressPaint() {
        return this.progressPaint;
    }

    public void setProgressPaint(Paint progressPaint) {
        this.progressPaint = progressPaint;
    }

    public Paint getTextPaint() {
        return this.textPaint;
    }

    public void setTextPaint(Paint textPaint) {
        this.textPaint = textPaint;
    }

    public Paint getLightPaint() {
        return this.lightPaint;
    }

    public void setLightPaint(Paint lightPaint) {
        this.lightPaint = lightPaint;
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }
}

