/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.livechatinc.inappchat.ChatWindowConfiguration;
import com.livechatinc.inappchat.ChatWindowJsInterface;
import com.livechatinc.inappchat.IChatWindowView;
import com.livechatinc.inappchat.LoadWebViewContentTask;
import com.livechatinc.inappchat.R;
import com.livechatinc.inappchat.UriUtils;
import com.livechatinc.inappchat.models.NewMessageModel;
import java.io.File;
import java.util.Map;

public class ChatWindowView
extends FrameLayout
implements IChatWindowView,
View.OnClickListener {
    private WebView webView;
    private TextView statusText;
    private Button reloadButton;
    private ProgressBar progressBar;
    private WebView webViewPopup;
    private LoadWebViewContentTask loadWebViewContentTask;
    private ChatWindowEventsListener chatWindowListener;
    private static final int REQUEST_CODE_FILE_UPLOAD = 21354;
    private ValueCallback<Uri> mUriUploadCallback;
    private ValueCallback<Uri[]> mUriArrayUploadCallback;
    private ChatWindowConfiguration config;
    private boolean initialized;

    public static ChatWindowView createAndAttachChatWindowInstance(@NonNull Activity activity) {
        ViewGroup contentView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        ChatWindowView chatWindowView = (ChatWindowView)LayoutInflater.from((Context)activity).inflate(R.layout.view_chat_window, contentView, false);
        contentView.addView((View)chatWindowView, -1, -1);
        return chatWindowView;
    }

    public ChatWindowView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public ChatWindowView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setFitsSystemWindows(true);
        this.setVisibility(8);
        LayoutInflater.from((Context)context).inflate(R.layout.view_chat_window_internal, (ViewGroup)this, true);
        this.webView = (WebView)this.findViewById(R.id.chat_window_web_view);
        this.statusText = (TextView)this.findViewById(R.id.chat_window_status_text);
        this.progressBar = (ProgressBar)this.findViewById(R.id.chat_window_progress);
        this.reloadButton = (Button)this.findViewById(R.id.chat_window_button);
        this.reloadButton.setOnClickListener((View.OnClickListener)this);
        if (Build.VERSION.RELEASE.matches("4\\.4(\\.[12])?")) {
            String userAgentString = this.webView.getSettings().getUserAgentString();
            this.webView.getSettings().setUserAgentString(userAgentString + " AndroidNoFilesharing");
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        this.webView.setFocusable(true);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.getInstance().setAcceptThirdPartyCookies(this.webView, true);
        }
        this.webView.setWebViewClient((WebViewClient)new LCWebViewClient());
        this.webView.setWebChromeClient((WebChromeClient)new LCWebChromeClient());
        this.webView.requestFocus(130);
        this.webView.setVisibility(8);
        this.webView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: 
                    case 1: {
                        if (v.hasFocus()) break;
                        v.requestFocus();
                    }
                }
                return false;
            }
        });
        this.webView.addJavascriptInterface((Object)new ChatWindowJsInterface(this), "androidMobileWidget");
    }

    public void onClick(View view) {
        this.loadWebViewContentTask.cancel(true);
        this.webView.setVisibility(8);
        this.progressBar.setVisibility(0);
        this.statusText.setVisibility(8);
        this.reloadButton.setVisibility(8);
        this.initialized = false;
        this.initialize();
    }

    public void setUpListener(ChatWindowEventsListener listener) {
        this.chatWindowListener = listener;
    }

    public void initialize() {
        this.checkConfiguration();
        this.initialized = true;
        this.loadWebViewContentTask = new LoadWebViewContentTask(this.webView, this.progressBar, this.statusText, this.reloadButton);
        this.loadWebViewContentTask.execute(new Map[]{this.config.getParams()});
    }

    private void checkConfiguration() {
        if (this.config == null) {
            throw new IllegalStateException("Config must be provide before initialization");
        }
        if (this.initialized) {
            throw new IllegalStateException("Chat Window already initialized");
        }
    }

    public void onHideChatWindow() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ChatWindowView.this.hideChatWindow();
            }
        });
    }

    @Override
    public void showChatWindow() {
        this.setVisibility(0);
        if (this.chatWindowListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowView.this.chatWindowListener.onChatWindowVisibilityChanged(true);
                }
            });
        }
    }

    @Override
    public void hideChatWindow() {
        this.setVisibility(8);
        if (this.chatWindowListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowView.this.chatWindowListener.onChatWindowVisibilityChanged(false);
                }
            });
        }
    }

    @Override
    public boolean onBackPressed() {
        if (this.isShown()) {
            this.onHideChatWindow();
            return true;
        }
        return false;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 21354) {
            if (resultCode == -1 && data != null) {
                this.receiveUploadedData(data);
            } else {
                this.resetAllUploadCallbacks();
            }
            return true;
        }
        return false;
    }

    private void receiveUploadedData(Intent data) {
        if (this.isUriArrayUpload()) {
            this.receiveUploadedUriArray(data);
        } else if (this.isVersionPreHoneycomb()) {
            this.receiveUploadedUriPreHoneycomb(data);
        } else {
            this.receiveUploadedUri(data);
        }
    }

    private boolean isUriArrayUpload() {
        return this.mUriArrayUploadCallback != null;
    }

    private boolean isVersionPreHoneycomb() {
        return Build.VERSION.SDK_INT < 11;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void setUpWindow(ChatWindowConfiguration configuration) {
        this.config = configuration;
    }

    public void onUiReady() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ChatWindowView.this.hideProgressBar();
            }
        });
    }

    private void hideProgressBar() {
        this.progressBar.setVisibility(8);
    }

    public void onNewMessageReceived(final NewMessageModel newMessageModel) {
        if (this.chatWindowListener != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowView.this.chatWindowListener.onNewMessage(newMessageModel, ChatWindowView.this.isShown());
                }
            });
        }
    }

    private void receiveUploadedUriArray(Intent data) {
        Uri[] uploadedUris;
        try {
            uploadedUris = new Uri[]{Uri.parse((String)data.getDataString())};
        }
        catch (Exception e) {
            uploadedUris = null;
        }
        this.mUriArrayUploadCallback.onReceiveValue(uploadedUris);
        this.mUriArrayUploadCallback = null;
    }

    private void receiveUploadedUriPreHoneycomb(Intent data) {
        Uri uploadedUri = data.getData();
        this.mUriUploadCallback.onReceiveValue((Object)uploadedUri);
        this.mUriUploadCallback = null;
    }

    private void receiveUploadedUri(Intent data) {
        Uri uploadedFileUri;
        try {
            String uploadedUriFilePath = UriUtils.getFilePathFromUri(this.getContext(), data.getData());
            File uploadedFile = new File(uploadedUriFilePath);
            uploadedFileUri = Uri.fromFile((File)uploadedFile);
        }
        catch (Exception e) {
            uploadedFileUri = null;
        }
        this.mUriUploadCallback.onReceiveValue(uploadedFileUri);
        this.mUriUploadCallback = null;
    }

    private void resetAllUploadCallbacks() {
        this.resetUriUploadCallback();
        this.resetUriArrayUploadCallback();
    }

    private void resetUriUploadCallback() {
        if (this.mUriUploadCallback != null) {
            this.mUriUploadCallback.onReceiveValue(null);
            this.mUriUploadCallback = null;
        }
    }

    private void resetUriArrayUploadCallback() {
        if (this.mUriArrayUploadCallback != null) {
            this.mUriArrayUploadCallback.onReceiveValue(null);
            this.mUriArrayUploadCallback = null;
        }
    }

    private void chooseUriToUpload(ValueCallback<Uri> uriValueCallback) {
        this.resetAllUploadCallbacks();
        this.mUriUploadCallback = uriValueCallback;
        this.startFileChooserActivity();
    }

    private void chooseUriArrayToUpload(ValueCallback<Uri[]> uriArrayValueCallback) {
        this.resetAllUploadCallbacks();
        this.mUriArrayUploadCallback = uriArrayValueCallback;
        this.startFileChooserActivity();
    }

    private void startFileChooserActivity() {
        if (this.chatWindowListener != null) {
            Intent intent = new Intent("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
            intent.setType("*/*");
            this.chatWindowListener.onStartFilePickerActivity(intent, 21354);
        } else {
            Log.e((String)"ChatWindowView", (String)"You must provide a listener to handle file sharing");
            Toast.makeText((Context)this.getContext(), (int)R.string.cant_share_files, (int)0).show();
        }
    }

    public static interface ChatWindowEventsListener {
        public void onChatWindowVisibilityChanged(boolean var1);

        public void onNewMessage(NewMessageModel var1, boolean var2);

        public void onStartFilePickerActivity(Intent var1, int var2);

        public boolean handleUri(Uri var1);
    }

    class LCWebChromeClient
    extends WebChromeClient {
        LCWebChromeClient() {
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            ChatWindowView.this.webViewPopup = new WebView(ChatWindowView.this.getContext());
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.getInstance().setAcceptThirdPartyCookies(ChatWindowView.this.webViewPopup, true);
            }
            ChatWindowView.this.webViewPopup.setVerticalScrollBarEnabled(false);
            ChatWindowView.this.webViewPopup.setHorizontalScrollBarEnabled(false);
            ChatWindowView.this.webViewPopup.setWebViewClient((WebViewClient)new LCWebViewClient());
            ChatWindowView.this.webViewPopup.getSettings().setJavaScriptEnabled(true);
            ChatWindowView.this.webViewPopup.getSettings().setSavePassword(false);
            ChatWindowView.this.webViewPopup.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            ChatWindowView.this.addView((View)ChatWindowView.this.webViewPopup);
            WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
            transport.setWebView(ChatWindowView.this.webViewPopup);
            resultMsg.sendToTarget();
            return true;
        }

        public void onCloseWindow(WebView window) {
            Log.d((String)"onCloseWindow", (String)"called");
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            ChatWindowView.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
            ChatWindowView.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
            ChatWindowView.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> uploadMsg, WebChromeClient.FileChooserParams fileChooserParams) {
            ChatWindowView.this.chooseUriArrayToUpload((ValueCallback<Uri[]>)uploadMsg);
            return true;
        }
    }

    class LCWebViewClient
    extends WebViewClient {
        LCWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            if (url.startsWith("https://www.facebook.com/dialog/return/arbiter") && ChatWindowView.this.webViewPopup != null) {
                ChatWindowView.this.webViewPopup.setVisibility(8);
                ChatWindowView.this.removeView((View)ChatWindowView.this.webViewPopup);
                ChatWindowView.this.webViewPopup = null;
            }
            super.onPageFinished(view, url);
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            ChatWindowView.this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowView.this.progressBar.setVisibility(8);
                    ChatWindowView.this.webView.setVisibility(8);
                    ChatWindowView.this.statusText.setVisibility(0);
                }
            });
            super.onReceivedError(view, request, error);
            Log.e((String)"ChatWindow Widget", (String)("onReceivedError: " + error + " request: " + request));
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            ChatWindowView.this.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowView.this.progressBar.setVisibility(8);
                    ChatWindowView.this.webView.setVisibility(8);
                    ChatWindowView.this.statusText.setVisibility(0);
                }
            });
            super.onReceivedError(view, errorCode, description, failingUrl);
            Log.e((String)"ChatWindow Widget", (String)("onReceivedError: " + errorCode + " d: " + description + " url: " + failingUrl));
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Uri uri = Uri.parse((String)url);
            return this.handleUri(view, uri);
        }

        @TargetApi(value=24)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            Uri uri = request.getUrl();
            return this.handleUri(view, uri);
        }

        private boolean handleUri(WebView webView, Uri uri) {
            String originalUrl;
            String uriString = uri.toString();
            boolean facebookLogin = uriString.matches("https://.+facebook.+(/dialog/oauth\\?|/login\\.php\\?|/dialog/return/arbiter\\?).+");
            if (facebookLogin) {
                return false;
            }
            if (ChatWindowView.this.webViewPopup != null) {
                ChatWindowView.this.webViewPopup.setVisibility(8);
                ChatWindowView.this.removeView((View)ChatWindowView.this.webViewPopup);
                ChatWindowView.this.webViewPopup = null;
            }
            if (uriString.equals(originalUrl = webView.getOriginalUrl())) {
                return false;
            }
            if (ChatWindowView.this.chatWindowListener == null || !ChatWindowView.this.chatWindowListener.handleUri(uri)) {
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                ChatWindowView.this.getContext().startActivity(intent);
            }
            return true;
        }
    }
}

