/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.chatsdk.src.core.managers;

import android.view.View;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/livechatinc/chatsdk/src/core/managers/WindowInsetManager;", "", "rootView", "Landroid/view/View;", "<init>", "(Landroid/view/View;)V", "insetsAnimationRunning", "", "setupInsets", "", "handleStaticInsets", "v", "insets", "Landroidx/core/view/WindowInsetsCompat;", "setupKeyboardAnimationCallback", "chat-sdk_release"})
public final class WindowInsetManager {
    @NotNull
    private final View rootView;
    private boolean insetsAnimationRunning;

    public WindowInsetManager(@NotNull View rootView) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        this.rootView = rootView;
    }

    public final void setupInsets() {
        ViewCompat.setOnApplyWindowInsetsListener((View)this.rootView, (arg_0, arg_1) -> WindowInsetManager.setupInsets$lambda$0(this, arg_0, arg_1));
        this.setupKeyboardAnimationCallback();
    }

    private final void handleStaticInsets(View v, WindowInsetsCompat insets) {
        Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.systemBars());
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
        Insets systemBars = insets2;
        Insets insets3 = insets.getInsets(WindowInsetsCompat.Type.ime());
        Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"getInsets(...)");
        Insets ime = insets3;
        if (ime.bottom == 0 && !this.insetsAnimationRunning) {
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
        }
    }

    private final void setupKeyboardAnimationCallback() {
        ViewCompat.setWindowInsetsAnimationCallback((View)this.rootView, (WindowInsetsAnimationCompat.Callback)new WindowInsetsAnimationCompat.Callback(this){
            final /* synthetic */ WindowInsetManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public void onPrepare(WindowInsetsAnimationCompat animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                WindowInsetManager.access$setInsetsAnimationRunning$p(this.this$0, true);
                super.onPrepare(animation);
            }

            public WindowInsetsCompat onProgress(WindowInsetsCompat insets, List<WindowInsetsAnimationCompat> runningAnimations) {
                Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
                Intrinsics.checkNotNullParameter(runningAnimations, (String)"runningAnimations");
                this.applyAnimatedInsets(insets);
                return insets;
            }

            private final void applyAnimatedInsets(WindowInsetsCompat insets) {
                Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.systemBars());
                Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
                Insets systemBars = insets2;
                Insets insets3 = insets.getInsets(WindowInsetsCompat.Type.ime());
                Intrinsics.checkNotNullExpressionValue((Object)insets3, (String)"getInsets(...)");
                Insets ime = insets3;
                WindowInsetManager.access$getRootView$p(this.this$0).setPadding(systemBars.left, systemBars.top, systemBars.right, Math.max(ime.bottom, systemBars.bottom));
            }

            public void onEnd(WindowInsetsAnimationCompat animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                WindowInsetManager.access$setInsetsAnimationRunning$p(this.this$0, false);
                super.onEnd(animation);
            }
        });
    }

    private static final WindowInsetsCompat setupInsets$lambda$0(WindowInsetManager this$0, View v, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        this$0.handleStaticInsets(v, insets);
        return insets;
    }

    public static final /* synthetic */ void access$setInsetsAnimationRunning$p(WindowInsetManager $this, boolean bl) {
        $this.insetsAnimationRunning = bl;
    }

    public static final /* synthetic */ View access$getRootView$p(WindowInsetManager $this) {
        return $this.rootView;
    }
}

