/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.chatsdk.src.presentation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.activity.ComponentActivity;
import androidx.annotation.MainThread;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.livechatinc.chatsdk.LiveChat;
import com.livechatinc.chatsdk.R;
import com.livechatinc.chatsdk.src.core.LiveChatViewLifecycleScope;
import com.livechatinc.chatsdk.src.domain.interfaces.LiveChatViewInternal;
import com.livechatinc.chatsdk.src.domain.models.FilePickerMode;
import com.livechatinc.chatsdk.src.domain.models.LiveChatConfig;
import com.livechatinc.chatsdk.src.domain.presenters.LiveChatViewPresenter;
import com.livechatinc.chatsdk.src.utils.FileSharing;
import com.livechatinc.chatsdk.src.utils.Logger;
import com.livechatinc.chatsdk.src.utils.webview.LiveChatViewChromeClient;
import com.livechatinc.chatsdk.src.utils.webview.LiveChatViewJSBridge;
import com.livechatinc.chatsdk.src.utils.webview.LiveChatViewWebViewClient;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003ABCB\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010 \u001a\u00020\u00152\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0016J&\u0010)\u001a\u00020\u00152\u0014\u0010*\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0,\u0018\u00010+2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00152\u0006\u00101\u001a\u00020-H\u0016J\u001a\u00102\u001a\u00020\u00152\b\u00103\u001a\u0004\u0018\u00010(2\u0006\u00104\u001a\u00020(H\u0016J\b\u00105\u001a\u000206H\u0016J\u0006\u00107\u001a\u00020\u0015J\u0010\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u0013H\u0016J\u0010\u0010:\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u0013H\u0016J\u0010\u0010;\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u0013H\u0016J\b\u0010<\u001a\u00020\u0015H\u0014J\b\u0010=\u001a\u00020>H\u0014J\u0012\u0010?\u001a\u00020\u00152\b\u0010@\u001a\u0004\u0018\u00010>H\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/livechatinc/chatsdk/src/presentation/LiveChatView;", "Landroid/widget/FrameLayout;", "Lcom/livechatinc/chatsdk/src/domain/interfaces/LiveChatViewInternal;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "fileSharing", "Lcom/livechatinc/chatsdk/src/utils/FileSharing;", "webView", "Landroid/webkit/WebView;", "presenter", "Lcom/livechatinc/chatsdk/src/domain/presenters/LiveChatViewPresenter;", "activityContextRef", "Ljava/lang/ref/WeakReference;", "currentLifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "configureWebView", "", "attachTo", "activity", "Landroidx/activity/ComponentActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "detachCurrentLifecycleOwner", "setupFileSharing", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "setWebViewBackgroundColor", "init", "initListener", "Lcom/livechatinc/chatsdk/src/presentation/LiveChatView$InitListener;", "setOnHideListener", "onHideListener", "Lcom/livechatinc/chatsdk/src/presentation/LiveChatView$OnHideListener;", "loadUrl", "url", "", "startFilePicker", "filePathCallback", "Landroid/webkit/ValueCallback;", "", "Landroid/net/Uri;", "filePickerMode", "Lcom/livechatinc/chatsdk/src/domain/models/FilePickerMode;", "launchExternalBrowser", "uri", "postWebViewMessage", "callback", "data", "isChatShown", "", "clearCallbackListeners", "onResume", "owner", "onPause", "onDestroy", "onDetachedFromWindow", "onSaveInstanceState", "Landroid/os/Parcelable;", "onRestoreInstanceState", "state", "Companion", "InitListener", "OnHideListener", "chat-sdk_release"})
@SuppressLint(value={"SetJavaScriptEnabled"})
@SourceDebugExtension(value={"SMAP\nLiveChatView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveChatView.kt\ncom/livechatinc/chatsdk/src/presentation/LiveChatView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
public final class LiveChatView
extends FrameLayout
implements LiveChatViewInternal,
DefaultLifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FileSharing fileSharing;
    @NotNull
    private WebView webView;
    @NotNull
    private LiveChatViewPresenter presenter;
    @Nullable
    private WeakReference<Context> activityContextRef;
    @Nullable
    private LifecycleOwner currentLifecycleOwner;
    @NotNull
    private static final String KEY_WEBVIEW_STATE = "webViewState";
    @NotNull
    private static final String KEY_SUPER_STATE = "superState";

    public LiveChatView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        FrameLayout.inflate((Context)context, (int)R.layout.live_chat_widget_internal, (ViewGroup)((ViewGroup)this));
        this.webView = (WebView)this.findViewById(R.id.live_chat_webview);
        this.presenter = new LiveChatViewPresenter(this, LiveChat.Companion.getInstance().getNetworkClient$chat_sdk_release());
        this.configureWebView();
    }

    private final void configureWebView() {
        WebSettings webSettings = this.webView.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)webSettings, (String)"getSettings(...)");
        WebSettings webSettings2 = webSettings;
        webSettings2.setJavaScriptEnabled(true);
        webSettings2.setDomStorageEnabled(true);
        webSettings2.setMediaPlaybackRequiresUserGesture(false);
        webSettings2.setCacheMode(-1);
        this.webView.setWebChromeClient((WebChromeClient)new LiveChatViewChromeClient(this.presenter));
        this.webView.setWebViewClient((WebViewClient)new LiveChatViewWebViewClient(this.presenter));
        this.webView.addJavascriptInterface((Object)new LiveChatViewJSBridge(this.presenter), LiveChatViewJSBridge.Companion.getINTERFACE_NAME());
    }

    public final void attachTo(@NotNull ComponentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.detachCurrentLifecycleOwner();
        this.activityContextRef = new WeakReference<ComponentActivity>(activity);
        this.currentLifecycleOwner = (LifecycleOwner)activity;
        activity.getLifecycle().addObserver((LifecycleObserver)this);
        this.setupFileSharing(activity, activity.getLifecycle());
        this.setWebViewBackgroundColor((Context)activity);
    }

    public final void attachTo(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        FragmentActivity fragmentActivity = fragment.requireActivity();
        ComponentActivity componentActivity = fragmentActivity instanceof ComponentActivity ? (ComponentActivity)fragmentActivity : null;
        if (componentActivity == null) {
            throw new IllegalArgumentException("Fragment must be attached to a ComponentActivity");
        }
        ComponentActivity activity = componentActivity;
        this.detachCurrentLifecycleOwner();
        this.activityContextRef = new WeakReference<ComponentActivity>(activity);
        this.currentLifecycleOwner = (LifecycleOwner)fragment;
        activity.getLifecycle().addObserver((LifecycleObserver)this);
        Lifecycle lifecycle = fragment.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"<get-lifecycle>(...)");
        this.setupFileSharing(activity, lifecycle);
        Context context = fragment.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext(...)");
        this.setWebViewBackgroundColor(context);
    }

    private final void detachCurrentLifecycleOwner() {
        WeakReference<Context> weakReference = this.activityContextRef;
        if (weakReference != null) {
            weakReference.clear();
        }
        this.activityContextRef = null;
        LifecycleOwner lifecycleOwner = this.currentLifecycleOwner;
        if (lifecycleOwner != null) {
            LifecycleOwner owner = lifecycleOwner;
            boolean bl = false;
            owner.getLifecycle().removeObserver((LifecycleObserver)this);
            FileSharing fileSharing = this.fileSharing;
            if (fileSharing != null) {
                FileSharing fs = fileSharing;
                boolean bl2 = false;
                owner.getLifecycle().removeObserver((LifecycleObserver)fs);
            }
        }
        this.fileSharing = null;
        this.currentLifecycleOwner = null;
    }

    private final void setupFileSharing(ComponentActivity activity, Lifecycle lifecycle) {
        FileSharing fileSharing = this.fileSharing = new FileSharing(activity.getActivityResultRegistry(), this.presenter);
        Intrinsics.checkNotNull((Object)fileSharing);
        lifecycle.addObserver((LifecycleObserver)fileSharing);
    }

    private final void setWebViewBackgroundColor(Context context) {
        int[] nArray = new int[]{16842836};
        TypedArray typedArray = context.obtainStyledAttributes(nArray);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        int backgroundColor = typedArray2.getColor(0, -1);
        typedArray2.recycle();
        this.webView.setBackgroundColor(backgroundColor);
    }

    public final void init(@Nullable InitListener initListener) {
        if (initListener != null) {
            this.presenter.setInitListener(initListener);
        }
        LiveChatConfig config = LiveChat.Companion.getInstance().createLiveChatConfig$chat_sdk_release();
        this.presenter.init(config);
    }

    public static /* synthetic */ void init$default(LiveChatView liveChatView, InitListener initListener, int n, Object object) {
        if ((n & 1) != 0) {
            initListener = null;
        }
        liveChatView.init(initListener);
    }

    public final void setOnHideListener(@NotNull OnHideListener onHideListener) {
        Intrinsics.checkNotNullParameter((Object)onHideListener, (String)"onHideListener");
        this.presenter.setOnHideListener(onHideListener);
    }

    @Override
    public void loadUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.webView.loadUrl(url);
    }

    @Override
    public void startFilePicker(@Nullable ValueCallback<Uri[]> filePathCallback, @NotNull FilePickerMode filePickerMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)filePickerMode), (String)"filePickerMode");
        if (this.fileSharing == null) {
            Logger.e$default("File sharing is not set up. Call attachTo() to set it up", null, null, 6, null);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[filePickerMode.ordinal()]) {
            case 1: {
                FileSharing fileSharing = this.fileSharing;
                if (fileSharing != null) {
                    fileSharing.selectFile(filePathCallback);
                }
                break;
            }
            case 2: {
                FileSharing fileSharing = this.fileSharing;
                if (fileSharing != null) {
                    fileSharing.selectFiles(filePathCallback);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void launchExternalBrowser(@NotNull Uri uri) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Context context = this.activityContextRef;
            if (context == null || (context = (Context)context.get()) == null) break block0;
            context.startActivity(intent);
        }
    }

    @Override
    public void postWebViewMessage(@Nullable String callback, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Logger.d$default("### --> post message: " + callback + ", " + data, null, 2, null);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback, data, null){
            int label;
            final /* synthetic */ LiveChatView this$0;
            final /* synthetic */ String $callback;
            final /* synthetic */ String $data;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                this.$data = $data;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        LiveChatView.access$getWebView$p(this.this$0).evaluateJavascript("javascript:" + this.$callback + '(' + this.$data + ')', null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public boolean isChatShown() {
        return this.isShown();
    }

    public final void clearCallbackListeners() {
        this.presenter.setInitListener(null);
        this.presenter.setOnHideListener(null);
    }

    public void onResume(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onResume(owner);
        this.webView.onResume();
        this.webView.resumeTimers();
    }

    public void onPause(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.webView.onPause();
        super.onPause(owner);
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        if (Intrinsics.areEqual((Object)owner, (Object)this.currentLifecycleOwner)) {
            this.detachCurrentLifecycleOwner();
        }
        super.onStop(owner);
    }

    protected void onDetachedFromWindow() {
        if (LiveChat.Companion.getInstance().getLiveChatViewLifecycleScope$chat_sdk_release() == LiveChatViewLifecycleScope.ACTIVITY) {
            WebView webView;
            WebView $this$onDetachedFromWindow_u24lambda_u242 = webView = this.webView;
            boolean bl = false;
            $this$onDetachedFromWindow_u24lambda_u242.removeJavascriptInterface(LiveChatViewJSBridge.Companion.getINTERFACE_NAME());
            $this$onDetachedFromWindow_u24lambda_u242.setWebChromeClient(null);
            $this$onDetachedFromWindow_u24lambda_u242.destroy();
        }
        super.onDetachedFromWindow();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Parcelable onSaveInstanceState() {
        void it;
        Bundle bundle;
        Bundle bundle2;
        Parcelable superState = super.onSaveInstanceState();
        Bundle $this$onSaveInstanceState_u24lambda_u244 = bundle2 = new Bundle();
        boolean bl = false;
        $this$onSaveInstanceState_u24lambda_u244.putParcelable(KEY_SUPER_STATE, superState);
        Bundle bundle3 = bundle = new Bundle();
        String string = KEY_WEBVIEW_STATE;
        Bundle bundle4 = $this$onSaveInstanceState_u24lambda_u244;
        boolean bl2 = false;
        this.webView.saveState((Bundle)it);
        Unit unit = Unit.INSTANCE;
        bundle4.putBundle(string, bundle);
        return (Parcelable)bundle2;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = ((Bundle)state).getBundle(KEY_WEBVIEW_STATE);
            if (bundle != null) {
                Bundle it = bundle;
                boolean bl = false;
                this.webView.restoreState(it);
            }
            super.onRestoreInstanceState(((Bundle)state).getParcelable(KEY_SUPER_STATE));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public static final /* synthetic */ WebView access$getWebView$p(LiveChatView $this) {
        return $this.webView;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/livechatinc/chatsdk/src/presentation/LiveChatView$Companion;", "", "<init>", "()V", "KEY_WEBVIEW_STATE", "", "KEY_SUPER_STATE", "chat-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lcom/livechatinc/chatsdk/src/presentation/LiveChatView$InitListener;", "", "onUIReady", "", "onError", "cause", "", "chat-sdk_release"})
    public static interface InitListener {
        @MainThread
        public void onUIReady();

        @MainThread
        public void onError(@NotNull Throwable var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004"}, d2={"Lcom/livechatinc/chatsdk/src/presentation/LiveChatView$OnHideListener;", "", "onHide", "", "chat-sdk_release"})
    public static interface OnHideListener {
        @MainThread
        public void onHide();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilePickerMode.values().length];
            try {
                nArray[FilePickerMode.SINGLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilePickerMode.MULTIPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

