/*
 * Decompiled with CFR 0.152.
 */
package com.rxhttp.compiler.ksp;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.symbol.KSFile;
import com.rxhttp.compiler.VariablesKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/rxhttp/compiler/ksp/KClassHelper;", "", "isAndroidPlatform", "", "<init>", "(Z)V", "isAndroid", "", "s", "generatorStaticClass", "", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "generatorRxHttpAbstractBodyParam", "generatorRxHttpNoBodyParam", "generatorRxHttpBodyParam", "generatorRxHttpFormParam", "generatorRxHttpJsonParam", "generatorRxHttpJsonArrayParam", "generatorClass", "className", "content", "rxhttp-compiler"})
@SourceDebugExtension(value={"SMAP\nKClassHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KClassHelper.kt\ncom/rxhttp/compiler/ksp/KClassHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,438:1\n37#2:439\n36#2,3:440\n*S KotlinDebug\n*F\n+ 1 KClassHelper.kt\ncom/rxhttp/compiler/ksp/KClassHelper\n*L\n431#1:439\n431#1:440,3\n*E\n"})
public final class KClassHelper {
    private final boolean isAndroidPlatform;

    public KClassHelper(boolean isAndroidPlatform) {
        this.isAndroidPlatform = isAndroidPlatform;
    }

    private final String isAndroid(String s) {
        return this.isAndroidPlatform ? s : "";
    }

    public final void generatorStaticClass(@NotNull CodeGenerator codeGenerator) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        this.generatorRxHttpAbstractBodyParam(codeGenerator);
        this.generatorRxHttpBodyParam(codeGenerator);
        this.generatorRxHttpFormParam(codeGenerator);
        this.generatorRxHttpNoBodyParam(codeGenerator);
        this.generatorRxHttpJsonParam(codeGenerator);
        this.generatorRxHttpJsonArrayParam(codeGenerator);
    }

    private final void generatorRxHttpAbstractBodyParam(CodeGenerator codeGenerator) {
        this.generatorClass(codeGenerator, "RxHttpAbstractBodyParam", StringsKt.trimIndent((String)("\n                package " + VariablesKt.getRxHttpPackage() + "\n                \n                import rxhttp.wrapper.BodyParamFactory\n                import rxhttp.wrapper.param.AbstractBodyParam\n\n                /**\n                 * Github\n                 * https://github.com/liujingxing/rxhttp\n                 * https://github.com/liujingxing/rxlife\n                 * https://github.com/liujingxing/rxhttp/wiki/FAQ\n                 * https://github.com/liujingxing/rxhttp/wiki/\u66f4\u65b0\u65e5\u5fd7\n                 */\n                open class RxHttpAbstractBodyParam<P : AbstractBodyParam<P>, R : RxHttpAbstractBodyParam<P, R>> \n                protected constructor(\n                    param: P\n                ) : RxHttp<P, R>(param), BodyParamFactory {\n\n                }\n            ")));
    }

    private final void generatorRxHttpNoBodyParam(CodeGenerator codeGenerator) {
        this.generatorClass(codeGenerator, "RxHttpNoBodyParam", StringsKt.trimIndent((String)("\n            package " + VariablesKt.getRxHttpPackage() + "\n\n            import rxhttp.wrapper.param.NoBodyParam\n\n            /**\n             * Github\n             * https://github.com/liujingxing/rxhttp\n             * https://github.com/liujingxing/rxlife\n             * https://github.com/liujingxing/rxhttp/wiki/FAQ\n             * https://github.com/liujingxing/rxhttp/wiki/\u66f4\u65b0\u65e5\u5fd7\n             */\n            open class RxHttpNoBodyParam(param: NoBodyParam) : RxHttp<NoBodyParam, RxHttpNoBodyParam>(param) {\n            \n                @JvmOverloads\n                fun add(key: String, value: Any?, add: Boolean = true) = apply {\n                    if (add) addQuery(key, value)\n                }\n            \n                fun addAll(map: Map<String, *>) = addAllQuery(map)\n            \n                fun addEncoded(key: String, value: Any?) = addEncodedQuery(key, value)\n            \n                fun addAllEncoded(map: Map<String, *>) = addAllEncodedQuery(map)\n            }\n\n        ")));
    }

    private final void generatorRxHttpBodyParam(CodeGenerator codeGenerator) {
        this.generatorClass(codeGenerator, "RxHttpBodyParam", StringsKt.trimIndent((String)("\n            package " + VariablesKt.getRxHttpPackage() + "\n            " + this.isAndroid("\n            import android.content.Context\n            import android.net.Uri\n            import rxhttp.wrapper.entity.UriRequestBody\n            ") + "\n            import okhttp3.MediaType\n            import okhttp3.RequestBody\n            import okio.ByteString\n            import rxhttp.wrapper.param.BodyParam\n            import rxhttp.wrapper.OkHttpCompat\n            import rxhttp.wrapper.entity.FileRequestBody\n            import rxhttp.wrapper.utils.BuildUtil\n            import java.io.File\n\n            /**\n             * Github\n             * https://github.com/liujingxing/rxhttp\n             * https://github.com/liujingxing/rxlife\n             */\n            open class RxHttpBodyParam(param: BodyParam) : RxHttpAbstractBodyParam<BodyParam, RxHttpBodyParam>(param) {\n\n                fun setBody(content: String, contentType: MediaType? = null) =\n                    setBody(OkHttpCompat.create(contentType, content))\n\n                fun setBody(content: ByteString, contentType: MediaType? = null) =\n                    setBody(OkHttpCompat.create(contentType, content))\n\n                @JvmOverloads\n                fun setBody(\n                    content: ByteArray,\n                    contentType: MediaType? = null,\n                    offset: Int = 0,\n                    byteCount: Int = content.size,\n                ) = setBody(OkHttpCompat.create(contentType, content, offset, byteCount))\n\n                @JvmOverloads\n                fun setBody(\n                    file: File,\n                    contentType: MediaType? = BuildUtil.getMediaType(file.name),\n                ) = setBody(FileRequestBody(file, 0, contentType))\n                " + this.isAndroid("\n                @JvmOverloads\n                fun setBody(\n                    context: Context,\n                    uri: Uri,\n                    contentType: MediaType? = BuildUtil.getMediaTypeByUri(context, uri),\n                ) = setBody(UriRequestBody(context, uri, 0, contentType))\n                ") + "\n                //Content-Type: application/json; charset=utf-8\n                fun setBody(any: Any) = apply { param.setBody(any) }\n\n                fun setBody(requestBody: RequestBody) = apply { param.setBody(requestBody) }\n            }\n\n        ")));
    }

    private final void generatorRxHttpFormParam(CodeGenerator codeGenerator) {
        this.generatorClass(codeGenerator, "RxHttpFormParam", StringsKt.trimIndent((String)("\n            package " + VariablesKt.getRxHttpPackage() + "\n\n            " + this.isAndroid("import android.content.Context") + "\n            " + this.isAndroid("import android.net.Uri") + "\n            " + this.isAndroid("import rxhttp.wrapper.entity.UriRequestBody") + "\n            import okhttp3.Headers\n            import okhttp3.MediaType\n            import okhttp3.MultipartBody\n            import okhttp3.RequestBody\n            import rxhttp.wrapper.OkHttpCompat\n            import rxhttp.wrapper.entity.FileRequestBody\n            import rxhttp.wrapper.entity.UpFile\n            import rxhttp.wrapper.param.FormParam\n            import rxhttp.wrapper.utils.BuildUtil\n            import rxhttp.wrapper.utils.displayName\n            import java.io.File\n\n\n            /**\n             * Github\n             * https://github.com/liujingxing/rxhttp\n             * https://github.com/liujingxing/rxlife\n             * https://github.com/liujingxing/rxhttp/wiki/FAQ\n             * https://github.com/liujingxing/rxhttp/wiki/\u66f4\u65b0\u65e5\u5fd7\n             */\n            open class RxHttpFormParam(param: FormParam) : RxHttpAbstractBodyParam<FormParam, RxHttpFormParam>(param) {\n                \n                @JvmOverloads\n                fun add(key: String, value: Any?, add: Boolean = true) = apply {\n                    if (add) param.add(key, value)\n                }    \n\n                fun addAll(map: Map<String, *>) = apply { param.addAll(map) }\n\n                fun addEncoded(key: String, value: Any?) = apply { param.addEncoded(key, value) }\n\n                fun addAllEncoded(map: Map<String, *>) = apply { param.addAllEncoded(map) }\n\n                fun removeAllBody() = apply { param.removeAllBody() }\n\n                fun removeAllBody(key: String) = apply { param.removeAllBody(key) }\n\n                fun set(key: String, value: Any?) = apply { param[key] = value }\n\n                fun setEncoded(key: String, value: Any?) = apply { param.setEncoded(key, value) }\n\n                fun addFile(key: String, filePath: String?) = \n                    if (filePath == null) this else addFile(key, File(filePath))\n\n                @JvmOverloads\n                fun addFile(key: String, file: File?, filename: String? = file?.name) =\n                    if (file == null) this else addFile(UpFile(key, file, filename))\n\n                fun addFiles(fileList: List<UpFile>) = apply { fileList.forEach { addFile(it) } }\n\n                fun <T> addFiles(fileMap: Map<String, T>) = apply {\n                    fileMap.forEach { (key, value) -> addFile(key, value) }\n                }\n\n                fun <T> addFiles(key: String, files: List<T>) = apply {\n                    files.forEach { addFile(key, it) }\n                }\n\n                private fun addFile(key: String, file: Any?) {\n                    if (file is File) {\n                        addFile(key, file)\n                    } else if (file is String) {\n                        addFile(key, file)\n                    } else if (file != null) {\n                        throw IllegalArgumentException(\"Incoming data type exception, it must be String or File\")\n                    }\n                }\n\n                fun addFile(upFile: UpFile) = apply {\n                    val requestBody = FileRequestBody(upFile.file, upFile.skipSize, BuildUtil.getMediaType(upFile.filename))\n                    return addFormDataPart(upFile.key, upFile.filename, requestBody)\n                }\n\n                @JvmOverloads\n                fun addPart(\n                    content: ByteArray,\n                    contentType: MediaType? = null,\n                    offset: Int = 0,\n                    byteCount: Int = content.size\n                ) = addPart(OkHttpCompat.create(contentType, content, offset, byteCount))\n                " + this.isAndroid("\n                @JvmOverloads\n                fun addPart(\n                    context: Context,\n                    uri: Uri,\n                    contentType: MediaType? = BuildUtil.getMediaTypeByUri(context, uri)\n                ) = addPart(UriRequestBody(context, uri, 0, contentType))\n\n                @JvmOverloads\n                fun addPart(\n                    context: Context,\n                    key: String,\n                    uri: Uri,\n                    contentType: MediaType? = BuildUtil.getMediaTypeByUri(context, uri)\n                ) = addPart(context, key, uri.displayName(context), uri, contentType)\n\n                @JvmOverloads\n                fun addPart(\n                    context: Context,\n                    key: String,\n                    filename: String?,\n                    uri: Uri,\n                    contentType: MediaType? = BuildUtil.getMediaTypeByUri(context, uri)\n                ) = addFormDataPart(key, filename, UriRequestBody(context, uri, 0, contentType))\n\n                fun addParts(context: Context, uriMap: Map<String, Uri>) = apply {\n                    uriMap.forEach { (key, value) -> addPart(context, key, value) }\n                }\n\n                fun addParts(context: Context, uris: List<Uri>) = apply {\n                    uris.forEach { addPart(context, it) }\n                }\n\n                fun addParts(context: Context, uris: List<Uri>, contentType: MediaType?) = apply {\n                    uris.forEach { addPart(context, it, contentType) }\n                }\n\n                fun addParts(context: Context, key: String, uris: List<Uri>) = apply {\n                    uris.forEach { addPart(context, key, it) }\n                }\n\n                fun addParts(context: Context, key: String, uris: List<Uri>, contentType: MediaType?) = apply {\n                    uris.forEach { addPart(context, key, it, contentType) }\n                }\n                ") + "\n                fun addPart(requestBody: RequestBody) = addPart(OkHttpCompat.part(requestBody))\n\n                fun addPart(headers: Headers?, requestBody: RequestBody) =\n                    addPart(OkHttpCompat.part(headers, requestBody))\n\n                fun addFormDataPart(\n                    key: String,\n                    fileName: String?,\n                    requestBody: RequestBody\n                ) = addPart(OkHttpCompat.part(key, fileName, requestBody))\n\n                fun addPart(key: String, requestBody: RequestBody) = addFormDataPart(key, null, requestBody)\n                \n                fun addParts(partMap: Map<String, RequestBody>) = apply { \n                    partMap.forEach { (key, value) -> addPart(key, value) } \n                }\n\n                fun addPart(part: MultipartBody.Part) = apply { param.addPart(part) }\n                \n                fun addParts(parts: List<MultipartBody.Part>) = apply { parts.forEach { addPart(it) } }\n\n                //Set content-type to multipart/form-data\n                fun setMultiForm() = setMultiType(MultipartBody.FORM)\n\n                //Set content-type to multipart/mixed\n                fun setMultiMixed() = setMultiType(MultipartBody.MIXED)\n\n                //Set content-type to multipart/alternative\n                fun setMultiAlternative() = setMultiType(MultipartBody.ALTERNATIVE)\n\n                //Set content-type to multipart/digest\n                fun setMultiDigest() = setMultiType(MultipartBody.DIGEST)\n\n                //Set content-type to multipart/parallel\n                fun setMultiParallel() = setMultiType(MultipartBody.PARALLEL)\n\n                //Set the MIME type\n                fun setMultiType(multiType: MediaType?) = apply { param.multiType = multiType }\n            }\n\n        ")));
    }

    private final void generatorRxHttpJsonParam(CodeGenerator codeGenerator) {
        this.generatorClass(codeGenerator, "RxHttpJsonParam", StringsKt.trimIndent((String)("\n            package " + VariablesKt.getRxHttpPackage() + "\n\n            import com.google.gson.JsonObject\n            \n            import rxhttp.wrapper.param.JsonParam\n            /**\n             * Github\n             * https://github.com/liujingxing/rxhttp\n             * https://github.com/liujingxing/rxlife\n             * https://github.com/liujingxing/rxhttp/wiki/FAQ\n             * https://github.com/liujingxing/rxhttp/wiki/\u66f4\u65b0\u65e5\u5fd7\n             */\n            open class RxHttpJsonParam(param: JsonParam) : RxHttpAbstractBodyParam<JsonParam, RxHttpJsonParam>(param) {\n            \n                @JvmOverloads\n                fun add(key: String, value: Any?, add: Boolean = true) = apply {\n                    if (add) param.add(key, value)\n                }\n            \n                fun addAll(map: Map<String, *>) = apply { param.addAll(map) }\n            \n                /**\n                 * \u5c06Json\u5bf9\u8c61\u91cc\u9762\u7684key-value\u9010\u4e00\u53d6\u51fa\uff0c\u6dfb\u52a0\u5230\u53e6\u4e00\u4e2aJson\u5bf9\u8c61\u4e2d\uff0c\n                 * \u8f93\u5165\u975eJson\u5bf9\u8c61\u5c06\u629b\u51fa[IllegalStateException]\u5f02\u5e38\n                 */\n                fun addAll(jsonObject: String) = apply { param.addAll(jsonObject) }\n            \n                /**\n                 * \u5c06Json\u5bf9\u8c61\u91cc\u9762\u7684key-value\u9010\u4e00\u53d6\u51fa\uff0c\u6dfb\u52a0\u5230\u53e6\u4e00\u4e2aJson\u5bf9\u8c61\u4e2d\n                 */\n                fun addAll(jsonObject: JsonObject) = apply { param.addAll(jsonObject) }\n            \n                /**\n                 * \u6dfb\u52a0\u4e00\u4e2aJsonElement\u5bf9\u8c61(Json\u5bf9\u8c61\u3001json\u6570\u7ec4\u7b49)\n                 */\n                fun addJsonElement(key: String, jsonElement: String) = apply {\n                    param.addJsonElement(key, jsonElement)\n                }\n            }\n\n        ")));
    }

    private final void generatorRxHttpJsonArrayParam(CodeGenerator codeGenerator) {
        this.generatorClass(codeGenerator, "RxHttpJsonArrayParam", StringsKt.trimIndent((String)("\n            package " + VariablesKt.getRxHttpPackage() + "\n\n            import com.google.gson.JsonArray\n            import com.google.gson.JsonObject\n            \n            import rxhttp.wrapper.param.JsonArrayParam\n\n            /**\n             * Github\n             * https://github.com/liujingxing/rxhttp\n             * https://github.com/liujingxing/rxlife\n             * https://github.com/liujingxing/rxhttp/wiki/FAQ\n             * https://github.com/liujingxing/rxhttp/wiki/\u66f4\u65b0\u65e5\u5fd7\n             */\n            open class RxHttpJsonArrayParam(param: JsonArrayParam) : RxHttpAbstractBodyParam<JsonArrayParam, RxHttpJsonArrayParam>(param) {\n            \n                @JvmOverloads\n                fun add(key: String, value: Any?, add: Boolean = true) = apply {\n                    if (add) param.add(key, value)\n                }\n            \n                fun addAll(map: Map<String, *>) = apply { param.addAll(map) }\n            \n                fun add(any: Any) = apply { param.add(any) }\n            \n                fun addAll(list: List<*>) = apply {  param.addAll(list) }\n            \n                /**\n                 * \u6dfb\u52a0\u591a\u4e2a\u5bf9\u8c61\uff0c\u5c06\u5b57\u7b26\u4e32\u8f6cJsonElement\u5bf9\u8c61,\u5e76\u6839\u636e\u4e0d\u540c\u7c7b\u578b,\u6267\u884c\u4e0d\u540c\u64cd\u4f5c,\u53ef\u8f93\u5165\u4efb\u610f\u975e\u7a7a\u5b57\u7b26\u4e32\n                 */\n                fun addAll(jsonElement: String) = apply { param.addAll(jsonElement) }\n            \n                fun addAll(jsonArray: JsonArray) = apply { param.addAll(jsonArray) }\n            \n                /**\n                 * \u5c06Json\u5bf9\u8c61\u91cc\u9762\u7684key-value\u9010\u4e00\u53d6\u51fa\uff0c\u6dfb\u52a0\u5230Json\u6570\u7ec4\u4e2d\uff0c\u6210\u4e3a\u5355\u72ec\u7684\u5bf9\u8c61\n                 */\n                fun addAll(jsonObject: JsonObject) = apply { param.addAll(jsonObject) }\n            \n                fun addJsonElement(jsonElement: String) = apply { param.addJsonElement(jsonElement) }\n            \n                /**\n                 * \u6dfb\u52a0\u4e00\u4e2aJsonElement\u5bf9\u8c61(Json\u5bf9\u8c61\u3001json\u6570\u7ec4\u7b49)\n                 */\n                fun addJsonElement(key: String, jsonElement: String) = apply {\n                    param.addJsonElement(key, jsonElement)\n                }\n            }\n\n        ")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generatorClass(CodeGenerator codeGenerator, String className, String content) {
        Collection $this$toTypedArray$iv = CollectionsKt.emptyList();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new KSFile[0]);
        object = CodeGenerator.createNewFile$default((CodeGenerator)codeGenerator, (Dependencies)new Dependencies(false, Arrays.copyOf(object, ((KSFile[])object).length)), (String)VariablesKt.getRxHttpPackage(), (String)className, null, (int)8, null);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)object;
            boolean bl = false;
            byte[] byArray = content.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }
}

