/*
 * Decompiled with CFR 0.152.
 */
package com.rxhttp.compiler.ksp;

import com.google.devtools.ksp.KspExperimental;
import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSVisitorVoid;
import com.rxhttp.compiler.ConstantsKt;
import com.rxhttp.compiler.ksp.DomainVisitorKt;
import com.rxhttp.compiler.ksp.KspKt;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import rxhttp.wrapper.annotation.Domain;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fH\u0017\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/rxhttp/compiler/ksp/DomainVisitor;", "Lcom/google/devtools/ksp/symbol/KSVisitorVoid;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "(Lcom/google/devtools/ksp/processing/Resolver;Lcom/google/devtools/ksp/processing/KSPLogger;)V", "elementMap", "Ljava/util/LinkedHashMap;", "", "Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;", "getFunList", "", "Lcom/squareup/kotlinpoet/FunSpec;", "visitPropertyDeclaration", "", "property", "data", "(Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;Lkotlin/Unit;)V", "rxhttp-compiler"})
@SourceDebugExtension(value={"SMAP\nDomainVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DomainVisitor.kt\ncom/rxhttp/compiler/ksp/DomainVisitor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n135#2,9:108\n215#2:117\n216#2:119\n144#2:120\n1#3:118\n*S KotlinDebug\n*F\n+ 1 DomainVisitor.kt\ncom/rxhttp/compiler/ksp/DomainVisitor\n*L\n56#1:108,9\n56#1:117\n56#1:119\n56#1:120\n56#1:118\n*E\n"})
public final class DomainVisitor
extends KSVisitorVoid {
    @NotNull
    private final Resolver resolver;
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final LinkedHashMap<String, KSPropertyDeclaration> elementMap;

    public DomainVisitor(@NotNull Resolver resolver, @NotNull KSPLogger logger) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.resolver = resolver;
        this.logger = logger;
        this.elementMap = new LinkedHashMap();
    }

    @KspExperimental
    public void visitPropertyDeclaration(@NotNull KSPropertyDeclaration property, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Domain annotation;
            DomainVisitorKt.checkDomainProperty(property, this.resolver);
            Domain domain = annotation = (Domain)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)property), (KClass)Reflection.getOrCreateKotlinClass(Domain.class)));
            String name = domain != null ? domain.name() : null;
            CharSequence charSequence = name;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                name = KspKt.firstLetterUpperCase(property.getSimpleName().asString());
            }
            if (this.elementMap.containsKey(name)) {
                String msg = "The variable '" + property.getSimpleName().asString() + "' in the @Domain annotation 'name = " + name + "' is duplicated";
                throw new NoSuchElementException(msg);
            }
            ((Map)this.elementMap).put(name, property);
        }
        catch (NoSuchElementException e) {
            KspKt.error(this.logger, e, (KSNode)property);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FunSpec> getFunList() {
        void $this$mapNotNullTo$iv$iv;
        TypeName[] typeNameArray = new TypeName[1];
        String[] stringArray = new String[]{"P", "R"};
        typeNameArray[0] = KspKt.parameterizedBy(ConstantsKt.getRxhttpKClass(), stringArray);
        TypeVariableName typeVariableR = TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)"R", (TypeName[])typeNameArray, null, (int)4, null);
        Map $this$mapNotNull$iv = this.elementMap;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            FunSpec it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            KSPropertyDeclaration ksProperty = (KSPropertyDeclaration)entry.getValue();
            MemberName memberName = KspKt.toMemberName(ksProperty);
            Object[] objectArray = new Object[]{memberName};
            if (FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("setDomainTo" + key + "IfAbsent").addCode("return setDomainIfAbsent(%M)", objectArray), (TypeName)((TypeName)typeVariableR), null, (int)2, null).build() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

