/*
 * Decompiled with CFR 0.152.
 */
package skin.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.StyleRes;
import com.google.android.material.navigation.NavigationView;
import skin.support.content.res.SkinCompatResources;
import skin.support.content.res.SkinCompatThemeUtils;
import skin.support.content.res.SkinCompatV7ThemeUtils;
import skin.support.content.res.SkinCompatVectorResources;
import skin.support.design.R;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinMaterialNavigationView
extends NavigationView
implements SkinCompatSupportable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    private int mItemBackgroundResId = 0;
    private int mTextColorResId = 0;
    private int mDefaultTintResId = 0;
    private int mIconTintResId = 0;
    private SkinCompatBackgroundHelper mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);

    public SkinMaterialNavigationView(Context context) {
        this(context, null);
    }

    public SkinMaterialNavigationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinMaterialNavigationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int textAppearance;
        this.mBackgroundTintHelper.loadFromAttributes(attrs, 0);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NavigationView, defStyleAttr, R.style.Widget_Design_NavigationView);
        if (a.hasValue(R.styleable.NavigationView_itemIconTint)) {
            this.mIconTintResId = a.getResourceId(R.styleable.NavigationView_itemIconTint, 0);
        } else {
            this.mDefaultTintResId = SkinCompatV7ThemeUtils.getColorPrimaryResId((Context)context);
        }
        if (a.hasValue(R.styleable.NavigationView_itemTextAppearance) && (textAppearance = a.getResourceId(R.styleable.NavigationView_itemTextAppearance, 0)) != 0) {
            TypedArray ap = context.obtainStyledAttributes(textAppearance, R.styleable.SkinTextAppearance);
            if (ap.hasValue(R.styleable.SkinTextAppearance_android_textColor)) {
                this.mTextColorResId = ap.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
            }
            ap.recycle();
        }
        if (a.hasValue(R.styleable.NavigationView_itemTextColor)) {
            this.mTextColorResId = a.getResourceId(R.styleable.NavigationView_itemTextColor, 0);
        } else {
            this.mDefaultTintResId = SkinCompatV7ThemeUtils.getColorPrimaryResId((Context)context);
        }
        if (this.mTextColorResId == 0) {
            this.mTextColorResId = SkinCompatThemeUtils.getTextColorPrimaryResId((Context)context);
        }
        this.mItemBackgroundResId = a.getResourceId(R.styleable.NavigationView_itemBackground, 0);
        a.recycle();
        this.applyItemIconTintResource();
        this.applyItemTextColorResource();
        this.applyItemBackgroundResource();
    }

    public void setItemBackgroundResource(@DrawableRes int resId) {
        super.setItemBackgroundResource(resId);
        this.mItemBackgroundResId = resId;
        this.applyItemBackgroundResource();
    }

    private void applyItemBackgroundResource() {
        this.mItemBackgroundResId = SkinCompatHelper.checkResourceId((int)this.mItemBackgroundResId);
        if (this.mItemBackgroundResId == 0) {
            return;
        }
        Drawable drawable = SkinCompatVectorResources.getDrawableCompat((Context)this.getContext(), (int)this.mItemBackgroundResId);
        if (drawable != null) {
            this.setItemBackground(drawable);
        }
    }

    public void setItemTextAppearance(@StyleRes int resId) {
        super.setItemTextAppearance(resId);
        if (resId != 0) {
            TypedArray a = this.getContext().obtainStyledAttributes(resId, R.styleable.SkinTextAppearance);
            if (a.hasValue(R.styleable.SkinTextAppearance_android_textColor)) {
                this.mTextColorResId = a.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
            }
            a.recycle();
            this.applyItemTextColorResource();
        }
    }

    private void applyItemTextColorResource() {
        this.mTextColorResId = SkinCompatHelper.checkResourceId((int)this.mTextColorResId);
        if (this.mTextColorResId != 0) {
            this.setItemTextColor(SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mTextColorResId));
        } else {
            this.mDefaultTintResId = SkinCompatHelper.checkResourceId((int)this.mDefaultTintResId);
            if (this.mDefaultTintResId != 0) {
                this.setItemTextColor(this.createDefaultColorStateList(16842806));
            }
        }
    }

    private void applyItemIconTintResource() {
        this.mIconTintResId = SkinCompatHelper.checkResourceId((int)this.mIconTintResId);
        if (this.mIconTintResId != 0) {
            this.setItemIconTintList(SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mIconTintResId));
        } else {
            this.mDefaultTintResId = SkinCompatHelper.checkResourceId((int)this.mDefaultTintResId);
            if (this.mDefaultTintResId != 0) {
                this.setItemIconTintList(this.createDefaultColorStateList(16842808));
            }
        }
    }

    private ColorStateList createDefaultColorStateList(int baseColorThemeAttr) {
        TypedValue value = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(baseColorThemeAttr, value, true)) {
            return null;
        }
        ColorStateList baseColor = SkinCompatResources.getColorStateList((Context)this.getContext(), (int)value.resourceId);
        int colorPrimary = SkinCompatResources.getColor((Context)this.getContext(), (int)this.mDefaultTintResId);
        int defaultColor = baseColor.getDefaultColor();
        return new ColorStateList((int[][])new int[][]{DISABLED_STATE_SET, CHECKED_STATE_SET, EMPTY_STATE_SET}, new int[]{baseColor.getColorForState(DISABLED_STATE_SET, defaultColor), colorPrimary, defaultColor});
    }

    public void applySkin() {
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
        this.applyItemIconTintResource();
        this.applyItemTextColorResource();
        this.applyItemBackgroundResource();
    }
}

