/*
 * Decompiled with CFR 0.152.
 */
package skin.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import skin.support.content.res.SkinCompatResources;
import skin.support.design.R;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinMaterialBottomNavigationView
extends BottomNavigationView
implements SkinCompatSupportable {
    private static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private SkinCompatBackgroundHelper mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);
    private int mTextColorResId = 0;
    private int mIconTintResId = 0;
    private int mDefaultTintResId = 0;

    public SkinMaterialBottomNavigationView(@NonNull Context context) {
        this(context, null);
    }

    public SkinMaterialBottomNavigationView(@NonNull Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinMaterialBottomNavigationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mBackgroundTintHelper.loadFromAttributes(attrs, defStyleAttr);
        this.mDefaultTintResId = this.resolveColorPrimary();
        this.mDefaultTintResId = this.resolveColorPrimary();
        this.applyItemIconTintResource();
        this.applyItemTextColorResource();
    }

    public void setBackgroundResource(@DrawableRes int resId) {
        super.setBackgroundResource(resId);
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.onSetBackgroundResource(resId);
        }
    }

    private void applyItemTextColorResource() {
        this.mTextColorResId = SkinCompatHelper.checkResourceId((int)this.mTextColorResId);
        if (this.mTextColorResId != 0) {
            this.setItemTextColor(SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mTextColorResId));
        } else {
            this.mDefaultTintResId = SkinCompatHelper.checkResourceId((int)this.mDefaultTintResId);
            if (this.mDefaultTintResId != 0) {
                this.setItemTextColor(this.createDefaultColorStateList(16842808));
            }
        }
    }

    private void applyItemIconTintResource() {
        this.mIconTintResId = SkinCompatHelper.checkResourceId((int)this.mIconTintResId);
        if (this.mIconTintResId != 0) {
            this.setItemIconTintList(SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mIconTintResId));
        } else {
            this.mDefaultTintResId = SkinCompatHelper.checkResourceId((int)this.mDefaultTintResId);
            if (this.mDefaultTintResId != 0) {
                this.setItemIconTintList(this.createDefaultColorStateList(16842808));
            }
        }
    }

    private ColorStateList createDefaultColorStateList(int baseColorThemeAttr) {
        TypedValue value = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(baseColorThemeAttr, value, true)) {
            return null;
        }
        ColorStateList baseColor = SkinCompatResources.getColorStateList((Context)this.getContext(), (int)value.resourceId);
        int colorPrimary = SkinCompatResources.getColor((Context)this.getContext(), (int)this.mDefaultTintResId);
        int defaultColor = baseColor.getDefaultColor();
        return new ColorStateList((int[][])new int[][]{DISABLED_STATE_SET, CHECKED_STATE_SET, EMPTY_STATE_SET}, new int[]{baseColor.getColorForState(DISABLED_STATE_SET, defaultColor), colorPrimary, defaultColor});
    }

    private int resolveColorPrimary() {
        TypedValue value = new TypedValue();
        if (!this.getContext().getTheme().resolveAttribute(R.attr.colorPrimary, value, true)) {
            return 0;
        }
        return value.resourceId;
    }

    public void applySkin() {
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
        this.applyItemIconTintResource();
        this.applyItemTextColorResource();
    }
}

