/*
 * Decompiled with CFR 0.152.
 */
package com.lihang.help;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.lihang.R;
import com.lihang.SmartLoadingView;
import com.lihang.help.UIUtil;

public class CirclBigView
extends View {
    private ValueAnimator animator_big;
    private int myRadius;
    private int fatherRadius;
    private Paint showPaint = new Paint();
    private int y;
    private int x;
    private int maxRadius;

    public CirclBigView(Context context) {
        this(context, null);
    }

    public CirclBigView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CirclBigView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.showPaint.setAntiAlias(true);
        this.showPaint.setStyle(Paint.Style.FILL);
        this.showPaint.setColor(this.getResources().getColor(R.color.guide_anim));
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
        int y_true = y + this.fatherRadius;
        int left_top = (int)Math.sqrt(x * x + y_true * y_true);
        int left_bottom = (int)Math.sqrt(x * x + (UIUtil.getHeight(this.getContext()) - y_true) * (UIUtil.getHeight(this.getContext()) - y_true));
        int right_top = (int)Math.sqrt((UIUtil.getWidth(this.getContext()) - x) * (UIUtil.getWidth(this.getContext()) - x) + y_true * y_true);
        int right_bottom = (int)Math.sqrt((UIUtil.getWidth(this.getContext()) - x) * (UIUtil.getWidth(this.getContext()) - x) + (UIUtil.getHeight(this.getContext()) - y_true) * (UIUtil.getHeight(this.getContext()) - y_true));
        int left_big = left_top >= left_bottom ? left_top : left_bottom;
        int right_big = right_top >= right_bottom ? right_top : right_bottom;
        this.maxRadius = left_big >= right_big ? left_big : right_big;
        this.maxRadius += UIUtil.getWidth(this.getContext()) / 6;
        this.animator_big = ValueAnimator.ofInt((int[])new int[]{this.myRadius, this.maxRadius});
        this.animator_big.setDuration(200L);
        this.animator_big.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                CirclBigView.this.myRadius = (Integer)valueAnimator.getAnimatedValue();
                CirclBigView.this.postInvalidate();
            }
        });
        this.invalidate();
    }

    public void setRadius(int radius) {
        this.myRadius = radius;
        this.fatherRadius = radius;
    }

    public void setCircleR(int currentR) {
        this.myRadius = currentR;
        this.postInvalidate();
    }

    public void setColorBg(int colorBg) {
        this.showPaint.setColor(colorBg);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle((float)this.x, (float)(this.y + this.fatherRadius), (float)this.myRadius, this.showPaint);
    }

    public void startShowAni(final SmartLoadingView.LoadingListener listener, SmartLoadingView smartLoadingView) {
        if (listener != null) {
            if (!this.animator_big.isRunning()) {
                this.animator_big.start();
            }
            if (listener != null) {
                this.animator_big.addListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        listener.loadingFinish(true);
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                });
            }
        }
    }

    public void startShowAni(final Activity activity, final Class clazz) {
        if (!this.animator_big.isRunning()) {
            this.animator_big.start();
            this.animator_big.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    activity.startActivity(new Intent((Context)activity, clazz));
                    activity.finish();
                    activity.overridePendingTransition(R.anim.alpha_enter, R.anim.alpha_exit);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }
}

