/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;
import com.lihang.R;
import com.lihang.help.CirclBigView;
import com.lihang.help.OkView;
import com.lihang.help.UIUtil;

public class SmartLoadingView
extends AppCompatTextView {
    private static int SMART_TICK = 1;
    private static int SMART_TICK_HIDE = 2;
    private static int SMART_TICK_CENTER_HIDE = 3;
    private static int SMART_BUTTON = 4;
    private static int SMART_FULL_SCREEN = 5;
    private int width;
    private int height;
    private int circleAngle;
    private int default_all_distance;
    private int current_left;
    private int duration = 500;
    private Paint paint;
    private Paint okPaint;
    private Rect textRect = new Rect();
    private RectF rectf = new RectF();
    private AnimatorSet animatorSet = new AnimatorSet();
    private AnimatorSet animatorNetfail = new AnimatorSet();
    private ValueAnimator animator_rect_to_square;
    private ValueAnimator animator_squareToRect;
    private ValueAnimator animator_rect_to_angle;
    private ValueAnimator animator_angle_to_rect;
    private boolean startDrawOk = false;
    private ValueAnimator animator_draw_ok;
    private PathEffect effect;
    private Path path = new Path();
    private PathMeasure pathMeasure;
    private boolean isDrawLoading = false;
    private boolean isLoading = false;
    private int startAngle = 0;
    private int progAngle = 30;
    private boolean isAdd = true;
    private Paint textPaint;
    private ValueAnimator animator_text_scroll;
    private ValueAnimator animator_marque;
    private int drawTextStart;
    private int drawMarqueTextStart;
    private int backgroundColor;
    private int unEnabled_backgroundColor;
    private int corners_radius;
    private int ellipsize = 1;
    private int ellipsize_speed;
    private int animaled_backgroundColor;
    private int animaled_textColor;
    private String normalString = "";
    private String mAnimaledText = "";
    private String currentString;
    private int textColor;
    private int textColorOriginal;
    private int textAlpha;
    private CirclBigView circlBigView;
    private int mButtonType = SMART_FULL_SCREEN;
    private long startLoading_click_millons = 0L;
    private boolean isFinished;
    private long finished_click_millons = 0L;
    private long finishLoading_click_millons = 0L;

    public SmartLoadingView(Context context) {
        this(context, null);
    }

    public SmartLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartLoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.circlBigView = new CirclBigView(this.getContext());
        this.init(attrs);
        this.initPaint();
    }

    private void init(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SmartLoadingView);
        this.currentString = TextUtils.isEmpty((CharSequence)this.getText()) ? this.normalString : (this.normalString = (String)this.getText());
        this.mAnimaledText = this.currentString;
        String animaledText = typedArray.getString(R.styleable.SmartLoadingView_hl_animaled_text);
        if (!TextUtils.isEmpty((CharSequence)animaledText)) {
            this.mAnimaledText = animaledText;
        }
        this.unEnabled_backgroundColor = typedArray.getColor(R.styleable.SmartLoadingView_hl_unEnabled_background, this.getResources().getColor(R.color.blackbb));
        this.backgroundColor = this.getResources().getColor(R.color.guide_anim);
        Drawable background = this.getBackground();
        if (background instanceof ColorDrawable) {
            this.backgroundColor = ((ColorDrawable)background).getColor();
        }
        this.animaled_backgroundColor = typedArray.getColor(R.styleable.SmartLoadingView_hl_animaled_background, this.backgroundColor);
        ColorStateList textColors = this.getTextColors();
        int[] drawableState = this.getDrawableState();
        this.textColorOriginal = this.textColor = textColors.getColorForState(drawableState, 0);
        this.animaled_textColor = typedArray.getColor(R.styleable.SmartLoadingView_hl_animaled_textColor, this.textColor);
        this.corners_radius = (int)typedArray.getDimension(R.styleable.SmartLoadingView_hl_corners_radius, this.getResources().getDimension(R.dimen.slv_default_corner));
        this.ellipsize = typedArray.getInt(R.styleable.SmartLoadingView_hl_ellipsize, 1);
        this.ellipsize_speed = typedArray.getInt(R.styleable.SmartLoadingView_hl_ellipsize_speed, 400);
        this.mButtonType = typedArray.getInt(R.styleable.SmartLoadingView_hl_button_type, SMART_FULL_SCREEN);
        int padding_horizontal = (int)this.getResources().getDimension(R.dimen.slv_padding_horizontal);
        int padding_vertical = (int)this.getResources().getDimension(R.dimen.slv_padding_vertical);
        int paddingTop = this.getPaddingTop() == 0 ? padding_vertical : this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom() == 0 ? padding_vertical : this.getPaddingBottom();
        int paddingLeft = this.getPaddingLeft() == 0 ? padding_horizontal : this.getPaddingLeft();
        int paddingRight = this.getPaddingRight() == 0 ? padding_horizontal : this.getPaddingRight();
        this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        this.setBackgroundColor(0);
        this.setMaxLines(1);
        this.setGravity(17);
    }

    private void initPaint() {
        this.paint = new Paint(1);
        this.paint.setStrokeWidth(4.0f);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
        if (this.isEnabled()) {
            this.paint.setColor(this.backgroundColor);
        } else {
            this.paint.setColor(this.unEnabled_backgroundColor);
        }
        this.okPaint = new Paint(1);
        this.okPaint.setStrokeWidth(5.0f);
        this.okPaint.setStyle(Paint.Style.STROKE);
        this.okPaint.setAntiAlias(true);
        this.okPaint.setStrokeCap(Paint.Cap.ROUND);
        this.okPaint.setColor(this.textColor);
        this.textAlpha = Color.alpha((int)this.textColor);
        this.textPaint = new Paint(1);
        this.textPaint.setTextSize(this.getTextSize());
        this.textPaint.setColor(this.textColor);
        this.textPaint.setAntiAlias(true);
    }

    private void initAnimation() {
        this.set_rect_to_circle_animation();
        this.set_draw_ok_animation();
        this.animatorSet.play((Animator)this.animator_rect_to_square).with((Animator)this.animator_rect_to_angle);
        this.animatorNetfail.play((Animator)this.animator_squareToRect).with((Animator)this.animator_angle_to_rect);
    }

    private void initOk() {
        this.path.moveTo((float)(this.default_all_distance + this.height / 8 * 3), (float)(this.height / 2));
        this.path.lineTo((float)(this.default_all_distance + this.height / 2), (float)(this.height / 5 * 3));
        this.path.lineTo((float)(this.default_all_distance + this.height / 3 * 2), (float)(this.height / 5 * 2));
        this.pathMeasure = new PathMeasure(this.path, true);
    }

    private void set_rect_to_circle_animation() {
        this.animator_rect_to_square = ValueAnimator.ofInt((int[])new int[]{0, this.default_all_distance});
        this.animator_rect_to_square.setDuration((long)this.duration);
        this.animator_rect_to_square.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmartLoadingView.this.current_left = (Integer)animation.getAnimatedValue();
                int nowAlpha = SmartLoadingView.this.textAlpha / 2 - SmartLoadingView.this.current_left * SmartLoadingView.this.textAlpha / SmartLoadingView.this.default_all_distance < 0 ? 0 : SmartLoadingView.this.textAlpha / 2 - SmartLoadingView.this.current_left * SmartLoadingView.this.textAlpha / SmartLoadingView.this.default_all_distance;
                SmartLoadingView.this.textPaint.setColor(SmartLoadingView.this.addAlpha(SmartLoadingView.this.textColor, nowAlpha));
                if (SmartLoadingView.this.current_left == SmartLoadingView.this.default_all_distance) {
                    SmartLoadingView.this.isDrawLoading = true;
                }
                SmartLoadingView.this.invalidate();
            }
        });
        this.animator_rect_to_angle = ValueAnimator.ofInt((int[])new int[]{this.corners_radius, this.height / 2});
        this.animator_rect_to_angle.setDuration((long)this.duration);
        this.animator_rect_to_angle.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmartLoadingView.this.circleAngle = (Integer)animation.getAnimatedValue();
                SmartLoadingView.this.invalidate();
            }
        });
        this.animator_squareToRect = ValueAnimator.ofInt((int[])new int[]{this.default_all_distance, 0});
        this.animator_squareToRect.setDuration((long)this.duration);
        this.animator_squareToRect.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmartLoadingView.this.current_left = (Integer)animation.getAnimatedValue();
                if (SmartLoadingView.this.current_left <= SmartLoadingView.this.default_all_distance / 2) {
                    int nowAlpha = (SmartLoadingView.this.default_all_distance / 2 - SmartLoadingView.this.current_left) * SmartLoadingView.this.textAlpha / (SmartLoadingView.this.default_all_distance / 2);
                    SmartLoadingView.this.textPaint.setColor(SmartLoadingView.this.addAlpha(SmartLoadingView.this.textColor, nowAlpha));
                }
                if (SmartLoadingView.this.current_left == 0) {
                    SmartLoadingView.this.isLoading = false;
                    SmartLoadingView.this.setClickable(true);
                }
                SmartLoadingView.this.isDrawLoading = false;
                SmartLoadingView.this.startDrawOk = false;
                SmartLoadingView.this.postInvalidate();
            }
        });
        this.animator_angle_to_rect = ValueAnimator.ofInt((int[])new int[]{this.height / 2, this.corners_radius});
        this.animator_angle_to_rect.setDuration((long)this.duration);
        this.animator_angle_to_rect.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmartLoadingView.this.circleAngle = (Integer)animation.getAnimatedValue();
                SmartLoadingView.this.postInvalidate();
            }
        });
    }

    private void set_draw_ok_animation() {
        this.animator_draw_ok = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.animator_draw_ok.setDuration((long)this.duration);
        this.animator_draw_ok.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmartLoadingView.this.startDrawOk = true;
                SmartLoadingView.this.isDrawLoading = false;
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                SmartLoadingView.this.effect = (PathEffect)new DashPathEffect(new float[]{SmartLoadingView.this.pathMeasure.getLength(), SmartLoadingView.this.pathMeasure.getLength()}, value * SmartLoadingView.this.pathMeasure.getLength());
                SmartLoadingView.this.okPaint.setPathEffect(SmartLoadingView.this.effect);
                SmartLoadingView.this.invalidate();
            }
        });
    }

    private void draw_oval_to_circle(Canvas canvas) {
        this.rectf.left = this.current_left;
        this.rectf.top = 0.0f;
        this.rectf.right = this.width - this.current_left;
        this.rectf.bottom = this.height;
        canvas.drawRoundRect(this.rectf, (float)this.circleAngle, (float)this.circleAngle, this.paint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.width == 0) {
            this.width = w;
            this.height = h;
            if (this.corners_radius > this.height / 2) {
                this.corners_radius = this.height / 2;
            }
            this.circleAngle = this.corners_radius;
            this.default_all_distance = (w - h) / 2;
            this.initOk();
            this.initAnimation();
            this.setWidth(this.width);
            this.setHeight(this.height);
        }
    }

    private void drawText(Canvas canvas) {
        int sc = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
        this.rectf.left = this.current_left + this.getPaddingLeft();
        this.rectf.top = 0.0f;
        this.rectf.right = this.width - this.current_left - this.getPaddingRight();
        this.rectf.bottom = this.height;
        canvas.drawRoundRect(this.rectf, (float)this.circleAngle, (float)this.circleAngle, this.paint);
        this.textPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        this.textRect.left = this.getPaddingLeft();
        this.textRect.top = 0;
        this.textRect.right = this.width - this.getPaddingRight();
        this.textRect.bottom = this.height;
        Paint.FontMetricsInt fontMetrics = this.textPaint.getFontMetricsInt();
        int baseline = (this.textRect.bottom + this.textRect.top - fontMetrics.bottom - fontMetrics.top) / 2;
        int myTotal = (int)(this.textPaint.measureText(this.currentString) + (float)this.getPaddingRight() + (float)this.getPaddingLeft());
        if (myTotal > this.getWidth()) {
            if (this.ellipsize == 1) {
                this.textPaint.setTextAlign(Paint.Align.LEFT);
                if (this.animator_text_scroll == null && !this.isLoading) {
                    this.animator_text_scroll = ValueAnimator.ofInt((int[])new int[]{this.textRect.left, (int)((float)this.textRect.left - this.textPaint.measureText(this.currentString) + (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()))});
                    this.animator_text_scroll.setDuration((long)(this.currentString.length() * this.ellipsize_speed));
                    this.animator_text_scroll.setRepeatMode(2);
                    this.animator_text_scroll.setRepeatCount(-1);
                    this.animator_text_scroll.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            SmartLoadingView.this.drawTextStart = (Integer)animation.getAnimatedValue();
                            SmartLoadingView.this.postInvalidate();
                        }
                    });
                    this.animator_text_scroll.start();
                }
                canvas.drawText(this.currentString, (float)this.drawTextStart, (float)baseline, this.textPaint);
            } else {
                this.textPaint.setTextAlign(Paint.Align.LEFT);
                if (this.animator_text_scroll == null && !this.isLoading) {
                    this.animator_text_scroll = ValueAnimator.ofInt((int[])new int[]{this.textRect.left, (int)((float)this.textRect.left - this.textPaint.measureText(this.currentString))});
                    this.animator_text_scroll.setDuration((long)(this.currentString.length() * this.ellipsize_speed));
                    this.animator_text_scroll.setInterpolator((TimeInterpolator)new LinearInterpolator());
                    this.animator_text_scroll.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            SmartLoadingView.this.drawTextStart = (Integer)animation.getAnimatedValue();
                            SmartLoadingView.this.postInvalidate();
                            if (SmartLoadingView.this.drawTextStart == ((SmartLoadingView)SmartLoadingView.this).textRect.left && SmartLoadingView.this.animator_marque != null) {
                                SmartLoadingView.this.animator_marque.cancel();
                                SmartLoadingView.this.animator_marque = null;
                            }
                            if (SmartLoadingView.this.animator_marque == null && !SmartLoadingView.this.isLoading && SmartLoadingView.this.drawTextStart <= (int)((float)((SmartLoadingView)SmartLoadingView.this).textRect.left - SmartLoadingView.this.textPaint.measureText(SmartLoadingView.this.currentString) + (float)(SmartLoadingView.this.getWidth() - SmartLoadingView.this.getPaddingLeft() - SmartLoadingView.this.getPaddingRight()) - (float)((SmartLoadingView.this.getWidth() - SmartLoadingView.this.getPaddingLeft() - SmartLoadingView.this.getPaddingRight()) / 3))) {
                                int duration = (int)((float)(SmartLoadingView.this.currentString.length() * SmartLoadingView.this.ellipsize_speed * (((SmartLoadingView)SmartLoadingView.this).textRect.right - ((SmartLoadingView)SmartLoadingView.this).textRect.left)) / SmartLoadingView.this.textPaint.measureText(SmartLoadingView.this.currentString));
                                SmartLoadingView.this.animator_marque = ValueAnimator.ofInt((int[])new int[]{((SmartLoadingView)SmartLoadingView.this).textRect.right, ((SmartLoadingView)SmartLoadingView.this).textRect.left});
                                SmartLoadingView.this.animator_marque.setDuration((long)duration);
                                SmartLoadingView.this.animator_marque.setInterpolator((TimeInterpolator)new LinearInterpolator());
                                SmartLoadingView.this.animator_marque.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                                    public void onAnimationUpdate(ValueAnimator animation) {
                                        SmartLoadingView.this.drawMarqueTextStart = (Integer)animation.getAnimatedValue();
                                        if (SmartLoadingView.this.drawMarqueTextStart == ((SmartLoadingView)SmartLoadingView.this).textRect.left) {
                                            SmartLoadingView.this.postDelayed(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (SmartLoadingView.this.animator_text_scroll != null) {
                                                        SmartLoadingView.this.animator_text_scroll.cancel();
                                                        SmartLoadingView.this.animator_text_scroll = null;
                                                        SmartLoadingView.this.postInvalidate();
                                                    }
                                                }
                                            }, 1500L);
                                        }
                                        SmartLoadingView.this.postInvalidate();
                                    }
                                });
                                SmartLoadingView.this.animator_marque.start();
                            }
                        }
                    });
                    this.animator_text_scroll.start();
                }
                if (this.animator_marque != null) {
                    canvas.drawText(this.currentString, (float)this.drawMarqueTextStart, (float)baseline, this.textPaint);
                }
                canvas.drawText(this.currentString, (float)this.drawTextStart, (float)baseline, this.textPaint);
            }
        } else {
            this.cancleScroll();
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            this.drawTextStart = this.textRect.left;
            canvas.drawText(this.currentString, (float)this.textRect.centerX(), (float)baseline, this.textPaint);
        }
        this.textPaint.setXfermode(null);
        canvas.restoreToCount(sc);
    }

    protected void onDraw(Canvas canvas) {
        this.draw_oval_to_circle(canvas);
        this.drawText(canvas);
        if (this.isDrawLoading) {
            canvas.drawArc(new RectF((float)(this.width / 2 - this.height / 2 + this.height / 4), (float)(this.height / 4), (float)(this.width / 2 + this.height / 2 - this.height / 4), (float)(this.height / 2 + this.height / 2 - this.height / 4)), (float)this.startAngle, (float)this.progAngle, false, this.okPaint);
            this.startAngle += 6;
            if (this.progAngle >= 270) {
                this.progAngle -= 2;
                this.isAdd = false;
            } else if (this.progAngle <= 45) {
                this.progAngle += 6;
                this.isAdd = true;
            } else {
                this.progAngle = this.isAdd ? (this.progAngle += 6) : (this.progAngle -= 2);
            }
            this.postInvalidate();
        }
        if (this.startDrawOk) {
            canvas.drawPath(this.path, this.okPaint);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancleScroll();
    }

    private int addAlpha(int color2, int alpha) {
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private void cancleScroll() {
        if (this.animator_text_scroll != null) {
            this.animator_text_scroll.cancel();
            this.animator_text_scroll = null;
        }
        if (this.animator_marque != null) {
            this.animator_marque.cancel();
            this.animator_marque = null;
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        this.normalString = (String)text;
        this.currentString = (String)text;
        this.postInvalidate();
    }

    public void setAnimaledText(CharSequence text) {
        this.mAnimaledText = (String)text;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            if (this.paint != null) {
                this.paint.setColor(this.backgroundColor);
            }
            this.postInvalidate();
        } else {
            if (this.paint != null) {
                this.paint.setColor(this.unEnabled_backgroundColor);
            }
            this.postInvalidate();
        }
    }

    public void startLoading() {
        long currentMillons = System.currentTimeMillis();
        if (currentMillons - this.startLoading_click_millons < 500L) {
            return;
        }
        this.startLoading_click_millons = currentMillons;
        if (!this.isLoading) {
            this.textColor = this.textColorOriginal;
            this.cancleScroll();
            this.startDrawOk = false;
            this.currentString = this.normalString;
            this.setClickable(false);
            this.paint.setColor(this.backgroundColor);
            this.isLoading = true;
            this.animatorSet.start();
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void setFinished(boolean success) {
        long currentMillons = System.currentTimeMillis();
        if (currentMillons - this.finished_click_millons < 500L) {
            return;
        }
        this.finished_click_millons = currentMillons;
        if (this.mButtonType == SMART_FULL_SCREEN) {
            throw new IllegalArgumentException("hl_button_type = \"smart_full_screen\"\uff0c\u4e0d\u5c5e\u4e8e\u5173\u6ce8\u6a21\u5f0f");
        }
        if (this.mButtonType == SMART_BUTTON) {
            this.setFinishedReal(success, SMART_BUTTON);
        } else if (this.mButtonType == SMART_TICK) {
            this.setFinishedReal(success, SMART_TICK);
        } else if (this.mButtonType == SMART_TICK_HIDE) {
            this.setFinishedReal(success, SMART_TICK_HIDE);
        } else if (this.mButtonType == SMART_TICK_CENTER_HIDE) {
            this.setFinishedReal(success, SMART_TICK_CENTER_HIDE);
        }
    }

    private void setFinishedReal(final boolean success, final int buttonType) {
        if (this.getWidth() == 0 && this.getHeight() == 0) {
            this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View view, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
                    SmartLoadingView.this.changeButtonStatus(success, buttonType);
                    SmartLoadingView.this.removeOnLayoutChangeListener(this);
                }
            });
        } else {
            this.changeButtonStatus(success, buttonType);
        }
    }

    public void finishLoading() {
        this.finishLoading(true, null);
    }

    public void finishLoading(boolean success) {
        this.finishLoading(success, null);
    }

    public void finishLoading(LoadingListener listener) {
        this.finishLoading(true, listener);
    }

    public void finishLoading(boolean success, LoadingListener listener) {
        long currentMillons = System.currentTimeMillis();
        if (currentMillons - this.finishLoading_click_millons < 500L) {
            return;
        }
        this.finishLoading_click_millons = currentMillons;
        if (this.mButtonType == SMART_FULL_SCREEN) {
            if (success) {
                this.fullScreen(listener);
            } else {
                this.backToEnd(listener, false);
            }
        } else if (this.mButtonType == SMART_BUTTON) {
            if (success) {
                this.isFinished = true;
                this.backToEnd(listener, true);
            } else {
                this.backToStart(listener, false);
            }
        } else if (this.mButtonType == SMART_TICK) {
            if (success) {
                this.isFinished = true;
                this.startTick(listener);
            } else {
                this.backToStart(listener, false);
            }
        } else if (this.mButtonType == SMART_TICK_HIDE) {
            if (success) {
                this.isFinished = true;
                this.startTickHide(listener);
            } else {
                this.backToStart(listener, false);
            }
        } else if (this.mButtonType == SMART_TICK_CENTER_HIDE) {
            if (success) {
                this.isFinished = true;
                this.startTickCenterHide(listener);
            } else {
                this.backToStart(listener, false);
            }
        }
    }

    public void finishLoadingWithFullScreen(Activity activity, Class clazz) {
        if (this.mButtonType != SMART_FULL_SCREEN) {
            throw new IllegalArgumentException("\u6b64api\u53ea\u652f\u6301\uff0chl_button_type = \"smart_full_screen\"");
        }
        this.fullScreen(activity, clazz);
    }

    private void backToEnd(final LoadingListener listener, final boolean success) {
        if (this.isLoading) {
            if (!this.animatorSet.isRunning()) {
                this.backToEndReal(listener, success);
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SmartLoadingView.this.backToEndReal(listener, success);
                    }
                }, 1000L);
            }
        }
    }

    private void backToEndReal(final LoadingListener listener, final boolean success) {
        if (this.animatorNetfail.isRunning()) {
            return;
        }
        this.currentString = this.mAnimaledText;
        this.paint.setColor(this.animaled_backgroundColor);
        this.textColor = this.animaled_textColor;
        this.animatorNetfail.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (listener != null) {
                    listener.loadingFinish(success);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.animatorNetfail.start();
    }

    private void fullScreen(final LoadingListener listener) {
        if (this.isLoading) {
            if (!this.animatorSet.isRunning()) {
                this.toBigCircle(listener);
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SmartLoadingView.this.toBigCircle(listener);
                    }
                }, 1000L);
            }
        }
    }

    private void fullScreen(final Activity activity, final Class clazz) {
        if (this.isLoading) {
            if (!this.animatorSet.isRunning()) {
                this.toBigCircle(activity, clazz);
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SmartLoadingView.this.toBigCircle(activity, clazz);
                    }
                }, 1000L);
            }
        }
    }

    private void backToStart(final LoadingListener listener, final boolean success) {
        if (this.isLoading) {
            if (!this.animatorSet.isRunning()) {
                this.backToStartReal(listener, success);
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SmartLoadingView.this.backToStartReal(listener, success);
                    }
                }, 1000L);
            }
        }
    }

    private void backToStartReal(final LoadingListener listener, final boolean success) {
        if (this.animatorNetfail.isRunning()) {
            return;
        }
        this.currentString = this.normalString;
        this.paint.setColor(this.backgroundColor);
        this.textColor = this.textColorOriginal;
        this.animatorNetfail.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                if (listener != null) {
                    listener.loadingFinish(success);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        this.animatorNetfail.start();
    }

    private void changeButtonStatus(boolean success, int buttonType) {
        this.reset();
        this.isFinished = success;
        if (success) {
            if (buttonType == SMART_BUTTON) {
                this.paint.setColor(this.animaled_backgroundColor);
                this.currentString = this.mAnimaledText;
                this.textColor = this.animaled_textColor;
                this.textPaint.setColor(this.textColor);
                this.postInvalidate();
            } else {
                this.current_left = this.default_all_distance;
                int nowAlpha = this.textAlpha / 2 - this.current_left * this.textAlpha / this.default_all_distance < 0 ? 0 : this.textAlpha / 2 - this.current_left * this.textAlpha / this.default_all_distance;
                this.textPaint.setColor(this.addAlpha(this.textColor, nowAlpha));
                if (this.current_left == this.default_all_distance) {
                    this.startDrawOk = true;
                }
                this.effect = new DashPathEffect(new float[]{this.pathMeasure.getLength(), this.pathMeasure.getLength()}, 0.0f * this.pathMeasure.getLength());
                this.okPaint.setPathEffect(this.effect);
                this.postInvalidate();
                if (buttonType == SMART_TICK_HIDE || buttonType == SMART_TICK_CENTER_HIDE) {
                    this.setVisibility(4);
                }
            }
        }
    }

    private void startTick(final LoadingListener listener) {
        if (this.isLoading) {
            if (!this.animatorSet.isRunning()) {
                this.startTickAnimal(listener, false);
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SmartLoadingView.this.startTickAnimal(listener, false);
                    }
                }, 1000L);
            }
        }
    }

    private void startTickHide(final LoadingListener listener) {
        if (this.isLoading) {
            if (!this.animatorSet.isRunning()) {
                this.startTickAnimal(listener, true);
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SmartLoadingView.this.startTickAnimal(listener, true);
                    }
                }, 1000L);
            }
        }
    }

    private void startTickAnimal(final LoadingListener listener, final boolean hide) {
        this.set_draw_ok_animation();
        this.animator_draw_ok.start();
        this.animator_draw_ok.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.loadingFinish(true);
                }
                SmartLoadingView.this.isLoading = false;
                SmartLoadingView.this.isFinished = true;
                SmartLoadingView.this.setClickable(true);
                if (hide) {
                    Animation animations = AnimationUtils.loadAnimation((Context)SmartLoadingView.this.getContext(), (int)R.anim.alpha_hide);
                    SmartLoadingView.this.setAnimation(animations);
                    animations.start();
                    SmartLoadingView.this.setVisibility(4);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void startTickCenterHide(final LoadingListener listener) {
        if (this.isLoading) {
            if (!this.animatorSet.isRunning()) {
                this.startTickCenterHideAnimal(listener);
            } else {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SmartLoadingView.this.startTickCenterHideAnimal(listener);
                    }
                }, 1000L);
            }
        }
    }

    private void startTickCenterHideAnimal(final LoadingListener listener) {
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.height, this.height);
        layoutParams.leftMargin = location[0] + (this.width / 2 - this.height / 2);
        layoutParams.topMargin = location[1];
        final OkView okView = new OkView(this.getContext());
        okView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        okView.setCircleColor(this.backgroundColor);
        okView.setOkColor(this.textColor);
        okView.setRadius(this.height / 2);
        final ViewGroup activityDecorView = (ViewGroup)((Activity)this.getContext()).getWindow().getDecorView();
        activityDecorView.addView((View)okView);
        okView.start(this.duration);
        this.setVisibility(4);
        int window_center_x = UIUtil.getWidth(this.getContext()) / 2;
        int window_center_y = UIUtil.getHeight(this.getContext()) / 2;
        int okView_center_x = location[0] + this.width / 2;
        int okView_center_y = location[1] + this.height / 2;
        ObjectAnimator translationY = ObjectAnimator.ofFloat((Object)((Object)okView), (String)"translationY", (float[])new float[]{0.0f, window_center_y - okView_center_y}).setDuration((long)this.duration);
        ObjectAnimator translationX = ObjectAnimator.ofFloat((Object)((Object)okView), (String)"translationX", (float[])new float[]{0.0f, window_center_x - okView_center_x}).setDuration((long)this.duration);
        ObjectAnimator toViewAnimatorX = ObjectAnimator.ofFloat((Object)((Object)okView), (String)"scaleX", (float[])new float[]{1.0f, 1.3f}).setDuration((long)(this.duration / 2));
        toViewAnimatorX.setRepeatMode(2);
        toViewAnimatorX.setRepeatCount(1);
        toViewAnimatorX.setInterpolator((TimeInterpolator)new AnticipateInterpolator());
        ObjectAnimator toViewAnimatorY = ObjectAnimator.ofFloat((Object)((Object)okView), (String)"scaleY", (float[])new float[]{1.0f, 1.3f}).setDuration((long)(this.duration / 2));
        toViewAnimatorY.setRepeatMode(2);
        toViewAnimatorY.setRepeatCount(1);
        toViewAnimatorY.setInterpolator((TimeInterpolator)new AnticipateInterpolator());
        AnimatorSet animatorScale = new AnimatorSet();
        animatorScale.playTogether(new Animator[]{toViewAnimatorX, toViewAnimatorY});
        ObjectAnimator toViewAnimatorAlpha = ObjectAnimator.ofFloat((Object)((Object)okView), (String)"alpha", (float[])new float[]{1.0f, 0.0f}).setDuration((long)this.duration);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)translationY).with((Animator)translationX).before((Animator)animatorScale).before((Animator)toViewAnimatorAlpha);
        animatorSet.start();
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.loadingFinish(true);
                }
                SmartLoadingView.this.isLoading = false;
                SmartLoadingView.this.setClickable(true);
                activityDecorView.removeView((View)okView);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    private void reset() {
        this.isFinished = false;
        this.textColor = this.textColorOriginal;
        this.textPaint.setColor(this.textColor);
        this.setClickable(true);
        this.currentString = this.normalString;
        this.textPaint.setColor(this.textColor);
        this.circleAngle = this.corners_radius;
        this.paint.setColor(this.backgroundColor);
        this.current_left = 0;
        this.isDrawLoading = false;
        this.startDrawOk = false;
        this.isLoading = false;
        this.invalidate();
        this.animator_draw_ok.cancel();
        this.animatorSet.cancel();
        this.animatorNetfail.cancel();
        if (this.circlBigView != null) {
            this.circlBigView.setCircleR(0);
        }
        this.setVisibility(0);
    }

    private void toBigCircle(LoadingListener listener) {
        this.circlBigView.setRadius(this.getMeasuredHeight() / 2);
        this.circlBigView.setColorBg(this.backgroundColor);
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        this.circlBigView.setXY(location[0] + this.getMeasuredWidth() / 2, location[1]);
        ViewGroup activityDecorView = (ViewGroup)((Activity)this.getContext()).getWindow().getDecorView();
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        activityDecorView.removeView((View)this.circlBigView);
        activityDecorView.addView((View)this.circlBigView, layoutParams);
        this.circlBigView.startShowAni(listener, this);
    }

    private void toBigCircle(Activity activity, Class clazz) {
        this.circlBigView.setRadius(this.getMeasuredHeight() / 2);
        this.circlBigView.setColorBg(this.backgroundColor);
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        this.circlBigView.setXY(location[0] + this.getMeasuredWidth() / 2, location[1]);
        ViewGroup activityDecorView = (ViewGroup)((Activity)this.getContext()).getWindow().getDecorView();
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        activityDecorView.removeView((View)this.circlBigView);
        activityDecorView.addView((View)this.circlBigView, layoutParams);
        this.circlBigView.startShowAni(activity, clazz);
    }

    public static interface LoadingListener {
        public void loadingFinish(boolean var1);
    }
}

