/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ScrollView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import com.lihang.R;
import com.lihang.utils.AnimalUtil;

public class ScrollViewIndicator
extends View {
    private Paint mBackgroundPaint;
    private Paint mProgressPaint;
    private int mViewWidth;
    private int mViewHeight;
    private int mMaxProgress = 100;
    private float mProgress = 0.0f;
    private float mStartTop = 0.0f;
    private ScrollView mBindScrollView;
    private long mDuration = 500L;
    private long mDelayDuration = 1500L;
    private boolean mBackgroundRound = false;
    private boolean mAlwaysShow = false;

    public ScrollViewIndicator(Context context) {
        this(context, null);
    }

    public ScrollViewIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollViewIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ScrollViewIndicator);
        int backgroundColor = typedArray.getColor(R.styleable.ScrollViewIndicator_hl_indicatorBackground, this.getResources().getColor(R.color.default_background_color));
        this.mBackgroundPaint = new Paint(1);
        this.mBackgroundPaint.setColor(backgroundColor);
        this.setBackgroundResource(0);
        this.mBackgroundRound = typedArray.getBoolean(R.styleable.ScrollViewIndicator_hl_background_round, false);
        this.mAlwaysShow = typedArray.getBoolean(R.styleable.ScrollViewIndicator_hl_alwaysShow, false);
        int indicatorColor = typedArray.getColor(R.styleable.ScrollViewIndicator_hl_indicatorColor, this.getResources().getColor(R.color.default_indicator_color));
        this.mProgressPaint = new Paint(1);
        this.mProgressPaint.setColor(indicatorColor);
        float precent = typedArray.getFloat(R.styleable.ScrollViewIndicator_hl_indicatorLength, 0.2f);
        if (precent < 0.0f || precent >= 1.0f) {
            precent = 0.2f;
        }
        this.mProgress = precent * (float)this.mMaxProgress;
        this.mDuration = (long)typedArray.getFloat(R.styleable.ScrollViewIndicator_hl_animalDuration, 500.0f);
        this.mDelayDuration = (long)typedArray.getFloat(R.styleable.ScrollViewIndicator_hl_showDuration, 1500.0f);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (ScrollViewIndicator.this.mBindScrollView != null) {
                    ScrollViewIndicator.this.mBindScrollView.setOverScrollMode(2);
                    ScrollViewIndicator.this.mBindScrollView.setHorizontalScrollBarEnabled(false);
                    ScrollViewIndicator.this.mBindScrollView.setVerticalScrollBarEnabled(false);
                    if (ScrollViewIndicator.this.mBindScrollView.getMeasuredHeight() < ScrollViewIndicator.this.mBindScrollView.getChildAt(0).getMeasuredHeight()) {
                        ScrollViewIndicator.this.setVisibility(0);
                        if (!ScrollViewIndicator.this.mAlwaysShow) {
                            AnimalUtil.cancleAnimate(ScrollViewIndicator.this);
                            AnimalUtil.alphaHide(ScrollViewIndicator.this, ScrollViewIndicator.this.mDuration, 1.0f, 0.0f, ScrollViewIndicator.this.mDelayDuration);
                        }
                    } else {
                        ScrollViewIndicator.this.setVisibility(8);
                    }
                }
                ScrollViewIndicator.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mViewWidth = this.getMeasuredWidth();
        this.mViewHeight = this.getMeasuredHeight();
    }

    protected void onDraw(Canvas canvas) {
        Rect bgRectF;
        super.onDraw(canvas);
        if (this.mBackgroundRound) {
            bgRectF = new RectF(0.0f, 0.0f, (float)this.mViewWidth, (float)this.mViewHeight);
            canvas.drawRoundRect((RectF)bgRectF, (float)(this.mViewHeight / 2), (float)(this.mViewHeight / 2), this.mBackgroundPaint);
        } else {
            bgRectF = new Rect(0, 0, this.mViewWidth, this.mViewHeight);
            canvas.drawRect(bgRectF, this.mBackgroundPaint);
        }
        float height = (float)((double)((float)this.mViewHeight * (this.mProgress * 1.0f / (float)this.mMaxProgress)) + 0.5);
        if (height <= (float)this.mViewWidth) {
            canvas.drawCircle((float)(this.mViewWidth / 2), height / 2.0f, height / 2.0f, this.mProgressPaint);
        } else {
            RectF progressRectF = new RectF(0.0f, this.mStartTop, (float)this.mViewWidth, height + this.mStartTop);
            canvas.drawRoundRect(progressRectF, (float)(this.mViewHeight / 2), (float)(this.mViewHeight / 2), this.mProgressPaint);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
        this.invalidate();
    }

    private void setProgress(float progress) {
        this.mStartTop = progress * ((float)this.mMaxProgress - this.mProgress) * (float)this.mViewHeight / (float)this.mMaxProgress;
        this.postInvalidate();
    }

    public void setIndicatorBackgroundColor(@ColorInt int color2) {
        this.mBackgroundPaint.setColor(color2);
        this.postInvalidate();
    }

    public void setIndicatorColor(@ColorInt int color2) {
        this.mProgressPaint.setColor(color2);
        this.postInvalidate();
    }

    public void bindScrollView(ScrollView mScrollView) {
        this.mBindScrollView = mScrollView;
        if (Build.VERSION.SDK_INT >= 23) {
            mScrollView.setOnScrollChangeListener((v, scrollX, scrollY, oldScrollX, oldScrollY) -> this.bindScrollViewFromScrollListener(v, scrollX, scrollY, oldScrollX, oldScrollY));
        }
    }

    public void bindScrollViewFromScrollListener(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        ScrollView mScrollView;
        this.mBindScrollView = mScrollView = (ScrollView)v;
        if (mScrollView.getMeasuredHeight() < mScrollView.getChildAt(0).getMeasuredHeight()) {
            this.setVisibility(0);
            View firstView = mScrollView.getChildAt(0);
            this.setProgress((float)mScrollView.getScrollY() / (float)(firstView.getMeasuredHeight() - mScrollView.getHeight()));
            if (!this.mAlwaysShow) {
                AnimalUtil.cancleAnimate(this);
                AnimalUtil.alphaHide(this, this.mDuration, 1.0f, 0.0f, this.mDelayDuration);
            }
        }
    }

    @SuppressLint(value={"SupportAnnotationUsage"})
    @FloatRange(from=0.0, to=1.0)
    public void setProcessPrecent(float precent) {
        this.mProgress = precent * (float)this.mMaxProgress;
        this.postInvalidate();
    }
}

