/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.toolbox.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import org.openpdf.text.Document;
import org.openpdf.text.pdf.PRAcroForm;
import org.openpdf.text.pdf.PdfCopy;
import org.openpdf.text.pdf.PdfImportedPage;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.toolbox.AbstractTool;
import org.openpdf.toolbox.arguments.AbstractArgument;
import org.openpdf.toolbox.arguments.FileArgument;
import org.openpdf.toolbox.arguments.StringArgument;
import org.openpdf.toolbox.arguments.filters.PdfFilter;

public class SelectedPages
extends AbstractTool {
    public SelectedPages() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the first part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "selection", "A selection of pages (see Help for more info)"));
    }

    public static void main(String[] args) {
        SelectedPages tool = new SelectedPages();
        if (args.length < 4) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("SelectedPages", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== SelectedPages OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file for the first part of the PDF");
            }
            File dest = (File)this.getValue("destfile");
            String selection = (String)this.getValue("selection");
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            System.out.println("The original file had " + reader.getNumberOfPages() + " pages.");
            reader.selectPages(selection);
            int pages = reader.getNumberOfPages();
            System.err.println("The new file has " + pages + " pages.");
            Document document = new Document(reader.getPageSizeWithRotation(1));
            PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(dest.getAbsolutePath()));
            document.open();
            int i = 0;
            while (i < pages) {
                System.out.println("Processed page " + ++i);
                PdfImportedPage page = copy.getImportedPage(reader, i);
                copy.addPage(page);
            }
            PRAcroForm form = reader.getAcroForm();
            if (form != null) {
                copy.copyAcroForm(reader);
            }
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        SelectedPages.addVersion("$Id: SelectedPages.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

