/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.swing;

import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PdfInformationPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4171577284617028707L;
    String filename = "";
    JLabel label = new JLabel();
    JScrollPane scrollpane = new JScrollPane();
    JPanel panel = new JPanel();

    public PdfInformationPanel() {
        try {
            this.setLayout(new BorderLayout());
            this.label.setHorizontalAlignment(0);
            this.panel.setLayout(new BorderLayout());
            this.add((Component)this.panel, "Center");
            this.scrollpane.setPreferredSize(new Dimension(200, 200));
            this.panel.add((Component)this.scrollpane, "Center");
            this.scrollpane.setViewportView(this.label);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createTextFromPDF(File file) {
        if (file.exists()) {
            int page = 1;
            PdfReader reader = null;
            try (RandomAccessFileOrArray raf = new RandomAccessFileOrArray(file.getAbsolutePath());){
                reader = new PdfReader(raf, null);
                Map pdfinfo = reader.getInfo();
                StringBuilder sb = new StringBuilder();
                sb.append("<html>=== Document Information ===<p>");
                sb.append(reader.getCropBox(page).getHeight()).append("*").append(reader.getCropBox(page).getWidth()).append("<p>");
                sb.append("PDF Version: ").append(reader.getPdfVersion()).append("<p>");
                sb.append("Number of pages: ").append(reader.getNumberOfPages()).append("<p>");
                sb.append("Number of PDF objects: ").append(reader.getXrefSize()).append("<p>");
                sb.append("File length: ").append(reader.getFileLength()).append("<p>");
                sb.append("Encrypted= ").append(reader.isEncrypted()).append("<p>");
                if (pdfinfo.get("Title") != null) {
                    sb.append("Title= ").append((String)pdfinfo.get("Title")).append("<p>");
                }
                if (pdfinfo.get("Author") != null) {
                    sb.append("Author= ").append((String)pdfinfo.get("Author")).append("<p>");
                }
                if (pdfinfo.get("Subject") != null) {
                    sb.append("Subject= ").append((String)pdfinfo.get("Subject")).append("<p>");
                }
                if (pdfinfo.get("Producer") != null) {
                    sb.append("Producer= ").append((String)pdfinfo.get("Producer")).append("<p>");
                }
                if (pdfinfo.get("ModDate") != null) {
                    sb.append("ModDate= ").append(PdfDate.decode((String)((String)pdfinfo.get("ModDate"))).getTime()).append("<p>");
                }
                if (pdfinfo.get("CreationDate") != null) {
                    sb.append("CreationDate= ").append(PdfDate.decode((String)((String)pdfinfo.get("CreationDate"))).getTime()).append("<p>");
                }
                sb.append("</html>");
                this.label.setText(sb.toString());
            }
            catch (IOException ex) {
                this.label.setText("");
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        File file;
        this.filename = evt.getPropertyName();
        if (this.filename.equals("SelectedFileChangedProperty") && (file = (File)evt.getNewValue()) != null) {
            this.createTextFromPDF(file);
            this.repaint();
        }
    }
}

