/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.swing;

import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CustomDialog {
    JDialog dialog = null;
    private JTextField textField = new JTextField(10);
    JPanel jPanel1 = new JPanel();
    PlainDocument plainDocument;
    String msgString1;
    Object[] array;
    private JOptionPane optionPane;

    public CustomDialog(String msgstring, PlainDocument plainDocument) {
        this.setMsgString1(msgstring);
        this.plainDocument = plainDocument;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CustomDialog() {
        this("Enter a value:", new PlainDocument());
    }

    private void jbInit() throws Exception {
        this.textField.setDocument(this.plainDocument);
    }

    public static PlainDocument instantiateFloatDocument() {
        PlainDocument floatDocument = new PlainDocument(){
            private static final long serialVersionUID = 1874451914306029381L;

            @Override
            public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offset, str, a);
                try {
                    Float.parseFloat(super.getText(0, this.getLength()));
                }
                catch (Exception ex) {
                    super.remove(offset, 1);
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        };
        return floatDocument;
    }

    public static PlainDocument instantiateIntegerDocument() {
        PlainDocument intDocument = new PlainDocument(){
            private static final long serialVersionUID = -8735280090112457273L;

            @Override
            public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offset, str, a);
                try {
                    Integer.parseInt(super.getText(0, this.getLength()));
                }
                catch (Exception ex) {
                    super.remove(offset, 1);
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        };
        return intDocument;
    }

    public static PlainDocument instantiateStringDocument() {
        PlainDocument stringDocument = new PlainDocument(){
            private static final long serialVersionUID = -1244429733606195330L;

            @Override
            public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                super.insertString(offset, str, a);
            }
        };
        return stringDocument;
    }

    public void setMsgString1(String msgString1) {
        this.msgString1 = msgString1;
        this.array = new Object[]{msgString1, this.textField};
        this.optionPane = new JOptionPane(this.array, 3, 2);
        this.dialog = this.optionPane.createDialog(UIManager.getString((Object)"OptionPane.inputDialogTitle", null));
    }

    public String showInputDialog(String startvalue) {
        this.textField.setText(startvalue);
        this.dialog.setVisible(true);
        this.dialog.dispose();
        return this.textField.getText();
    }
}

