/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Bookmarks2XML
extends AbstractTool {
    public Bookmarks2XML() {
        this.arguments.add(new FileArgument(this, "pdffile", "the PDF from which you want to extract bookmarks", false, new PdfFilter()));
        this.arguments.add(new FileArgument((AbstractTool)this, "xmlfile", "the resulting bookmarks file in XML", true));
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Bookmarks2XML", true, true, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Bookmarks2XML OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("xmlfile") == null) {
                throw new InstantiationException("You need to choose an xml file");
            }
            if (this.getValue("pdffile") == null) {
                throw new InstantiationException("You need to choose a source PDF file");
            }
            PdfReader reader = new PdfReader(((File)this.getValue("pdffile")).getAbsolutePath());
            reader.consolidateNamedDestinations();
            List bookmarks = SimpleBookmark.getBookmarkList((PdfReader)reader);
            FileOutputStream bmWriter = new FileOutputStream((File)this.getValue("xmlfile"));
            SimpleBookmark.exportToXML((List)bookmarks, (OutputStream)bmWriter, (String)"UTF-8", (boolean)false);
            bmWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Bookmarks2XML tool = new Bookmarks2XML();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static {
        Bookmarks2XML.addVersion("$Id: Bookmarks2XML.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

