/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.rups.controller;

import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionListener;
import org.openpdf.rups.model.ObjectLoader;
import org.openpdf.rups.model.PdfFile;
import org.openpdf.rups.model.TreeNodeFactory;
import org.openpdf.rups.view.PageSelectionListener;
import org.openpdf.rups.view.itext.FormTree;
import org.openpdf.rups.view.itext.OutlineTree;
import org.openpdf.rups.view.itext.PagesTable;
import org.openpdf.rups.view.itext.PdfObjectPanel;
import org.openpdf.rups.view.itext.PdfTree;
import org.openpdf.rups.view.itext.StreamTextArea;
import org.openpdf.rups.view.itext.XRefTable;
import org.openpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import org.openpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import org.openpdf.text.pdf.PRStream;
import org.openpdf.text.pdf.PdfObject;

public class PdfReaderController
extends Observable
implements Observer {
    protected PdfTree pdfTree = new PdfTree();
    protected JTabbedPane navigationTabs;
    protected PagesTable pages;
    protected OutlineTree outlines;
    protected FormTree form;
    protected XRefTable xref;
    protected PdfObjectPanel objectPanel;
    protected JTabbedPane editorTabs;
    protected StreamTextArea streamArea;
    protected TreeNodeFactory nodes;

    public PdfReaderController(TreeSelectionListener treeSelectionListener, PageSelectionListener pageSelectionListener) {
        this.pdfTree.addTreeSelectionListener(treeSelectionListener);
        this.addObserver(this.pdfTree);
        this.pages = new PagesTable(this, pageSelectionListener);
        this.addObserver(this.pages);
        this.outlines = new OutlineTree(this);
        this.addObserver(this.outlines);
        this.form = new FormTree(this);
        this.addObserver(this.form);
        this.xref = new XRefTable(this);
        this.addObserver(this.xref);
        this.navigationTabs = new JTabbedPane();
        this.navigationTabs.addTab("Pages", null, new JScrollPane(this.pages), "Pages");
        this.navigationTabs.addTab("Outlines", null, new JScrollPane(this.outlines), "Outlines (Bookmarks)");
        this.navigationTabs.addTab("Form", null, new JScrollPane(this.form), "Interactive Form");
        this.navigationTabs.addTab("XFA", null, this.form.getXfaTree(), "Tree view of the XFA form");
        this.navigationTabs.addTab("XRef", null, new JScrollPane(this.xref), "Cross-reference table");
        this.objectPanel = new PdfObjectPanel();
        this.addObserver(this.objectPanel);
        this.streamArea = new StreamTextArea();
        this.addObserver(this.streamArea);
        this.editorTabs = new JTabbedPane();
        this.editorTabs.addTab("Stream", null, this.streamArea, "Stream");
        this.editorTabs.addTab("XFA", null, this.form.getXfaTextArea(), "XFA Form XML file");
    }

    public PdfTree getPdfTree() {
        return this.pdfTree;
    }

    public JTabbedPane getNavigationTabs() {
        return this.navigationTabs;
    }

    public PdfObjectPanel getObjectPanel() {
        return this.objectPanel;
    }

    public JTabbedPane getEditorTabs() {
        return this.editorTabs;
    }

    public StreamTextArea getStreamArea() {
        return this.streamArea;
    }

    public void startObjectLoader(PdfFile file) {
        this.setChanged();
        this.notifyObservers();
        this.setChanged();
        new ObjectLoader(this, file.getPdfReader());
    }

    @Override
    public void notifyObservers(Object obj) {
        if (obj instanceof ObjectLoader) {
            ObjectLoader loader = (ObjectLoader)obj;
            this.nodes = loader.getNodes();
            PdfTrailerTreeNode root = this.pdfTree.getRoot();
            root.setTrailer(loader.getReader().getTrailer());
            root.setUserObject("PDF Object Tree");
            this.nodes.expandNode(root);
        }
        super.notifyObservers(obj);
    }

    public void selectNode(PdfObjectTreeNode node) {
        this.pdfTree.selectNode(node);
    }

    public void selectNode(int objectNumber) {
        this.selectNode(this.nodes.getNode(objectNumber));
    }

    public void render(PdfObject object) {
        this.objectPanel.render(object);
        this.streamArea.render(object);
        if (object instanceof PRStream) {
            this.editorTabs.setSelectedComponent(this.streamArea);
        } else {
            this.editorTabs.setSelectedIndex(this.editorTabs.getComponentCount() - 1);
        }
    }

    public void gotoPage(int pageNumber) {
        if (this.pages == null || this.pages.getSelectedRow() == --pageNumber) {
            return;
        }
        if (pageNumber < this.pages.getRowCount()) {
            this.pages.setRowSelectionInterval(pageNumber, pageNumber);
        }
    }

    @Override
    public void update(Observable observable, Object obj) {
        if ("Close".equals(obj)) {
            this.setChanged();
            this.notifyObservers(null);
            this.nodes = null;
        }
        if (obj instanceof PdfObjectTreeNode) {
            PdfObjectTreeNode node = (PdfObjectTreeNode)obj;
            this.nodes.expandNode(node);
            if (node.isRecursive()) {
                this.pdfTree.selectNode(node.getAncestor());
                return;
            }
            this.render(node.getPdfObject());
        }
    }
}

