/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.rups.controller;

import com.lowagie.rups.controller.PdfReaderController;
import com.lowagie.rups.io.FileChooserAction;
import com.lowagie.rups.io.FileCloseAction;
import com.lowagie.rups.model.PdfFile;
import com.lowagie.rups.view.Console;
import com.lowagie.rups.view.PageSelectionListener;
import com.lowagie.rups.view.RupsMenuBar;
import com.lowagie.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.lowagie.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.lowagie.text.DocumentException;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RupsController
extends Observable
implements TreeSelectionListener,
PageSelectionListener {
    protected PdfFile pdfFile;
    protected PdfReaderController readerController;
    protected RupsMenuBar menuBar = new RupsMenuBar(this);
    protected JSplitPane masterComponent;

    public RupsController(Dimension dimension) {
        this.addObserver(this.menuBar);
        Console console = Console.getInstance();
        this.addObserver(console);
        this.readerController = new PdfReaderController(this, this);
        this.addObserver(this.readerController);
        this.masterComponent = new JSplitPane();
        this.masterComponent.setOrientation(0);
        this.masterComponent.setDividerLocation((int)(dimension.getHeight() * 0.7));
        this.masterComponent.setDividerSize(2);
        JSplitPane content = new JSplitPane();
        this.masterComponent.add((Component)content, "top");
        JSplitPane info = new JSplitPane();
        this.masterComponent.add((Component)info, "bottom");
        content.setOrientation(1);
        content.setDividerLocation((int)(dimension.getWidth() * 0.6));
        content.setDividerSize(1);
        content.add((Component)new JScrollPane(this.readerController.getPdfTree()), "left");
        content.add((Component)this.readerController.getNavigationTabs(), "right");
        info.setDividerLocation((int)(dimension.getWidth() * 0.3));
        info.setDividerSize(1);
        info.add((Component)this.readerController.getObjectPanel(), "left");
        JTabbedPane editorPane = this.readerController.getEditorTabs();
        JScrollPane cons = new JScrollPane(console.getTextArea());
        editorPane.addTab("Console", null, cons, "Console window (System.out/System.err)");
        editorPane.setSelectedComponent(cons);
        info.add((Component)editorPane, "right");
    }

    public RupsMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Component getMasterComponent() {
        return this.masterComponent;
    }

    @Override
    public void notifyObservers(Object obj) {
        if (obj instanceof FileChooserAction) {
            File file = ((FileChooserAction)obj).getFile();
            try {
                this.pdfFile = new PdfFile(file);
                this.setChanged();
                super.notifyObservers("Open");
                this.readerController.startObjectLoader(this.pdfFile);
            }
            catch (DocumentException | IOException ioe) {
                JOptionPane.showMessageDialog(this.masterComponent, ioe.getMessage(), "Dialog", 0);
            }
            return;
        }
        if (obj instanceof FileCloseAction) {
            this.pdfFile = null;
            this.setChanged();
            super.notifyObservers("Close");
            return;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        Object selectednode = this.readerController.getPdfTree().getLastSelectedPathComponent();
        if (selectednode instanceof PdfTrailerTreeNode) {
            this.menuBar.update(this, "File");
            return;
        }
        if (selectednode instanceof PdfObjectTreeNode) {
            this.readerController.update(this, selectednode);
        }
    }

    @Override
    public int gotoPage(int pageNumber) {
        this.readerController.gotoPage(pageNumber);
        return pageNumber;
    }
}

