/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfAddableElement;
import java.io.IOException;
import java.io.OutputStream;

public class RtfTab
extends RtfAddableElement {
    public static final int TAB_LEFT_ALIGN = 0;
    public static final int TAB_CENTER_ALIGN = 1;
    public static final int TAB_RIGHT_ALIGN = 2;
    public static final int TAB_DECIMAL_ALIGN = 3;
    private final int position;
    private final int type;

    public RtfTab(float position, int type) {
        this.position = (int)Math.round((double)position * 20.0);
        switch (type) {
            case 0: {
                this.type = 0;
                break;
            }
            case 1: {
                this.type = 1;
                break;
            }
            case 2: {
                this.type = 2;
                break;
            }
            case 3: {
                this.type = 3;
                break;
            }
            default: {
                this.type = 0;
            }
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        switch (this.type) {
            case 1: {
                result.write(DocWriter.getISOBytes((String)"\\tqc"));
                break;
            }
            case 2: {
                result.write(DocWriter.getISOBytes((String)"\\tqr"));
                break;
            }
            case 3: {
                result.write(DocWriter.getISOBytes((String)"\\tqdec"));
            }
        }
        result.write(DocWriter.getISOBytes((String)"\\tx"));
        result.write(this.intToByteArray(this.position));
    }
}

