/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationInfo;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationListener;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationNull;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationStylesheetTable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public final class RtfDestinationMgr {
    private static RtfDestinationMgr instance = null;
    private static final Object lock = new Object();
    private static final Map<String, RtfDestination> destinations = new HashMap<String, RtfDestination>(300, 0.95f);
    private static final Map<String, RtfDestination> destinationObjects = new HashMap<String, RtfDestination>(10, 0.95f);
    private static boolean ignoreUnknownDestinations = false;
    private static RtfParser rtfParser = null;
    public static final String DESTINATION_NULL = "null";
    public static final String DESTINATION_DOCUMENT = "document";

    private RtfDestinationMgr() {
    }

    public static void setParser(RtfParser parser) {
        rtfParser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RtfDestinationMgr getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new RtfDestinationMgr();
                RtfDestinationMgr.addDestination(DESTINATION_DOCUMENT, new Object[]{"RtfDestinationDocument", ""});
                RtfDestinationMgr.addDestination(DESTINATION_NULL, new Object[]{"RtfDestinationNull", ""});
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RtfDestinationMgr getInstance(RtfParser parser) {
        Object object = lock;
        synchronized (object) {
            RtfDestinationMgr.setParser(parser);
            if (instance == null) {
                instance = new RtfDestinationMgr();
                RtfDestinationMgr.addDestination(DESTINATION_DOCUMENT, new Object[]{"RtfDestinationDocument", ""});
                RtfDestinationMgr.addDestination(DESTINATION_NULL, new Object[]{"RtfDestinationNull", ""});
            }
            return instance;
        }
    }

    public static RtfDestination getDestination(String destination) {
        RtfDestination dest = destinations.containsKey(destination) ? destinations.get(destination) : (ignoreUnknownDestinations ? destinations.get(DESTINATION_NULL) : destinations.get(DESTINATION_DOCUMENT));
        dest.setParser(rtfParser);
        return dest;
    }

    public static boolean addDestination(String destination, Object[] args) {
        RtfDestination c;
        Class<?> value;
        if (destinations.containsKey(destination)) {
            return true;
        }
        String thisClass = "com.lowagie.text.rtf.parser.destinations." + args[0];
        if (thisClass.contains("RtfDestinationNull")) {
            destinations.put(destination, RtfDestinationNull.getInstance());
            return true;
        }
        try {
            value = Class.forName(thisClass);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        if (destinationObjects.containsKey(value.getName())) {
            c = destinationObjects.get(value.getName());
        } else {
            try {
                c = (RtfDestination)value.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
        }
        c.setParser(rtfParser);
        if (value.isInstance(RtfDestinationInfo.class)) {
            ((RtfDestinationInfo)c).setElementName(destination);
        }
        if (value.isInstance(RtfDestinationStylesheetTable.class)) {
            ((RtfDestinationStylesheetTable)c).setElementName(destination);
            ((RtfDestinationStylesheetTable)c).setType((String)args[1]);
        }
        destinations.put(destination, c);
        destinationObjects.put(value.getName(), c);
        return true;
    }

    public static boolean addListener(String destination, RtfDestinationListener listener) {
        RtfDestination dest = RtfDestinationMgr.getDestination(destination);
        if (dest != null) {
            return dest.addListener(listener);
        }
        return false;
    }

    public static boolean removeListener(String destination, RtfDestinationListener listener) {
        RtfDestination dest = RtfDestinationMgr.getDestination(destination);
        if (dest != null) {
            return dest.removeListener(listener);
        }
        return false;
    }
}

