/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.direct.RtfDirectContent;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import com.lowagie.text.rtf.parser.destinations.RtfDestinationFontTable;
import com.lowagie.text.rtf.parser.properties.RtfPropertyListener;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class RtfDestinationDocument
extends RtfDestination
implements RtfPropertyListener {
    private RtfDocument rtfDoc = null;
    private Document doc = null;
    private StringBuilder buffer = null;
    private int conversionType = 0;
    private int tableLevel = 0;
    private static final List<String> IMPORT_IGNORED_CTRLWORDS = Arrays.asList("rtf", "ansicpg", "deff", "ansi", "mac", "pca", "pc", "stshfdbch", "stshfloch", "stshfhich", "stshfbi", "deflang", "deflangfe", "adeflang", "adeflangfe");
    private static final List<String> CONVERT_IGNORED_CTRLWORDS = Arrays.asList("rtf");
    private Paragraph iTextParagraph = null;

    public RtfDestinationDocument() {
        super(null);
    }

    public RtfDestinationDocument(RtfParser parser) {
        super(parser);
        this.rtfDoc = parser.getRtfDocument();
        this.doc = parser.getDocument();
        this.conversionType = parser.getConversionType();
        this.setToDefaults();
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.addRtfPropertyListener(this);
        }
    }

    protected void finalize() throws Throwable {
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.removeRtfPropertyListener(this);
        }
        super.finalize();
    }

    @Override
    public void setParser(RtfParser parser) {
        this.rtfParser = parser;
        this.rtfDoc = parser.getRtfDocument();
        this.doc = parser.getDocument();
        this.conversionType = parser.getConversionType();
        this.setToDefaults();
        if (this.rtfParser.isConvert()) {
            this.rtfParser.getState().properties.addRtfPropertyListener(this);
        }
    }

    @Override
    public boolean closeDestination() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        this.rtfParser.getState().properties.removeRtfPropertyListener(this);
        return true;
    }

    @Override
    public boolean handleOpenGroup() {
        this.onOpenGroup();
        if (this.rtfParser.isImport()) {
            // empty if block
        }
        if (this.rtfParser.isConvert() && this.iTextParagraph == null) {
            this.iTextParagraph = new Paragraph();
        }
        return true;
    }

    @Override
    public boolean handleOpeningSubGroup() {
        if (this.rtfParser.isImport() && this.buffer.length() > 0) {
            this.writeBuffer();
        }
        return true;
    }

    @Override
    public boolean handleCloseGroup() {
        this.onCloseGroup();
        if (this.rtfParser.isImport()) {
            if (this.buffer.length() > 0) {
                this.writeBuffer();
            }
            this.writeText("}");
        }
        if (this.rtfParser.isConvert()) {
            if (this.buffer.length() > 0 && this.iTextParagraph == null) {
                this.iTextParagraph = new Paragraph();
            }
            if (this.buffer.length() > 0) {
                Chunk chunk = new Chunk();
                chunk.append(this.buffer.toString());
                this.iTextParagraph.add((Element)chunk);
            }
            if (this.iTextParagraph != null) {
                this.addParagraphToDocument();
            }
        }
        return true;
    }

    @Override
    public boolean handleCharacter(int ch) {
        boolean result = true;
        this.onCharacter(ch);
        if (this.rtfParser.isImport()) {
            if (this.buffer.length() > 254) {
                this.writeBuffer();
            }
            this.buffer.append((char)ch);
        }
        if (this.rtfParser.isConvert()) {
            this.buffer.append((char)ch);
        }
        return result;
    }

    @Override
    public boolean handleControlWord(RtfCtrlWordData ctrlWordData) {
        boolean result;
        this.onCtrlWord(ctrlWordData);
        if (this.rtfParser.isImport()) {
            if (ctrlWordData.ctrlWord.equals("f")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapFontNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("cb")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("cf")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcbpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcbpatraw")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcfpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("clcfpatraw")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("trcfpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("trcbpat")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("brdrcf")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapColorNr(ctrlWordData.param);
            }
            if (ctrlWordData.ctrlWord.equals("ls")) {
                ctrlWordData.param = this.rtfParser.getImportManager().mapListNr(ctrlWordData.param);
            }
        }
        if (this.rtfParser.isConvert()) {
            if (ctrlWordData.ctrlWord.equals("par")) {
                this.addParagraphToDocument();
            }
            if (ctrlWordData.ctrlWord.equals("f")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cf")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clcbpat")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clcbpatraw")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clcfpat")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clcfpatraw")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trcfpat")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trcbpat")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("brdrcf")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trowd")) {
                ++this.tableLevel;
            }
            if (ctrlWordData.ctrlWord.equals("cell")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("row")) {
                ++this.tableLevel;
            }
            if (ctrlWordData.ctrlWord.equals("lastrow")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("row")) {
                ++this.tableLevel;
            }
            if (ctrlWordData.ctrlWord.equals("irow")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("irowband")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tcelld")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("nestcell")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("nestrow")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("nesttableprops")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("nonesttables")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trgaph")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cellx")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clmgf")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clmrg")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clvmgf")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clvmrg")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trauth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trdate")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllkborder")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllkshading")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllkfont")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllkcolor")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllkbestfit")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllkhdrrows")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllklastrow")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllkhdrcols")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllklastcol")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllknorowband")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tbllknocolband")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("taprtl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trautofit")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trhdr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trkeep")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trkeepfollow")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trleft")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trqc")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trql")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trqr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trrh")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddt")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddfb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddfl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddfr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpaddft")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdt")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdfl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdft")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdfb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trspdfr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trwWidth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trftsWidth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trwWidthB")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trftsWidthB")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trftsWidthB")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trwWidthA")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trftsWidthA")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tblind")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tblindtype")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trcbpat")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trcfpat")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trpat")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trshdng")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgbdiag")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgcross")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgdcross")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgdkbdiag")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgdkcross")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgdkdcross")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgdkfdiag")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgdkhor")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgdkvert")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgfdiag")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbghoriz")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbgvert")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clFitText")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clNoWrap")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadt")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadfl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadft")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadfb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clpadfr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clwWidth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clftsWidth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clhidemark")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clins")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cldel")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clmrgd")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clmrgdr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clsplit")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clsplitr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clinsauth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clinsdttm")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cldelauth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cldeldttm")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clmrgdauth")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clmrgddttm")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tdfrmtxtLeft")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tdfrmtxtRight")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tdfrmtxtTop")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tdfrmtxtBottom")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tabsnoovrlp")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tphcol")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tphmrg")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tphpg")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposnegx")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposnegy")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposx")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposxc")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposxi")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposxl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposxo")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposxr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposy")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposyb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposyc")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposyil")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposyin")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposyout")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tposyt")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tpvmrg")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tpvpara")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("tpvpg")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("rtlrow")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("ltrrow")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbrdrt")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbrdrl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbrdrb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbrdrr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbrdrh")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("trbrdrv")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("brdrnil")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clbrdrb")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clbrdrt")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clbrdrl")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("clbrdrr")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cldglu")) {
                // empty if block
            }
            if (ctrlWordData.ctrlWord.equals("cldgll")) {
                // empty if block
            }
        }
        if (ctrlWordData.ctrlWordType == 4) {
            this.rtfParser.getState().properties.toggleProperty(ctrlWordData);
        }
        if (ctrlWordData.ctrlWordType == 2 || ctrlWordData.ctrlWordType == 3) {
            this.rtfParser.getState().properties.setProperty(ctrlWordData);
        }
        switch (this.conversionType) {
            case 0: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(ctrlWordData.ctrlWord)) {
                    this.writeBuffer();
                    this.writeText(ctrlWordData.toString());
                }
                result = true;
                break;
            }
            case 1: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(ctrlWordData.ctrlWord)) {
                    this.writeBuffer();
                    this.writeText(ctrlWordData.toString());
                }
                result = true;
                break;
            }
            case 2: {
                if (!IMPORT_IGNORED_CTRLWORDS.contains(ctrlWordData.ctrlWord)) {
                    // empty if block
                }
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private void writeBuffer() {
        this.writeText(this.buffer.toString());
        this.setToDefaults();
    }

    private void writeText(String value) {
        if (this.rtfParser.isNewGroup()) {
            this.rtfDoc.add(new RtfDirectContent("{"));
            this.rtfParser.setNewGroup(false);
        }
        if (value.length() > 0) {
            this.rtfDoc.add(new RtfDirectContent(value));
        }
    }

    @Override
    public void setToDefaults() {
        this.buffer = new StringBuilder(255);
    }

    @Override
    public void afterPropertyChange(String propertyName) {
        if (propertyName.startsWith("character.") || propertyName.startsWith("paragraph.") || propertyName.startsWith("section.") || propertyName.startsWith("document.")) {
            // empty if block
        }
    }

    @Override
    public void beforePropertyChange(String propertyName) {
        if (this.buffer.length() == 0) {
            return;
        }
        if (propertyName.startsWith("character.")) {
            Chunk chunk = new Chunk();
            chunk.append(this.buffer.toString());
            this.buffer = new StringBuilder(255);
            HashMap<String, Object> charProperties = this.rtfParser.getState().properties.getProperties("character.");
            String defFont = (String)charProperties.get("character.font");
            if (defFont == null) {
                defFont = "0";
            }
            RtfDestinationFontTable fontTable = (RtfDestinationFontTable)this.rtfParser.getDestination("fonttbl");
            Font currFont = fontTable.getFont(defFont);
            int fs = 0;
            if (charProperties.containsKey("character.bold")) {
                fs |= 1;
            }
            if (charProperties.containsKey("character.italic")) {
                fs |= 2;
            }
            if (charProperties.containsKey("character.underline")) {
                fs |= 4;
            }
            Font useFont = FontFactory.getFont((String)currFont.getFamilyname(), (float)12.0f, (int)fs, (Color)new Color(0, 0, 0));
            chunk.setFont(useFont);
            if (this.iTextParagraph == null) {
                this.iTextParagraph = new Paragraph();
            }
            this.iTextParagraph.add((Element)chunk);
        } else if (propertyName.startsWith("paragraph.") || propertyName.startsWith("section.") || propertyName.startsWith("document.")) {
            // empty if block
        }
    }

    private void addParagraphToDocument() {
        if (this.iTextParagraph != null) {
            try {
                this.rtfParser.getDocument().add((Element)this.iTextParagraph);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            this.iTextParagraph = null;
        }
    }
}

