/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.rtf.RtfAddableElement;
import com.lowagie.text.rtf.graphic.RtfImage;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;

public class RtfShapeProperty
extends RtfAddableElement {
    public static final String PROPERTY_IMAGE = "pib";
    public static final String PROPERTY_VERTICIES = "pVerticies";
    public static final String PROPERTY_GEO_TOP = "geoTop";
    public static final String PROPERTY_GEO_LEFT = "geoLeft";
    public static final String PROPERTY_GEO_RIGHT = "geoRight";
    public static final String PROPERTY_GEO_BOTTOM = "geoBottom";
    public static final String PROPERTY_LAYOUT_IN_CELL = "fLayoutInCell";
    public static final String PROPERTY_FLIP_V = "fFlipV";
    public static final String PROPERTY_FLIP_H = "fFlipH";
    public static final String PROPERTY_FILL_COLOR = "fillColor";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    public static final String PROPERTY_ADJUST_VALUE = "adjustValue";
    private static final int PROPERTY_TYPE_LONG = 1;
    private static final int PROPERTY_TYPE_BOOLEAN = 2;
    private static final int PROPERTY_TYPE_DOUBLE = 3;
    private static final int PROPERTY_TYPE_COLOR = 4;
    private static final int PROPERTY_TYPE_ARRAY = 5;
    private static final int PROPERTY_TYPE_IMAGE = 6;
    private int type = 0;
    private final String name;
    private final Object value;

    private RtfShapeProperty(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public RtfShapeProperty(String name, long value) {
        this(name, (Object)value);
        this.type = 1;
    }

    public RtfShapeProperty(String name, double value) {
        this(name, (Object)value);
        this.type = 3;
    }

    public RtfShapeProperty(String name, boolean value) {
        this(name, (Object)value);
        this.type = 2;
    }

    public RtfShapeProperty(String name, Color value) {
        this(name, (Object)value);
        this.type = 4;
    }

    public RtfShapeProperty(String name, int[] value) {
        this(name, (Object)value);
        this.type = 5;
    }

    public RtfShapeProperty(String name, Point[] value) {
        this(name, (Object)value);
        this.type = 5;
    }

    public RtfShapeProperty(String name, Image value) {
        this.name = name;
        this.value = value;
        this.type = 6;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(DocWriter.getISOBytes((String)"\\sp"));
        result.write(OPEN_GROUP);
        result.write(DocWriter.getISOBytes((String)"\\sn"));
        result.write(DELIMITER);
        result.write(DocWriter.getISOBytes((String)this.name));
        result.write(CLOSE_GROUP);
        result.write(OPEN_GROUP);
        result.write(DocWriter.getISOBytes((String)"\\sv"));
        result.write(DELIMITER);
        switch (this.type) {
            case 1: 
            case 3: {
                result.write(DocWriter.getISOBytes((String)this.value.toString()));
                break;
            }
            case 2: {
                if (((Boolean)this.value).booleanValue()) {
                    result.write(DocWriter.getISOBytes((String)"1"));
                    break;
                }
                result.write(DocWriter.getISOBytes((String)"0"));
                break;
            }
            case 4: {
                Color color = (Color)this.value;
                result.write(this.intToByteArray(color.getRed() | color.getGreen() << 8 | color.getBlue() << 16));
                break;
            }
            case 5: {
                if (this.value instanceof int[]) {
                    int[] values = (int[])this.value;
                    result.write(DocWriter.getISOBytes((String)"4;"));
                    result.write(this.intToByteArray(values.length));
                    result.write(COMMA_DELIMITER);
                    for (int i = 0; i < values.length; ++i) {
                        result.write(this.intToByteArray(values[i]));
                        if (i >= values.length - 1) continue;
                        result.write(COMMA_DELIMITER);
                    }
                } else {
                    if (!(this.value instanceof Point[])) break;
                    Point[] values = (Point[])this.value;
                    result.write(DocWriter.getISOBytes((String)"8;"));
                    result.write(this.intToByteArray(values.length));
                    result.write(COMMA_DELIMITER);
                    for (int i = 0; i < values.length; ++i) {
                        result.write(DocWriter.getISOBytes((String)"("));
                        result.write(this.intToByteArray(values[i].x));
                        result.write(DocWriter.getISOBytes((String)","));
                        result.write(this.intToByteArray(values[i].y));
                        result.write(DocWriter.getISOBytes((String)")"));
                        if (i >= values.length - 1) continue;
                        result.write(COMMA_DELIMITER);
                    }
                }
                break;
            }
            case 6: {
                RtfImage img;
                Image image = (Image)this.value;
                try {
                    img = new RtfImage(this.doc, image);
                }
                catch (DocumentException de) {
                    throw new ExceptionConverter((Exception)((Object)de));
                }
                img.setTopLevelElement(true);
                result.write(OPEN_GROUP);
                img.writeContent(result);
                result.write(CLOSE_GROUP);
            }
        }
        result.write(CLOSE_GROUP);
        result.write(CLOSE_GROUP);
    }
}

