/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Footnote;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.SimpleTable;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.field.RtfAnchor;
import com.lowagie.text.rtf.graphic.RtfImage;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListItem;
import com.lowagie.text.rtf.table.RtfTable;
import com.lowagie.text.rtf.text.RtfAnnotation;
import com.lowagie.text.rtf.text.RtfChapter;
import com.lowagie.text.rtf.text.RtfChunk;
import com.lowagie.text.rtf.text.RtfFootnote;
import com.lowagie.text.rtf.text.RtfNewPage;
import com.lowagie.text.rtf.text.RtfParagraph;
import com.lowagie.text.rtf.text.RtfPhrase;
import com.lowagie.text.rtf.text.RtfSection;
import com.lowagie.text.rtf.text.RtfTab;
import java.util.ArrayList;

public class RtfMapper {
    private final RtfDocument rtfDoc;

    public RtfMapper(RtfDocument doc) {
        this.rtfDoc = doc;
    }

    public RtfBasicElement[] mapElement(Element element) throws DocumentException {
        if (element instanceof RtfBasicElement) {
            RtfBasicElement rtfElement = (RtfBasicElement)element;
            rtfElement.setRtfDocument(this.rtfDoc);
            return new RtfBasicElement[]{rtfElement};
        }
        ArrayList<RtfBasicElement> rtfElements = new ArrayList<RtfBasicElement>();
        switch (element.type()) {
            case 10: {
                Chunk chunk = (Chunk)element;
                if (chunk.hasAttributes()) {
                    if (chunk.getChunkAttributes().containsKey("IMAGE")) {
                        rtfElements.add(new RtfImage(this.rtfDoc, chunk.getImage()));
                        break;
                    }
                    if (chunk.getChunkAttributes().containsKey("NEWPAGE")) {
                        rtfElements.add(new RtfNewPage(this.rtfDoc));
                        break;
                    }
                    if (chunk.getChunkAttributes().containsKey("TAB")) {
                        Float tabPos = (Float)((Object[])chunk.getChunkAttributes().get("TAB"))[1];
                        RtfTab tab = new RtfTab(tabPos.floatValue(), 0);
                        tab.setRtfDocument(this.rtfDoc);
                        rtfElements.add(tab);
                        rtfElements.add(new RtfChunk(this.rtfDoc, new Chunk("\t")));
                        break;
                    }
                    rtfElements.add(new RtfChunk(this.rtfDoc, (Chunk)element));
                    break;
                }
                rtfElements.add(new RtfChunk(this.rtfDoc, (Chunk)element));
                break;
            }
            case 11: {
                rtfElements.add(new RtfPhrase(this.rtfDoc, (Phrase)element));
                break;
            }
            case 12: {
                rtfElements.add(new RtfParagraph(this.rtfDoc, (Paragraph)element));
                break;
            }
            case 17: {
                rtfElements.add(new RtfAnchor(this.rtfDoc, (Anchor)element));
                break;
            }
            case 29: {
                rtfElements.add(new RtfAnnotation(this.rtfDoc, (Annotation)element));
                break;
            }
            case 56: {
                rtfElements.add(new RtfFootnote(this.rtfDoc, (Footnote)element));
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                rtfElements.add(new RtfImage(this.rtfDoc, (Image)element));
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                rtfElements.add(new RtfInfoElement(this.rtfDoc, (Meta)element));
                break;
            }
            case 14: {
                rtfElements.add(new RtfList(this.rtfDoc, (List)element));
                break;
            }
            case 15: {
                rtfElements.add(new RtfListItem(this.rtfDoc, (ListItem)element));
                break;
            }
            case 13: {
                rtfElements.add(new RtfSection(this.rtfDoc, (Section)element));
                break;
            }
            case 16: {
                rtfElements.add(new RtfChapter(this.rtfDoc, (Chapter)element));
                break;
            }
            case 22: {
                try {
                    rtfElements.add(new RtfTable(this.rtfDoc, (Table)element));
                }
                catch (ClassCastException e) {
                    rtfElements.add(new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable()));
                }
                break;
            }
            case 23: {
                try {
                    rtfElements.add(new RtfTable(this.rtfDoc, (PdfPTable)element));
                    break;
                }
                catch (ClassCastException e) {
                    rtfElements.add(new RtfTable(this.rtfDoc, ((SimpleTable)element).createTable()));
                }
            }
        }
        return rtfElements.toArray(new RtfBasicElement[0]);
    }
}

