/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf.parser;

import java.io.IOException;
import java.util.ArrayList;
import org.openpdf.text.ExceptionConverter;
import org.openpdf.text.pdf.PRTokeniser;
import org.openpdf.text.pdf.PdfContentParser;
import org.openpdf.text.pdf.PdfDictionary;
import org.openpdf.text.pdf.PdfLiteral;
import org.openpdf.text.pdf.PdfName;
import org.openpdf.text.pdf.PdfObject;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.text.pdf.RandomAccessFileOrArray;
import org.openpdf.text.pdf.parser.MarkedUpTextAssembler;
import org.openpdf.text.pdf.parser.MatchedPattern;
import org.openpdf.text.pdf.parser.PdfContentStreamHandler;
import org.openpdf.text.pdf.parser.PdfContentTextLocator;
import org.openpdf.text.pdf.parser.TextAssembler;

public class PdfTextLocator {
    private final PdfReader reader;
    private final TextAssembler renderListener;

    public PdfTextLocator(PdfReader reader) {
        this(reader, new MarkedUpTextAssembler(reader));
    }

    public PdfTextLocator(PdfReader reader, boolean usePdfMarkupElements) {
        this(reader, new MarkedUpTextAssembler(reader, usePdfMarkupElements));
    }

    public PdfTextLocator(PdfReader reader, TextAssembler renderListener) {
        this.reader = reader;
        this.renderListener = renderListener;
    }

    private byte[] getContentBytesForPage(int pageNum) throws IOException {
        try (RandomAccessFileOrArray ignored = this.reader.getSafeFile();){
            PdfDictionary pageDictionary = this.reader.getPageN(pageNum);
            PdfObject contentObject = pageDictionary.get(PdfName.CONTENTS);
            byte[] byArray = this.getContentBytesFromContentObject(contentObject);
            return byArray;
        }
    }

    private byte[] getContentBytesFromContentObject(PdfObject contentObject) throws IOException {
        return PdfContentStreamHandler.getContentBytesFromPdfObjectStatic(contentObject);
    }

    public ArrayList<MatchedPattern> searchPage(int page, String pattern) throws IOException {
        PdfDictionary pageDict = this.reader.getPageN(page);
        if (pageDict == null) {
            return new ArrayList<MatchedPattern>();
        }
        PdfDictionary resources = pageDict.getAsDict(PdfName.RESOURCES);
        this.renderListener.reset();
        this.renderListener.setPage(page);
        PdfContentTextLocator handler = new PdfContentTextLocator(this.renderListener, pattern, page);
        this.processContent(this.getContentBytesForPage(page), resources, handler);
        return handler.getMatchedPatterns();
    }

    public ArrayList<MatchedPattern> searchFile(String pattern) throws IOException {
        ArrayList<MatchedPattern> res = new ArrayList<MatchedPattern>();
        for (int page = 1; page <= this.reader.getNumberOfPages(); ++page) {
            res.addAll(this.searchPage(page, pattern));
        }
        return res;
    }

    public void processContent(byte[] contentBytes, PdfDictionary resources, PdfContentTextLocator handler) {
        handler.pushContext("div class='t-extracted-page'");
        try {
            PdfContentParser ps = new PdfContentParser(new PRTokeniser(contentBytes));
            ArrayList<PdfObject> operands = new ArrayList<PdfObject>();
            while (!ps.parse(operands).isEmpty()) {
                PdfLiteral operator = (PdfLiteral)operands.getLast();
                handler.invokeOperator(operator, operands, resources);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        handler.popContext();
    }
}

