/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfObject;
import java.util.Objects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PdfNumber
extends PdfObject
implements Comparable<PdfNumber> {
    private double value;

    public PdfNumber(String content) {
        super(2);
        try {
            this.value = Double.parseDouble(content.trim());
            this.setContent(content);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("1.is.not.a.valid.number.2", content, nfe.toString()));
        }
    }

    public PdfNumber(int value) {
        super(2);
        this.value = value;
        this.setContent(String.valueOf(value));
    }

    public PdfNumber(long value) {
        super(2);
        this.value = value;
        this.setContent(String.valueOf(value));
    }

    public PdfNumber(double value) {
        super(2);
        this.value = value;
        this.setContent(ByteBuffer.formatDouble(value));
    }

    public PdfNumber(float value) {
        this((double)value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public void increment() {
        this.value += 1.0;
        this.setContent(ByteBuffer.formatDouble(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PdfNumber)) {
            return false;
        }
        PdfNumber pdfNumber = (PdfNumber)o;
        return Double.compare(pdfNumber.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public int compareTo(PdfNumber o) {
        Objects.requireNonNull(o, "PdfNumber is null, can't be compared to current instance.");
        if (this == o) {
            return 0;
        }
        return Double.compare(o.value, this.value);
    }
}

