/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.font;

import java.io.IOException;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.font.CIDFontType0;
import org.openpdf.renderer.font.PDFFont;
import org.openpdf.renderer.font.PDFFontDescriptor;
import org.openpdf.renderer.font.PDFGlyph;

public class Type0Font
extends PDFFont {
    PDFFont[] fonts;

    public Type0Font(String baseFont, PDFObject fontObj, PDFFontDescriptor descriptor) throws IOException {
        super(baseFont, descriptor);
        PDFObject[] descendantFonts = fontObj.getDictRef("DescendantFonts").getArray();
        this.fonts = new PDFFont[descendantFonts.length];
        for (int i = 0; i < descendantFonts.length; ++i) {
            PDFFont descFont = Type0Font.getFont(descendantFonts[i], null);
            if (descFont instanceof CIDFontType0) {
                ((CIDFontType0)descFont).parseToUnicodeMap(fontObj);
            }
            this.fonts[i] = descFont;
        }
    }

    public PDFFont getDescendantFont(int fontID) {
        return this.fonts[fontID];
    }

    @Override
    protected PDFGlyph getGlyph(char src, String name) {
        return this.getDescendantFont(0).getGlyph(src, name);
    }
}

