/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.function;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Stack;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.function.PDFFunction;
import org.openpdf.renderer.function.postscript.PostScriptParser;
import org.openpdf.renderer.function.postscript.operation.OperationSet;
import org.openpdf.renderer.function.postscript.operation.PostScriptOperation;

public class FunctionType4
extends PDFFunction {
    private List<String> tokens;
    private Stack<Object> stack;

    protected FunctionType4() {
        super(4);
    }

    @Override
    protected void parse(PDFObject obj) throws IOException {
        ByteBuffer buf = obj.getStreamBuffer();
        byte[] byteA = new byte[buf.remaining()];
        buf.get(byteA);
        String scriptContent = new String(byteA, "UTF-8");
        this.tokens = new PostScriptParser().parse(scriptContent);
    }

    @Override
    protected void doFunction(float[] inputs, int inputOffset, float[] outputs, int outputOffset) {
        this.prepareInitialStack(inputs, inputOffset);
        for (String token : this.tokens) {
            PostScriptOperation op = OperationSet.getInstance().getOperation(token);
            op.eval(this.stack);
        }
        this.assertResultIsCorrect(outputs, outputOffset);
        this.prepareResult(outputs, outputOffset);
    }

    private void prepareResult(float[] outputs, int outputOffset) {
        for (int i = outputOffset; i < outputs.length; ++i) {
            outputs[outputs.length - i - 1] = ((Double)this.stack.pop()).floatValue();
        }
    }

    private void prepareInitialStack(float[] inputs, int inputOffset) {
        this.stack = new Stack();
        for (int i = inputOffset; i < inputs.length; ++i) {
            this.stack.push(Float.valueOf(inputs[i]));
        }
    }

    private void assertResultIsCorrect(float[] outputs, int outputOffset) {
        int expectedResults = outputs.length - outputOffset;
        if (this.stack.size() != expectedResults) {
            throw new IllegalStateException("Output does not match result " + expectedResults + "/" + String.valueOf(this.stack));
        }
    }
}

