/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.annotation;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openpdf.renderer.PDFCmd;
import org.openpdf.renderer.PDFImage;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.PDFPage;
import org.openpdf.renderer.PDFParseException;
import org.openpdf.renderer.PDFParser;
import org.openpdf.renderer.annotation.AnnotationBorderStyle;
import org.openpdf.renderer.annotation.AnnotationType;
import org.openpdf.renderer.annotation.PDFAnnotation;

public class MarkupAnnotation
extends PDFAnnotation {
    private PDFObject onAppearance;
    private PDFObject offAppearance;
    private List<PDFCmd> onCmd;
    private List<PDFCmd> offCmd;
    private boolean appearanceStateOn;
    private AnnotationBorderStyle borderStyle;
    private String textLabel;
    private PDFAnnotation popupAnnotation;

    public MarkupAnnotation(PDFObject annotObject, AnnotationType type) throws IOException {
        super(annotObject, type);
        this.textLabel = annotObject.getDictRefAsString("T");
        this.parsePopupAnnotation(annotObject.getDictRef("Popup"));
        this.parseAP(annotObject.getDictRef("AP"));
        this.parseBorderStyleDictionary(annotObject.getDictRef("BS"));
    }

    protected void parseAP(PDFObject dictRef) throws IOException {
        if (dictRef == null) {
            return;
        }
        PDFObject normalAP = dictRef.getDictRef("N");
        if (normalAP == null) {
            return;
        }
        if (normalAP.getType() == 6) {
            this.onAppearance = normalAP.getDictRef("On");
            this.offAppearance = normalAP.getDictRef("Off");
            PDFObject as = dictRef.getDictRef("AS");
            this.appearanceStateOn = as != null && "On".equals(as.getStringValue());
        } else {
            this.onAppearance = normalAP;
            this.offAppearance = null;
            this.appearanceStateOn = true;
        }
        this.parseOnOffCommands();
    }

    private void parseOnOffCommands() throws IOException {
        if (this.onAppearance != null) {
            this.onCmd = this.parseIntoPdfCommands(this.onAppearance);
        }
        if (this.offAppearance != null) {
            this.offCmd = this.parseIntoPdfCommands(this.offAppearance);
        }
    }

    protected void parseBorderStyleDictionary(PDFObject bs) throws IOException {
        if (bs != null) {
            this.borderStyle = AnnotationBorderStyle.parseFromDictionary(bs);
        }
    }

    public AnnotationBorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    private void parsePopupAnnotation(PDFObject popupObj) throws IOException {
        this.popupAnnotation = popupObj != null ? MarkupAnnotation.createAnnotation(popupObj) : null;
    }

    private List<PDFCmd> parseIntoPdfCommands(PDFObject obj) throws IOException {
        String type = obj.getDictRef("Subtype").getStringValue();
        if (type == null) {
            type = obj.getDictRef("S").getStringValue();
        }
        ArrayList<PDFCmd> result = new ArrayList<PDFCmd>();
        result.add(PDFPage.createPushCmd());
        result.add(PDFPage.createPushCmd());
        if (type.equals("Image")) {
            AffineTransform rectAt = this.getPositionTransformation();
            result.add(PDFPage.createXFormCmd(rectAt));
            PDFImage img = PDFImage.createImage(obj, new HashMap<String, PDFObject>(), false);
            result.add(PDFPage.createImageCmd(img));
        } else if (type.equals("Form")) {
            AffineTransform at;
            PDFObject bobj = obj.getDictRef("BBox");
            float xMin = bobj.getAt(0).getFloatValue();
            float yMin = bobj.getAt(1).getFloatValue();
            float xMax = bobj.getAt(2).getFloatValue();
            float yMax = bobj.getAt(3).getFloatValue();
            Rectangle2D.Float bbox = new Rectangle2D.Float(xMin, yMin, xMax - xMin, yMax - yMin);
            PDFPage formCmds = new PDFPage(bbox, 0);
            AffineTransform rectAt = this.getPositionTransformation();
            formCmds.addXform(rectAt);
            AffineTransform rectScaled = this.getScalingTransformation(bbox);
            formCmds.addXform(rectScaled);
            PDFObject matrix = obj.getDictRef("Matrix");
            if (matrix == null) {
                at = new AffineTransform();
            } else {
                float[] elts = new float[6];
                for (int i = 0; i < elts.length; ++i) {
                    elts[i] = matrix.getAt(i).getFloatValue();
                }
                at = new AffineTransform(elts);
            }
            formCmds.addXform(at);
            HashMap<String, PDFObject> r = new HashMap<String, PDFObject>(new HashMap());
            PDFObject rsrc = obj.getDictRef("Resources");
            if (rsrc != null) {
                r.putAll(rsrc.getDictionary());
            }
            PDFParser form = new PDFParser(formCmds, obj.getStream(), r);
            form.go(true);
            result.addAll(formCmds.getCommands());
        } else {
            throw new PDFParseException("Unknown XObject subtype: " + type);
        }
        result.add(PDFPage.createPopCmd());
        result.add(PDFPage.createPopCmd());
        return result;
    }

    private AffineTransform getPositionTransformation() {
        Rectangle2D.Float rect2 = this.getRect();
        double[] f = new double[]{1.0, 0.0, 0.0, 1.0, rect2.getMinX(), rect2.getMinY()};
        return new AffineTransform(f);
    }

    public PDFObject getOnAppearance() {
        return this.onAppearance;
    }

    public PDFObject getOffAppearance() {
        return this.offAppearance;
    }

    public boolean isAppearanceStateOn() {
        return this.appearanceStateOn;
    }

    public void switchAppearance() {
        this.appearanceStateOn = !this.appearanceStateOn;
    }

    public PDFObject getCurrentAppearance() {
        return this.appearanceStateOn ? this.onAppearance : this.offAppearance;
    }

    public List<PDFCmd> getCurrentCommand() {
        return this.appearanceStateOn ? this.onCmd : this.offCmd;
    }

    @Override
    public List<PDFCmd> getPageCommandsForAnnotation() {
        List<PDFCmd> pageCommandsForAnnotation = super.getPageCommandsForAnnotation();
        pageCommandsForAnnotation.addAll(this.getCurrentCommand());
        return pageCommandsForAnnotation;
    }

    public PDFAnnotation getPopupAnnotation() {
        return this.popupAnnotation;
    }

    public String getTextLabel() {
        return this.textLabel;
    }
}

