/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer;

import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import org.openpdf.renderer.PDFObject;

public class PDFDebugger {
    public static final String DEBUG_DCTDECODE_DATA = "debugdctdecode";
    public static final boolean DEBUG_TEXT = false;
    public static final boolean DEBUG_IMAGES = false;
    public static final boolean DEBUG_OPERATORS = false;
    public static final boolean DEBUG_PATH = false;
    public static final int DEBUG_STOP_AT_INDEX = 0;
    public static final boolean DISABLE_TEXT = false;
    public static final boolean DISABLE_IMAGES = false;
    public static final boolean DISABLE_PATH_STROKE = false;
    public static final boolean DISABLE_PATH_FILL = false;
    public static final boolean DISABLE_PATH_STROKE_FILL = false;
    public static final boolean DISABLE_CLIP = false;
    public static final boolean DISABLE_FORMS = false;
    public static final boolean DISABLE_SHADER = false;
    public static final boolean SHOW_TEXT_REGIONS = false;
    public static final boolean SHOW_TEXT_ANCHOR = false;
    public static final boolean DISABLE_THUMBNAILS = false;
    public static final long DRAW_DELAY = 0L;
    public static int debuglevel = 4000;

    public static void debugImage(BufferedImage image, String name) {
    }

    public static void debug(String msg, int level) {
        if (level > debuglevel) {
            System.out.println(PDFDebugger.escape(msg));
        }
    }

    public static void debug(String msg) {
        PDFDebugger.debug(msg, debuglevel);
    }

    public static String escape(String msg) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msg.length(); ++i) {
            int c = msg.charAt(i);
            if (c != 10 && (c < 32 || c >= 127)) {
                c = 63;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static void setDebugLevel(int level) {
        debuglevel = level;
    }

    public static String dumpStream(byte[] stream) {
        return PDFDebugger.escape(new String(stream).replace('\r', '\n'));
    }

    public static void logPath(GeneralPath path, String operation) {
    }

    public static void dump(PDFObject obj) throws IOException {
        PDFDebugger.debug("dumping PDF object: " + String.valueOf(obj));
        if (obj == null) {
            return;
        }
        HashMap<String, PDFObject> dict = obj.getDictionary();
        PDFDebugger.debug("   dict = " + String.valueOf(dict));
        for (String key : dict.keySet()) {
            PDFDebugger.debug("key = " + String.valueOf(key) + " value = " + String.valueOf(dict.get(key)));
        }
    }

    public static class DebugStopException
    extends Exception {
    }
}

