/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.decode.Predictor;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TIFFPredictor
extends Predictor {
    public TIFFPredictor() {
        super(0);
    }

    @Override
    public ByteBuffer unpredict(ByteBuffer imageData) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(imageData.limit());
        int numComponents = this.getColors();
        int pixelBits = numComponents * this.getBitsPerComponent();
        int bytePerRow = (this.getColumns() * pixelBits + 7) / 8;
        byte[] row = new byte[bytePerRow];
        while (imageData.remaining() > 0) {
            imageData.get(row);
            if (this.getBitsPerComponent() == 8) {
                for (int i = numComponents; i < row.length; i += numComponents) {
                    for (int c = 0; c < numComponents; ++c) {
                        int n = pos = i + c;
                        row[n] = (byte)(row[n] + row[pos - numComponents]);
                    }
                }
            } else if (this.getBitsPerComponent() == 16) {
                short[] prev = new short[numComponents];
                for (int c = 0; c < numComponents; ++c) {
                    pos = c * 2;
                    prev[c] = (short)(row[pos] << 8 | row[pos + 1] & 0xFFFF);
                }
                for (int i = numComponents * 2; i < row.length; i += numComponents * 2) {
                    for (int c = 0; c < numComponents; ++c) {
                        int pos = i + c * 2;
                        short cur = (short)(row[pos] << 8 | row[pos + 1] & 0xFFFF);
                        cur = (short)(cur + prev[c]);
                        row[pos] = (byte)(cur >>> 8 & 0xFF);
                        row[pos + 1] = (byte)(cur & 0xFF);
                        prev[c] = cur;
                    }
                }
            } else {
                assert (this.getBitsPerComponent() == 1 || this.getBitsPerComponent() == 2 || this.getBitsPerComponent() == 4) : "we don't want to grab components across pixel boundaries";
                int bitsOnRow = pixelBits * this.getColumns();
                byte[] prev = new byte[numComponents];
                int shiftWhenAligned = 8 - this.getBitsPerComponent();
                int mask = (1 << this.getBitsPerComponent()) - 1;
                for (int c = 0; c < numComponents; ++c) {
                    prev[c] = TIFFPredictor.getbits(row, c * this.getBitsPerComponent(), shiftWhenAligned, mask);
                }
                for (int i = pixelBits; i < bitsOnRow; i += pixelBits) {
                    for (int c = 0; c < numComponents; ++c) {
                        byte cur = TIFFPredictor.getbits(row, i + c * this.getBitsPerComponent(), shiftWhenAligned, mask);
                        prev[c] = cur = (byte)(cur + prev[c]);
                        TIFFPredictor.setbits(row, i + c * this.getBitsPerComponent(), shiftWhenAligned, mask, cur);
                    }
                }
            }
            out.put(row);
        }
        out.flip();
        return out;
    }

    private static byte getbits(byte[] data, int bitIndex, int shiftWhenByteAligned, int mask) {
        byte b = data[bitIndex >> 3];
        int bitIndexInB = bitIndex & 7;
        int shift = shiftWhenByteAligned - bitIndexInB;
        return (byte)(b >>> shift & mask);
    }

    private static void setbits(byte[] data, int bitIndex, int shiftWhenByteAligned, int mask, byte bits) {
        byte b = data[bitIndex >> 3];
        int bitIndexInB = bitIndex & 7;
        int shift = shiftWhenByteAligned - bitIndexInB;
        data[bitIndex >> 3] = (byte)(b & ~(mask << shift) | bits << shift);
    }
}

