/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.BaseWatchable;
import com.sun.pdfview.PDFCmd;
import com.sun.pdfview.PDFPaint;
import com.sun.pdfview.PDFRenderer;
import com.sun.pdfview.PDFShapeCmd;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;

class PDFShadeCommand
extends PDFCmd {
    PDFPaint p;
    Rectangle2D box;

    PDFShadeCommand(PDFPaint p, Rectangle2D box) {
        this.p = p;
        this.box = box;
    }

    PDFShadeCommand(PDFPaint p) {
        this.p = p;
        this.box = null;
    }

    @Override
    public Rectangle2D execute(PDFRenderer state) {
        Shape s = this.box;
        Rectangle clip = state.getImage().getGraphics().getClipBounds();
        if (clip != null) {
            s = clip;
        }
        if (s == null) {
            s = state.getImage().getData().getBounds();
            try {
                s = state.getLastTransform().createInverse().createTransformedShape(s);
            }
            catch (NoninvertibleTransformException e) {
                BaseWatchable.getErrorHandler().publishException(e);
            }
        }
        state.setFillAlpha(1.0f);
        state.setFillPaint(this.p);
        return new PDFShapeCmd(new GeneralPath(s), 2, false).execute(state);
    }
}

