/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.BaseWatchable;
import com.sun.pdfview.ByteBufferInputStream;
import com.sun.pdfview.Configuration;
import com.sun.pdfview.PDFDebugger;
import com.sun.pdfview.PDFImageParseException;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.PdfSubByteSampleModel;
import com.sun.pdfview.colorspace.AlternateColorSpace;
import com.sun.pdfview.colorspace.IndexedColor;
import com.sun.pdfview.colorspace.PDFColorSpace;
import com.sun.pdfview.colorspace.YCCKColorSpace;
import com.sun.pdfview.decode.PDFDecoder;
import com.sun.pdfview.function.FunctionType0;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PackedColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class PDFImage {
    private static int[][] GREY_TO_ARGB = new int[8][];
    private int[] colorKeyMask = null;
    private int width;
    private int height;
    private PDFColorSpace colorSpace;
    private int bpc;
    private boolean imageMask = false;
    private PDFImage sMask;
    private float[] decode;
    private final PDFObject imageObj;
    private final boolean jpegDecode;

    protected PDFImage(PDFObject imageObj) throws IOException {
        this.imageObj = imageObj;
        this.jpegDecode = PDFDecoder.isLastFilter(imageObj, PDFDecoder.DCT_FILTERS);
    }

    public static PDFImage createImage(PDFObject obj, Map<String, PDFObject> resources, boolean useAsSMask) throws IOException {
        PDFImage image = new PDFImage(obj);
        PDFObject widthObj = obj.getDictRef("Width");
        if (widthObj == null) {
            throw new PDFParseException("Unable to read image width: " + String.valueOf(obj));
        }
        image.setWidth(widthObj.getIntValue());
        PDFObject heightObj = obj.getDictRef("Height");
        if (heightObj == null) {
            throw new PDFParseException("Unable to get image height: " + String.valueOf(obj));
        }
        image.setHeight(heightObj.getIntValue());
        PDFObject imageMaskObj = obj.getDictRef("ImageMask");
        if (imageMaskObj != null) {
            image.setImageMask(imageMaskObj.getBooleanValue());
        }
        if (image.isImageMask()) {
            PDFObject[] decodeArray;
            float decode0;
            Color[] colorArray;
            image.setBitsPerComponent(1);
            if (useAsSMask) {
                Color[] colorArray2 = new Color[2];
                colorArray2[0] = Color.WHITE;
                colorArray = colorArray2;
                colorArray2[1] = Color.BLACK;
            } else {
                Color[] colorArray3 = new Color[2];
                colorArray3[0] = Color.BLACK;
                colorArray = colorArray3;
                colorArray3[1] = Color.WHITE;
            }
            Color[] colors = colorArray;
            PDFObject imageMaskDecode = obj.getDictRef("Decode");
            if (imageMaskDecode != null && (decode0 = (decodeArray = imageMaskDecode.getArray())[0].getFloatValue()) == 1.0f) {
                Color[] colorArray4;
                if (useAsSMask) {
                    Color[] colorArray5 = new Color[2];
                    colorArray5[0] = Color.BLACK;
                    colorArray4 = colorArray5;
                    colorArray5[1] = Color.WHITE;
                } else {
                    Color[] colorArray6 = new Color[2];
                    colorArray6[0] = Color.WHITE;
                    colorArray4 = colorArray6;
                    colorArray6[1] = Color.BLACK;
                }
                colors = colorArray4;
            }
            image.setColorSpace(new IndexedColor(colors));
        } else {
            PDFObject sMaskObj;
            PDFObject bpcObj = obj.getDictRef("BitsPerComponent");
            if (bpcObj == null) {
                throw new PDFParseException("Unable to get bits per component: " + String.valueOf(obj));
            }
            image.setBitsPerComponent(bpcObj.getIntValue());
            PDFObject csObj = obj.getDictRef("ColorSpace");
            if (csObj == null) {
                throw new PDFParseException("No ColorSpace for image: " + String.valueOf(obj));
            }
            PDFColorSpace cs = PDFColorSpace.getColorSpace(csObj, resources);
            image.setColorSpace(cs);
            PDFObject decodeObj = obj.getDictRef("Decode");
            if (decodeObj != null) {
                PDFObject[] decodeArray = decodeObj.getArray();
                float[] decode = new float[decodeArray.length];
                for (int i = 0; i < decodeArray.length; ++i) {
                    decode[i] = decodeArray[i].getFloatValue();
                }
                image.setDecode(decode);
            }
            if ((sMaskObj = obj.getDictRef("SMask")) == null) {
                sMaskObj = obj.getDictRef("Mask");
            }
            if (sMaskObj != null) {
                if (sMaskObj.getType() == 7) {
                    try {
                        PDFImage sMaskImage = PDFImage.createImage(sMaskObj, resources, true);
                        image.setSMask(sMaskImage);
                    }
                    catch (IOException ex) {
                        PDFDebugger.debug("ERROR: there was a problem parsing the mask for this object");
                        PDFDebugger.dump(obj);
                        BaseWatchable.getErrorHandler().publishException(ex);
                    }
                } else if (sMaskObj.getType() == 5) {
                    try {
                        image.setColorKeyMask(sMaskObj);
                    }
                    catch (IOException ex) {
                        PDFDebugger.debug("ERROR: there was a problem parsing the color mask for this object");
                        PDFDebugger.dump(obj);
                        BaseWatchable.getErrorHandler().publishException(ex);
                    }
                }
            }
        }
        return image;
    }

    public BufferedImage getImage() throws PDFImageParseException {
        try {
            BufferedImage bi = (BufferedImage)this.imageObj.getCache();
            if (bi == null) {
                byte[] data = this.imageObj.getStream();
                ByteBuffer jpegBytes = null;
                if (this.jpegDecode) {
                    jpegBytes = this.imageObj.getStreamBuffer(PDFDecoder.DCT_FILTERS);
                }
                bi = this.parseData(data, jpegBytes);
                this.imageObj.setCache(bi);
            }
            return bi;
        }
        catch (IOException ioe) {
            throw new PDFImageParseException("Error reading image: " + ioe.getMessage(), ioe);
        }
    }

    protected BufferedImage parseData(byte[] data, ByteBuffer jpegData) throws IOException {
        ColorModel cm = this.createColorModel();
        BufferedImage bi = null;
        if (jpegData != null) {
            jpegData.mark();
            JpegDecoder decoder = new JpegDecoder(jpegData, cm);
            IOException decodeEx = null;
            try {
                bi = decoder.decode();
            }
            catch (IOException e) {
                decodeEx = e;
                decoder.ycckcmykDecodeMode(true);
                try {
                    bi = decoder.decode();
                }
                catch (IOException e2) {
                    bi = this.parseData(data, null);
                    return bi;
                }
            }
            cm = decoder.getColorModel();
            jpegData = null;
            decoder = null;
            if (bi == null) {
                assert (decodeEx != null);
                throw new IOException(decodeEx.getMessage() + ". Maybe installing JAI for expanded image format support would help?", decodeEx);
            }
        } else {
            WritableRaster raster;
            DataBufferByte db = new DataBufferByte(data, data.length);
            cm = this.getColorModel();
            SampleModel sm = cm.createCompatibleSampleModel(this.getWidth(), this.getHeight());
            try {
                raster = Raster.createWritableRaster(sm, db, new Point(0, 0));
            }
            catch (RasterFormatException e) {
                int tempExpectedSize = this.getWidth() * this.getHeight() * this.getColorSpace().getNumComponents() * Math.max(8, this.getBitsPerComponent()) / 8;
                if (tempExpectedSize < 3) {
                    tempExpectedSize = 3;
                }
                if (tempExpectedSize > data.length) {
                    byte[] tempLargerData = new byte[tempExpectedSize];
                    System.arraycopy(data, 0, tempLargerData, 0, data.length);
                    db = new DataBufferByte(tempLargerData, tempExpectedSize);
                    raster = Raster.createWritableRaster(sm, db, new Point(0, 0));
                }
                throw e;
            }
            bi = null;
            if (cm instanceof IndexColorModel) {
                IndexColorModel icm = (IndexColorModel)cm;
                int type = 12;
                if (this.getBitsPerComponent() == 8) {
                    type = 13;
                }
                bi = new BufferedImage(this.getWidth(), this.getHeight(), type, icm);
                bi.setData(raster);
            } else if (cm.getPixelSize() == 1 && cm.getNumComponents() == 1) {
                int[] cc = new int[]{0, 1};
                PDFObject o = this.imageObj.getDictRef("Decode");
                if (o != null && o.getAt(0) != null) {
                    cc[0] = o.getAt(0).getIntValue();
                    cc[1] = o.getAt(1).getIntValue();
                }
                byte[] ncc = new byte[]{(byte)(-cc[0]), (byte)(-cc[1])};
                bi = this.biColorToGrayscale(raster, ncc);
                if (this.getSMask() == null) {
                    return bi;
                }
            } else {
                bi = new BufferedImage(cm, raster, true, null);
            }
        }
        ColorSpace cs = cm.getColorSpace();
        ColorSpace rgbCS = ColorSpace.getInstance(1000);
        if (this.isGreyscale(cs) && this.bpc <= 8 && this.getDecode() == null && jpegData == null && Configuration.getInstance().isConvertGreyscaleImagesToArgb()) {
            bi = this.convertGreyscaleToArgb(data, bi);
        } else if (!this.isImageMask() && cs instanceof ICC_ColorSpace && !cs.equals(rgbCS) && !Configuration.getInstance().isAvoidColorConvertOp()) {
            ColorConvertOp op = new ColorConvertOp(cs, rgbCS, null);
            BufferedImage converted = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            bi = op.filter(bi, converted);
        } else if (cs.getType() == 9) {
            BufferedImage converted = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D graphics = converted.createGraphics();
            graphics.drawImage((Image)bi, 0, 0, null);
            graphics.dispose();
            bi = converted;
        }
        PDFImage sMaskImage = this.getSMask();
        if (sMaskImage != null) {
            BufferedImage si = null;
            try {
                boolean maskOnly;
                int w = bi.getWidth();
                int h = bi.getHeight();
                boolean bl = maskOnly = w <= 2;
                if (maskOnly) {
                    si = sMaskImage.getImage();
                    w = si.getWidth();
                    h = si.getHeight();
                } else if (sMaskImage.getHeight() != h && sMaskImage.getWidth() != w) {
                    if (sMaskImage.getHeight() * sMaskImage.getWidth() > w * h) {
                        si = sMaskImage.getImage();
                        w = si.getWidth();
                        h = si.getHeight();
                        int hints = 2;
                        Image scaledInstance = bi.getScaledInstance(w, h, hints);
                        bi = new BufferedImage(w, h, 2);
                        Graphics2D graphics = bi.createGraphics();
                        graphics.drawImage(scaledInstance, 0, 0, null);
                        graphics.dispose();
                    } else {
                        si = this.scaleSMaskImage(sMaskImage);
                    }
                } else {
                    si = sMaskImage.getImage();
                }
                PDFDebugger.debugImage(si, "smask" + this.imageObj.getObjNum());
                BufferedImage outImage = new BufferedImage(w, h, 2);
                PDFDebugger.debugImage(si, "outImage" + this.imageObj.getObjNum());
                int[] srcArray = new int[w];
                int[] maskArray = new int[w];
                for (int i = 0; i < h; ++i) {
                    if (maskOnly) {
                        Arrays.fill(srcArray, bi.getRGB(0, 0));
                    } else {
                        bi.getRGB(0, i, w, 1, srcArray, 0, w);
                    }
                    si.getRGB(0, i, w, 1, maskArray, 0, w);
                    for (int j = 0; j < w; ++j) {
                        int ac = -16777216;
                        maskArray[j] = (maskArray[j] & 0xFF) << 24 | srcArray[j] & ~ac;
                    }
                    outImage.setRGB(0, i, w, 1, maskArray, 0, w);
                }
                bi = outImage;
            }
            catch (PDFImageParseException e) {
                PDFDebugger.debug("Error parsing sMask image caused by:" + e.getMessage(), 100);
            }
        }
        PDFDebugger.debugImage(bi, "result" + this.imageObj.getObjNum());
        return bi;
    }

    private BufferedImage scaleSMaskImage(PDFImage sMaskImage) throws PDFImageParseException {
        BufferedImage before = sMaskImage.getImage();
        int w = before.getWidth();
        int h = before.getHeight();
        BufferedImage after = new BufferedImage(w, h, 2);
        AffineTransform at = new AffineTransform();
        at.scale((double)this.width / (double)w, (double)this.height / (double)h);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        return scaleOp.filter(before, after);
    }

    private boolean isGreyscale(ColorSpace aCs) {
        return aCs == PDFColorSpace.getColorSpace(0).getColorSpace();
    }

    private BufferedImage convertGreyscaleToArgb(byte[] data, BufferedImage bi) {
        int[] convertedPixels = new int[this.getWidth() * this.getHeight()];
        WritableRaster r = bi.getRaster();
        int i = 0;
        int[] greyToArgbMap = PDFImage.getGreyToArgbMap(this.bpc);
        if (this.bpc == 1) {
            int calculatedLineBytes = (this.getWidth() + 7) / 8;
            if (greyToArgbMap[0] == 0 && greyToArgbMap[1] == -1) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    int rowStartByteIndex = y * calculatedLineBytes;
                    for (int x = 0; x < this.getWidth(); ++x) {
                        byte b = data[rowStartByteIndex + x / 8];
                        int white = b >> 7 - (x & 7) & 1;
                        convertedPixels[i] = 0xFF000000 | white - 1 ^ 0xFFFFFF;
                        ++i;
                    }
                }
            } else {
                for (int y = 0; y < this.getHeight(); ++y) {
                    int rowStartByteIndex = y * calculatedLineBytes;
                    for (int x = 0; x < this.getWidth(); ++x) {
                        byte b = data[rowStartByteIndex + x / 8];
                        int val = b >> 7 - (x & 7) & 1;
                        convertedPixels[i] = greyToArgbMap[val];
                        ++i;
                    }
                }
            }
        } else {
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    int greyscale = r.getSample(x, y, 0);
                    convertedPixels[i] = greyToArgbMap[greyscale];
                    ++i;
                }
            }
        }
        ColorModel ccm = ColorModel.getRGBdefault();
        return new BufferedImage(ccm, Raster.createPackedRaster(new DataBufferInt(convertedPixels, convertedPixels.length), this.getWidth(), this.getHeight(), this.getWidth(), ((PackedColorModel)ccm).getMasks(), null), false, null);
    }

    private static int[] getGreyToArgbMap(int numBits) {
        assert (numBits <= 8);
        int[] argbVals = GREY_TO_ARGB[numBits - 1];
        if (argbVals == null) {
            argbVals = PDFImage.createGreyToArgbMap(numBits);
        }
        return argbVals;
    }

    private static int[] createGreyToArgbMap(int numBits) {
        ColorSpace greyCs = PDFColorSpace.getColorSpace(0).getColorSpace();
        byte[] greyVals = new byte[1 << numBits];
        for (int i = 0; i < greyVals.length; ++i) {
            greyVals[i] = (byte)(i & 0xFF);
        }
        int[] argbVals = new int[greyVals.length];
        int mask = (1 << numBits) - 1;
        WritableRaster inRaster = Raster.createPackedRaster(new DataBufferByte(greyVals, greyVals.length), greyVals.length, 1, greyVals.length, new int[]{mask}, null);
        BufferedImage greyImage = new BufferedImage(new PdfComponentColorModel(greyCs, new int[]{numBits}), inRaster, false, null);
        ColorModel ccm = ColorModel.getRGBdefault();
        WritableRaster outRaster = Raster.createPackedRaster(new DataBufferInt(argbVals, argbVals.length), argbVals.length, 1, argbVals.length, ((PackedColorModel)ccm).getMasks(), null);
        BufferedImage srgbImage = new BufferedImage(ccm, outRaster, false, null);
        ColorConvertOp op = new ColorConvertOp(greyCs, ColorSpace.getInstance(1000), null);
        op.filter(greyImage, srgbImage);
        PDFImage.GREY_TO_ARGB[numBits - 1] = argbVals;
        return argbVals;
    }

    private BufferedImage biColorToGrayscale(WritableRaster raster, byte[] ncc) {
        byte[] bufferO = ((DataBufferByte)raster.getDataBuffer()).getData();
        BufferedImage converted = new BufferedImage(this.getWidth(), this.getHeight(), 10);
        byte[] buffer = ((DataBufferByte)converted.getRaster().getDataBuffer()).getData();
        int i = 0;
        int height = converted.getHeight();
        int width = converted.getWidth();
        for (int y = 0; y < height; ++y) {
            int j;
            byte bits;
            int x;
            int base = y * width + 7;
            if ((y + 1) * width < buffer.length) {
                for (x = 0; x < width; x += 8) {
                    bits = bufferO[i];
                    ++i;
                    for (j = 7; j >= 0 && buffer.length > base - j; j = (int)((byte)(j - 1))) {
                        int c = bits >>> j & 1;
                        buffer[base - j] = ncc[c];
                    }
                    base += 8;
                }
                continue;
            }
            for (x = 0; x < width; x += 8) {
                bits = bufferO[i];
                ++i;
                for (j = 7; j >= 0 && base - j < buffer.length; j = (int)((byte)(j - 1))) {
                    buffer[base - j] = ncc[bits >>> j & 1];
                }
                base += 8;
            }
        }
        return converted;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    private void setColorKeyMask(PDFObject maskArrayObject) throws IOException {
        PDFObject[] maskObjects = maskArrayObject.getArray();
        this.colorKeyMask = null;
        int[] masks = new int[maskObjects.length];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = maskObjects[i].getIntValue();
        }
        this.colorKeyMask = masks;
    }

    protected PDFColorSpace getColorSpace() {
        return this.colorSpace;
    }

    protected void setColorSpace(PDFColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    protected int getBitsPerComponent() {
        return this.bpc;
    }

    protected void setBitsPerComponent(int bpc) {
        this.bpc = bpc;
    }

    public boolean isImageMask() {
        return this.imageMask;
    }

    public void setImageMask(boolean imageMask) {
        this.imageMask = imageMask;
    }

    public PDFImage getSMask() {
        return this.sMask;
    }

    protected void setSMask(PDFImage sMask) {
        this.sMask = sMask;
    }

    protected float[] getDecode() {
        return this.decode;
    }

    protected void setDecode(float[] decode) {
        this.decode = decode;
    }

    private ColorModel getColorModel() {
        PDFColorSpace cs = this.getColorSpace();
        if (cs instanceof IndexedColor) {
            int i;
            int correctCount;
            IndexedColor ics = (IndexedColor)cs;
            byte[] components = ics.getColorComponents();
            int num = ics.getCount();
            if (this.decode != null) {
                byte[] normComps = new byte[components.length];
                for (int i2 = 0; i2 < num; ++i2) {
                    byte[] orig = new byte[]{(byte)i2};
                    float[] res = this.normalize(orig, null, 0);
                    int idx = (int)res[0];
                    normComps[i2 * 3] = components[idx * 3];
                    normComps[i2 * 3 + 1] = components[idx * 3 + 1];
                    normComps[i2 * 3 + 2] = components[idx * 3 + 2];
                }
                components = normComps;
            }
            if ((correctCount = 1 << this.getBitsPerComponent()) < num) {
                byte[] fewerComps = new byte[correctCount * 3];
                System.arraycopy(components, 0, fewerComps, 0, correctCount * 3);
                components = fewerComps;
                num = correctCount;
            }
            if (this.colorKeyMask == null || this.colorKeyMask.length == 0) {
                return new IndexColorModel(this.getBitsPerComponent(), num, components, 0, false);
            }
            byte[] aComps = new byte[num * 4];
            int idx = 0;
            for (i = 0; i < num; ++i) {
                aComps[idx++] = components[i * 3];
                aComps[idx++] = components[i * 3 + 1];
                aComps[idx++] = components[i * 3 + 2];
                aComps[idx++] = -1;
            }
            for (i = 0; i < this.colorKeyMask.length; i += 2) {
                for (int j = this.colorKeyMask[i]; j <= this.colorKeyMask[i + 1]; ++j) {
                    aComps[j * 4 + 3] = 0;
                }
            }
            return new IndexColorModel(this.getBitsPerComponent(), num, aComps, 0, true);
        }
        if (cs instanceof AlternateColorSpace) {
            ColorSpace altCS = cs.getColorSpace();
            int[] bits = new int[altCS.getNumComponents()];
            for (int i = 0; i < bits.length; ++i) {
                bits[i] = this.getBitsPerComponent();
            }
            return new DecodeComponentColorModel(altCS, bits);
        }
        if (this.jpegDecode && cs.getColorSpace().getType() == 9) {
            ColorSpace rgbCS = ColorSpace.getInstance(1000);
            int[] bits = new int[rgbCS.getNumComponents()];
            for (int i = 0; i < bits.length; ++i) {
                bits[i] = this.getBitsPerComponent();
            }
            return new DecodeComponentColorModel(rgbCS, bits);
        }
        ColorSpace colorSpace = cs.getColorSpace();
        int[] bits = new int[colorSpace.getNumComponents()];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = this.getBitsPerComponent();
        }
        return new DecodeComponentColorModel(cs.getColorSpace(), bits);
    }

    private float[] normalize(byte[] pixels, float[] normComponents, int normOffset) {
        if (normComponents == null) {
            normComponents = new float[normOffset + pixels.length];
        }
        float[] decodeArray = this.getDecode();
        for (int i = 0; i < pixels.length; ++i) {
            int val = pixels[i] & 0xFF;
            int pow = (int)Math.pow(2.0, this.getBitsPerComponent()) - 1;
            float ymin = decodeArray[i * 2];
            float ymax = decodeArray[i * 2 + 1];
            normComponents[normOffset + i] = FunctionType0.interpolate(val, 0.0f, pow, ymin, ymax);
        }
        return normComponents;
    }

    private ColorModel createColorModel() {
        PDFColorSpace cs = this.getColorSpace();
        if (cs instanceof IndexedColor) {
            int i;
            int correctCount;
            IndexedColor ics = (IndexedColor)cs;
            byte[] components = ics.getColorComponents();
            int num = ics.getCount();
            if (this.decode != null) {
                byte[] normComps = new byte[components.length];
                for (int i2 = 0; i2 < num; ++i2) {
                    byte[] orig = new byte[]{(byte)i2};
                    float[] res = this.normalize(orig, null, 0);
                    int idx = (int)res[0];
                    normComps[i2 * 3] = components[idx * 3];
                    normComps[i2 * 3 + 1] = components[idx * 3 + 1];
                    normComps[i2 * 3 + 2] = components[idx * 3 + 2];
                }
                components = normComps;
            }
            if ((correctCount = 1 << this.getBitsPerComponent()) < num) {
                byte[] fewerComps = new byte[correctCount * 3];
                System.arraycopy(components, 0, fewerComps, 0, correctCount * 3);
                components = fewerComps;
                num = correctCount;
            }
            if (this.colorKeyMask == null || this.colorKeyMask.length == 0) {
                return new IndexColorModel(this.getBitsPerComponent(), num, components, 0, false);
            }
            byte[] aComps = new byte[num * 4];
            int idx = 0;
            for (i = 0; i < num; ++i) {
                aComps[idx++] = components[i * 3];
                aComps[idx++] = components[i * 3 + 1];
                aComps[idx++] = components[i * 3 + 2];
                aComps[idx++] = -1;
            }
            for (i = 0; i < this.colorKeyMask.length; i += 2) {
                for (int j = this.colorKeyMask[i]; j <= this.colorKeyMask[i + 1]; ++j) {
                    aComps[j * 4 + 3] = 0;
                }
            }
            return new IndexColorModel(this.getBitsPerComponent(), num, aComps, 0, true);
        }
        int[] bits = new int[cs.getNumComponents()];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = this.getBitsPerComponent();
        }
        return this.decode != null ? new DecodeComponentColorModel(cs.getColorSpace(), bits) : new PdfComponentColorModel(cs.getColorSpace(), bits);
    }

    private class JpegDecoder {
        private final ByteBuffer jpegData;
        private ColorModel cm;
        private boolean ycckcmykDecodeMode = false;

        private JpegDecoder(ByteBuffer jpegData, ColorModel cm) {
            this.jpegData = jpegData;
            this.cm = cm;
        }

        public void ycckcmykDecodeMode(boolean ycckcmykDecodeMode) {
            this.ycckcmykDecodeMode = ycckcmykDecodeMode;
        }

        public ColorModel getColorModel() {
            return this.cm;
        }

        private BufferedImage decode() throws IOException {
            ImageReadParam readParam = null;
            if (PDFImage.this.getDecode() != null) {
                readParam = new ImageReadParam();
                SampleModel sm = this.cm.createCompatibleSampleModel(PDFImage.this.getWidth(), PDFImage.this.getHeight());
                WritableRaster raster = Raster.createWritableRaster(sm, new Point(0, 0));
                readParam.setDestination(new BufferedImage(this.cm, raster, true, null));
            }
            Iterator<ImageReader> jpegReaderIt = ImageIO.getImageReadersByFormatName("jpeg");
            IIOException lastIioEx = null;
            while (jpegReaderIt.hasNext()) {
                ImageReader jpegReader = jpegReaderIt.next();
                jpegReader.setInput(ImageIO.createImageInputStream(new ByteBufferInputStream(this.jpegData)), true, false);
                try {
                    BufferedImage bufferedImage = this.readImage(jpegReader, readParam);
                    jpegReader.dispose();
                    return bufferedImage;
                }
                catch (Exception e) {
                    try {
                        try {
                            if (e instanceof IIOException) {
                                throw (IIOException)e;
                            }
                            throw new IIOException("Internal reader error?", e);
                        }
                        catch (Throwable throwable) {
                            jpegReader.dispose();
                            throw throwable;
                        }
                    }
                    catch (IIOException e2) {
                        this.jpegData.reset();
                        lastIioEx = e2;
                    }
                }
            }
            throw lastIioEx;
        }

        private BufferedImage readImage(ImageReader jpegReader, ImageReadParam param) throws IOException {
            if (this.ycckcmykDecodeMode) {
                String typeName;
                boolean YCCK;
                Attr csTypeNameNode;
                Node csType;
                Node chroma;
                Node standardMeta;
                IIOMetadata imageMeta = jpegReader.getImageMetadata(0);
                if (imageMeta != null && (standardMeta = imageMeta.getAsTree("javax_imageio_1.0")) != null && (chroma = this.getChild(standardMeta, "Chroma")) != null && (csType = this.getChild(chroma, "ColorSpaceType")) != null && (csTypeNameNode = (Attr)csType.getAttributes().getNamedItem("name")) != null && ((YCCK = "YCCK".equals(typeName = csTypeNameNode.getValue())) || "CMYK".equals(typeName))) {
                    Raster raster = jpegReader.readRaster(0, param);
                    if (YCCK) {
                        PDFImage.this.colorSpace = new PDFColorSpace(new YCCKColorSpace(PDFImage.this.colorSpace.getColorSpace()));
                        this.cm = PDFImage.this.createColorModel();
                    }
                    return new BufferedImage(this.cm, Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null), true, null);
                }
                throw new IIOException("Neither YCCK nor CMYK image");
            }
            if (param != null && param.getDestination() != null) {
                return jpegReader.read(0, param);
            }
            BufferedImage bi = jpegReader.read(0, param);
            try {
                return new BufferedImage(this.cm, bi.getRaster(), true, null);
            }
            catch (IllegalArgumentException raster_ByteInterleavedRaster) {
                BufferedImage bi2 = new BufferedImage(bi.getWidth(), bi.getHeight(), 13, new IndexColorModel(8, 1, new byte[]{0}, new byte[]{0}, new byte[]{0}, 0));
                this.cm = bi2.getColorModel();
                return bi2;
            }
        }

        private Node getChild(Node aNode, String aChildName) {
            for (int i = 0; i < aNode.getChildNodes().getLength(); ++i) {
                Node child = aNode.getChildNodes().item(i);
                if (!child.getNodeName().equals(aChildName)) continue;
                return child;
            }
            return null;
        }
    }

    static class PdfComponentColorModel
    extends ComponentColorModel {
        int bitsPerComponent;

        public PdfComponentColorModel(ColorSpace cs, int[] bpc) {
            super(cs, bpc, false, false, 1, 0);
            this.pixel_bits = bpc.length * bpc[0];
            this.bitsPerComponent = bpc[0];
        }

        @Override
        public SampleModel createCompatibleSampleModel(int width, int height) {
            if (this.bitsPerComponent >= 8) {
                assert (this.bitsPerComponent == 8 || this.bitsPerComponent == 16);
                int numComponents = this.getNumComponents();
                int[] bandOffsets = new int[numComponents];
                for (int i = 0; i < numComponents; ++i) {
                    bandOffsets[i] = i;
                }
                return new PixelInterleavedSampleModel(this.getTransferType(), width, height, numComponents, width * numComponents, bandOffsets);
            }
            switch (this.getPixelSize()) {
                case 1: 
                case 2: 
                case 4: {
                    return new MultiPixelPackedSampleModel(this.getTransferType(), width, height, this.getPixelSize());
                }
            }
            assert (this.getTransferType() == 0);
            return new PdfSubByteSampleModel(width, height, this.getNumComponents(), this.bitsPerComponent);
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            if (this.bitsPerComponent < 8 || this.getNumComponents() == 1) {
                SampleModel sm = raster.getSampleModel();
                return sm.getSampleSize(0) == this.bitsPerComponent;
            }
            return super.isCompatibleRaster(raster);
        }
    }

    class DecodeComponentColorModel
    extends ComponentColorModel {
        public DecodeComponentColorModel(ColorSpace cs, int[] bpc) {
            super(cs, bpc, false, false, 1, 0);
            if (bpc != null) {
                this.pixel_bits = bpc.length * bpc[0];
            }
        }

        @Override
        public SampleModel createCompatibleSampleModel(int width, int height) {
            if (this.getNumComponents() == 1 && this.getPixelSize() < 8) {
                return new MultiPixelPackedSampleModel(this.getTransferType(), width, height, this.getPixelSize());
            }
            return super.createCompatibleSampleModel(width, height);
        }

        @Override
        public boolean isCompatibleRaster(Raster raster) {
            if (this.getNumComponents() == 1 && this.getPixelSize() < 8) {
                SampleModel sm = raster.getSampleModel();
                if (sm instanceof MultiPixelPackedSampleModel) {
                    return sm.getSampleSize(0) == this.getPixelSize();
                }
                return false;
            }
            return super.isCompatibleRaster(raster);
        }

        @Override
        public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
            if (PDFImage.this.getDecode() == null) {
                return super.getNormalizedComponents(pixel, normComponents, normOffset);
            }
            return PDFImage.this.normalize((byte[])pixel, normComponents, normOffset);
        }
    }
}

