/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview;

import com.sun.pdfview.PDFDebugger;
import com.sun.pdfview.PDFErrorHandler;
import com.sun.pdfview.Watchable;

public abstract class BaseWatchable
implements Watchable,
Runnable {
    private int status = 0;
    private final Object statusLock = new Object();
    private final Object parserLock = new Object();
    private Gate gate;
    private static boolean SuppressSetErrorStackTrace = false;
    private Thread thread;
    private Exception exception;
    private static PDFErrorHandler errorHandler = new PDFErrorHandler();

    protected BaseWatchable() {
        this.setStatus(1);
    }

    protected abstract int iterate() throws Exception;

    protected void setup() {
    }

    protected void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            Thread.sleep(1L);
            if (this.getStatus() == 1) {
                this.setup();
            }
            this.setStatus(2);
            Object object = this.parserLock;
            // MONITORENTER : object
            while (!this.isFinished() && this.getStatus() != 5) {
                if (this.isExecutable()) {
                    this.setStatus(4);
                    try {
                        int laststatus = 4;
                        while (!(this.getStatus() != 4 || this.gate != null && this.gate.iterate())) {
                            int status = this.iterate();
                            if (status == laststatus) continue;
                            this.setStatus(status);
                            laststatus = status;
                        }
                        if (this.getStatus() != 4) continue;
                        this.setStatus(2);
                    }
                    catch (Exception ex) {
                        this.setError(ex);
                    }
                    continue;
                }
                Object object2 = this.statusLock;
                // MONITORENTER : object2
                if (!this.isExecutable()) {
                    try {
                        this.statusLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : object2
            }
            // MONITOREXIT : object
            if (this.getStatus() == 6 || this.getStatus() == 7) {
                this.cleanup();
            }
        }
        catch (InterruptedException e) {
            PDFDebugger.debug("Interrupted.");
        }
        this.thread = null;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean isFinished() {
        int s = this.getStatus();
        return s == 6 || s == 7;
    }

    public boolean isExecutable() {
        return !(this.status != 2 && this.status != 4 || this.gate != null && this.gate.stop());
    }

    @Override
    public void stop() {
        if (!this.isFinished()) {
            this.setStatus(5);
        }
    }

    @Override
    public synchronized void go() {
        this.gate = null;
        this.execute(false);
    }

    public synchronized void go(boolean synchronous) {
        this.gate = null;
        this.execute(synchronous);
    }

    @Override
    public synchronized void go(int steps) {
        this.gate = new Gate();
        this.gate.setStopIterations(steps);
        this.execute(false);
    }

    @Override
    public synchronized void go(long millis) {
        this.gate = new Gate();
        this.gate.setStopTime(millis);
        this.execute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinish() {
        Object object = this.statusLock;
        synchronized (object) {
            while (!this.isFinished() && this.getStatus() != 5) {
                try {
                    this.statusLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void execute(boolean synchronous) {
        if (this.thread != null) {
            Object object = this.statusLock;
            synchronized (object) {
                this.statusLock.notifyAll();
            }
            return;
        }
        if (this.isFinished()) {
            return;
        }
        if (synchronous) {
            this.thread = Thread.currentThread();
            this.run();
        } else {
            this.thread = new Thread(this);
            this.thread.setName(this.getClass().getName());
            Object object = this.statusLock;
            synchronized (object) {
                Thread.UncaughtExceptionHandler h = new Thread.UncaughtExceptionHandler(this){

                    @Override
                    public void uncaughtException(Thread th, Throwable ex) {
                        PDFDebugger.debug("Uncaught exception: " + String.valueOf(ex));
                    }
                };
                this.thread.setUncaughtExceptionHandler(h);
                this.thread.start();
                try {
                    this.statusLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStatus(int status) {
        Object object = this.statusLock;
        synchronized (object) {
            this.status = status;
            this.statusLock.notifyAll();
        }
    }

    public static boolean isSuppressSetErrorStackTrace() {
        return SuppressSetErrorStackTrace;
    }

    public static void setSuppressSetErrorStackTrace(boolean suppressTrace) {
        SuppressSetErrorStackTrace = suppressTrace;
    }

    protected void setError(Exception error) {
        this.exception = error;
        if (!SuppressSetErrorStackTrace) {
            errorHandler.publishException(error);
        }
        this.setStatus(7);
    }

    public Exception getException() {
        return this.exception;
    }

    public static void setErrorHandler(PDFErrorHandler e) {
        errorHandler = e;
    }

    public static PDFErrorHandler getErrorHandler() {
        if (errorHandler == null) {
            errorHandler = new PDFErrorHandler();
        }
        return errorHandler;
    }

    static class Gate {
        private boolean timeBased;
        private long nextGate;

        Gate() {
        }

        public void setStopTime(long millisFromNow) {
            this.timeBased = true;
            this.nextGate = System.currentTimeMillis() + millisFromNow;
        }

        public void setStopIterations(int iterations) {
            this.timeBased = false;
            this.nextGate = iterations;
        }

        public boolean stop() {
            if (this.timeBased) {
                return System.currentTimeMillis() >= this.nextGate;
            }
            return this.nextGate < 0L;
        }

        public boolean iterate() {
            if (!this.timeBased) {
                --this.nextGate;
            }
            return this.stop();
        }
    }
}

