/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.jspecify.annotations.Nullable;
import org.openpdf.extend.ReplacedElement;
import org.openpdf.extend.ReplacedElementFactory;
import org.openpdf.extend.UserAgentCallback;
import org.openpdf.layout.LayoutContext;
import org.openpdf.render.BlockBox;
import org.openpdf.resource.ImageResource;
import org.openpdf.simple.extend.DefaultFormSubmissionListener;
import org.openpdf.simple.extend.FormSubmissionListener;
import org.openpdf.simple.extend.XhtmlForm;
import org.openpdf.simple.extend.form.FormField;
import org.openpdf.swing.AWTFSImage;
import org.openpdf.swing.DeferredImageReplacedElement;
import org.openpdf.swing.EmptyReplacedElement;
import org.openpdf.swing.ImageReplacedElement;
import org.openpdf.swing.ImageResourceLoader;
import org.openpdf.swing.RepaintListener;
import org.openpdf.swing.SwingReplacedElement;
import org.openpdf.util.ImageUtil;
import org.openpdf.util.XRLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SwingReplacedElementFactory
implements ReplacedElementFactory {
    private static final Logger log = LoggerFactory.getLogger(SwingReplacedElementFactory.class);
    private final Map<CacheKey, ReplacedElement> imageComponents = new HashMap<CacheKey, ReplacedElement>();
    private final Map<Element, XhtmlForm> forms = new LinkedHashMap<Element, XhtmlForm>();
    private FormSubmissionListener formSubmissionListener;
    protected final RepaintListener repaintListener;
    private final ImageResourceLoader imageResourceLoader;

    public SwingReplacedElementFactory() {
        this(ImageResourceLoader.NO_OP_REPAINT_LISTENER);
    }

    public SwingReplacedElementFactory(RepaintListener repaintListener) {
        this(repaintListener, new ImageResourceLoader());
    }

    public SwingReplacedElementFactory(RepaintListener listener, ImageResourceLoader irl) {
        this.repaintListener = listener;
        this.imageResourceLoader = irl;
        this.formSubmissionListener = new DefaultFormSubmissionListener();
    }

    @Override
    @CheckReturnValue
    public @Nullable ReplacedElement createReplacedElement(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        FormField formField;
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        if (context.getNamespaceHandler().isImageElement(e)) {
            return this.replaceImage(uac, context, e, cssWidth, cssHeight);
        }
        Element parentForm = this.getParentForm(e, context);
        XhtmlForm form = this.getForm(parentForm);
        if (form == null) {
            form = new XhtmlForm(uac, parentForm, this.formSubmissionListener);
            this.addForm(parentForm, form);
        }
        if ((formField = form.addComponent(e, context, box)) == null) {
            return null;
        }
        JComponent cc = formField.getComponent();
        if (cc == null) {
            return new EmptyReplacedElement(0, 0);
        }
        SwingReplacedElement result = new SwingReplacedElement(cc, formField.getIntrinsicSize());
        if (context.isInteractive()) {
            ((Container)((Object)context.getCanvas())).add(cc);
        }
        return result;
    }

    @CheckReturnValue
    protected @Nullable ReplacedElement replaceImage(UserAgentCallback uac, LayoutContext context, Element elem, int cssWidth, int cssHeight) {
        String imageSrc = context.getNamespaceHandler().getImageSourceURI(elem);
        if (imageSrc == null || imageSrc.isEmpty()) {
            XRLog.layout(Level.WARNING, "No source provided for img element.");
            return this.newIrreplaceableImageElement(cssWidth, cssHeight);
        }
        if (ImageUtil.isEmbeddedBase64Image(imageSrc)) {
            BufferedImage image = ImageUtil.loadEmbeddedBase64Image(imageSrc);
            return image == null ? null : new ImageReplacedElement(image, cssWidth, cssHeight);
        }
        String ruri = uac.resolveURI(imageSrc);
        ReplacedElement re = this.lookupImageReplacedElement(elem, ruri, cssWidth, cssHeight);
        if (re == null) {
            XRLog.load(Level.FINE, "Swing: Image " + ruri + " requested at  to " + cssWidth + ", " + cssHeight);
            ImageResource imageResource = this.imageResourceLoader.get(ruri, cssWidth, cssHeight);
            re = imageResource.isLoaded() ? new ImageReplacedElement(((AWTFSImage)imageResource.getImage()).getImage(), cssWidth, cssHeight) : new DeferredImageReplacedElement(imageResource, this.repaintListener, cssWidth, cssHeight);
            this.storeImageReplacedElement(elem, re, ruri, cssWidth, cssHeight);
        }
        return re;
    }

    @CheckReturnValue
    private @Nullable ReplacedElement lookupImageReplacedElement(Element elem, String ruri, int cssWidth, int cssHeight) {
        CacheKey key = new CacheKey(elem, ruri, cssWidth, cssHeight);
        return this.imageComponents.get(key);
    }

    @CheckReturnValue
    protected ReplacedElement newIrreplaceableImageElement(int cssWidth, int cssHeight) {
        try {
            BufferedImage missingImage = ImageUtil.createCompatibleBufferedImage(cssWidth, cssHeight, 1);
            ImageUtil.withGraphics(missingImage, g -> {
                g.setColor(Color.BLACK);
                g.setBackground(Color.WHITE);
                g.setFont(new Font("Serif", 0, 12));
                g.drawString("Missing", 0, 12);
            });
            return new ImageReplacedElement(missingImage, cssWidth, cssHeight);
        }
        catch (Exception e) {
            log.error("Failed to create image element of size {}x{}", new Object[]{cssWidth, cssHeight, e});
            return new EmptyReplacedElement(Math.max(cssWidth, 0), Math.max(cssHeight, 0));
        }
    }

    protected void storeImageReplacedElement(Element e, ReplacedElement cc, String uri, int cssWidth, int cssHeight) {
        CacheKey key = new CacheKey(e, uri, cssWidth, cssHeight);
        this.imageComponents.put(key, cc);
    }

    @CheckReturnValue
    protected @Nullable ReplacedElement lookupImageReplacedElement(Element e) {
        return this.lookupImageReplacedElement(e, "", -1, -1);
    }

    protected void addForm(Element e, XhtmlForm f) {
        this.forms.put(e, f);
    }

    @CheckReturnValue
    protected @Nullable XhtmlForm getForm(Element e) {
        return this.forms.get(e);
    }

    @CheckReturnValue
    protected @Nullable Element getParentForm(Element e, LayoutContext context) {
        Node node = e;
        while ((node = node.getParentNode()).getNodeType() == 1 && !context.getNamespaceHandler().isFormElement((Element)node)) {
        }
        if (node.getNodeType() != 1) {
            return null;
        }
        return (Element)node;
    }

    @Override
    public void reset() {
        this.forms.clear();
        this.imageComponents.clear();
    }

    @Override
    public void remove(Element e) {
        this.forms.remove(e);
        this.imageComponents.keySet().removeIf(ck -> ck.elem.equals(e));
    }

    @Override
    public void setFormSubmissionListener(FormSubmissionListener fsl) {
        this.formSubmissionListener = fsl;
    }

    private record CacheKey(Element elem, String uri, int width, int height) {
    }
}

