/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.resource;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.logging.Level;
import org.htmlunit.cyberneko.html.dom.HTMLDocumentImpl;
import org.htmlunit.cyberneko.parsers.DOMParser;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLInputSource;
import org.jspecify.annotations.Nullable;
import org.openpdf.resource.AbstractResource;
import org.openpdf.resource.HtmlParserConfig;
import org.openpdf.util.XRLog;
import org.openpdf.util.XRRuntimeException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlResource
extends AbstractResource {
    private final Document document;
    private final long elapsedLoadTime;

    private HtmlResource(@Nullable InputSource source, Document document, long elapsedLoadTime) {
        super(source);
        this.document = document;
        this.elapsedLoadTime = elapsedLoadTime;
    }

    public static HtmlResource load(URL source) {
        return HtmlResource.load(source, HtmlParserConfig.defaults());
    }

    public static HtmlResource load(URL source, HtmlParserConfig config) {
        HtmlResource htmlResource;
        block8: {
            InputStream stream = source.openStream();
            try {
                htmlResource = HtmlResource.load(stream, config, source.toExternalForm());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new XRRuntimeException("Failed to load HTML from URL: " + String.valueOf(source), e);
                }
            }
            stream.close();
        }
        return htmlResource;
    }

    public static HtmlResource load(InputStream stream) {
        return HtmlResource.load(stream, HtmlParserConfig.defaults(), null);
    }

    public static HtmlResource load(InputStream stream, HtmlParserConfig config, @Nullable String systemId) {
        long start = System.currentTimeMillis();
        try {
            XMLInputSource inputSource = new XMLInputSource(null, systemId, null, stream, config.getEncoding());
            Document doc = HtmlResource.parseWithDomParser(inputSource, config);
            long elapsed = System.currentTimeMillis() - start;
            XRLog.load("Loaded HTML document in " + elapsed + "ms using htmlunit-neko DOMParser");
            return new HtmlResource(null, doc, elapsed);
        }
        catch (Exception e) {
            throw new XRRuntimeException("Failed to parse HTML from stream", e);
        }
    }

    public static HtmlResource load(Reader reader) {
        return HtmlResource.load(reader, HtmlParserConfig.defaults());
    }

    public static HtmlResource load(Reader reader, HtmlParserConfig config) {
        long start = System.currentTimeMillis();
        try {
            XMLInputSource inputSource = new XMLInputSource(null, null, null, reader, config.getEncoding());
            Document doc = HtmlResource.parseWithDomParser(inputSource, config);
            long elapsed = System.currentTimeMillis() - start;
            XRLog.load("Loaded HTML document in " + elapsed + "ms using htmlunit-neko DOMParser");
            return new HtmlResource(null, doc, elapsed);
        }
        catch (Exception e) {
            throw new XRRuntimeException("Failed to parse HTML from reader", e);
        }
    }

    public static HtmlResource load(String html) {
        return HtmlResource.load(html, HtmlParserConfig.defaults());
    }

    public static HtmlResource load(String html, HtmlParserConfig config) {
        return HtmlResource.load(new StringReader(html), config);
    }

    private static Document parseWithDomParser(XMLInputSource inputSource, HtmlParserConfig config) throws SAXException, IOException {
        DOMParser parser = new DOMParser(HTMLDocumentImpl.class);
        HtmlResource.configureParser(parser, config);
        parser.parse(inputSource);
        return parser.getDocument();
    }

    private static void configureParser(DOMParser parser, HtmlParserConfig config) {
        try {
            if (config.isReportErrors()) {
                parser.setFeature("http://cyberneko.org/html/features/report-errors", true);
            }
            if (config.isAllowSelfClosingTags()) {
                parser.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-tags", true);
            }
            if (config.isAllowSelfClosingIframe()) {
                parser.setFeature("http://cyberneko.org/html/features/scanner/allow-selfclosing-iframe", true);
            }
            if (config.isParseNoScriptContent()) {
                parser.setFeature("http://cyberneko.org/html/features/parse-noscript-content", true);
            }
            if (config.isScriptStripCommentDelims()) {
                parser.setFeature("http://cyberneko.org/html/features/scanner/script/strip-comment-delims", true);
            }
            if (config.isStyleStripCommentDelims()) {
                parser.setFeature("http://cyberneko.org/html/features/scanner/style/strip-comment-delims", true);
            }
            if (config.getElementNameCase() != null) {
                parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)config.getElementNameCase());
            }
            if (config.getAttributeNameCase() != null) {
                parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)config.getAttributeNameCase());
            }
            if (config.getEncoding() != null) {
                parser.setProperty("http://cyberneko.org/html/properties/default-encoding", (Object)config.getEncoding());
            }
        }
        catch (SAXException e) {
            XRLog.load(Level.WARNING, "Could not configure htmlunit-neko DOMParser feature", e);
        }
    }

    public Document getDocument() {
        return this.document;
    }

    @CheckReturnValue
    public long getElapsedLoadTime() {
        return this.elapsedLoadTime;
    }
}

