/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.render;

import java.awt.RenderingHints;
import java.util.Objects;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.extend.FSImage;
import org.openpdf.render.BlockBox;
import org.openpdf.render.Box;
import org.openpdf.render.MarkerData;
import org.openpdf.render.RenderingContext;
import org.openpdf.render.StrutMetrics;

public class ListItemPainter {
    public static void paint(RenderingContext c, BlockBox box) {
        if (box.getMarkerData() == null) {
            return;
        }
        MarkerData markerData = box.getMarkerData();
        if (markerData.getImageMarker() != null) {
            ListItemPainter.drawImage(c, box, markerData);
        } else {
            CalculatedStyle style = box.getStyle();
            c.getOutputDevice().setColor(style.getColor());
            if (markerData.getGlyphMarker() != null) {
                ListItemPainter.drawGlyph(c, box, style);
            } else if (markerData.getTextMarker() != null) {
                ListItemPainter.drawText(c, box);
            }
        }
    }

    private static void drawImage(RenderingContext c, BlockBox box, MarkerData markerData) {
        MarkerData.ImageMarker marker = markerData.getImageMarker();
        FSImage img = marker.getImage();
        int x = ListItemPainter.getReferenceX(c, box);
        c.getOutputDevice().drawImage(img, x += -marker.getLayoutWidth() + (marker.getLayoutWidth() / 2 - img.getWidth() / 2), ListItemPainter.getListItemCenterBaseline(c, box) - img.getHeight() / 2);
    }

    private static int getReferenceX(RenderingContext c, BlockBox box) {
        MarkerData markerData = box.getMarkerData();
        if (markerData.getReferenceLine() != null) {
            return markerData.getReferenceLine().getAbsX();
        }
        return box.getAbsX() + (int)box.getMargin(c).left();
    }

    private static void drawGlyph(RenderingContext c, BlockBox box, CalculatedStyle style) {
        Object aa_key = c.getOutputDevice().getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        c.getOutputDevice().setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        MarkerData.GlyphMarker marker = box.getMarkerData().getGlyphMarker();
        int x = ListItemPainter.getReferenceX(c, box) - marker.getLayoutWidth();
        int y = ListItemPainter.getListItemCenterBaseline(c, box) - marker.getDiameter() / 2;
        IdentValue listStyle = style.getIdent(CSSName.LIST_STYLE_TYPE);
        if (listStyle == IdentValue.DISC) {
            c.getOutputDevice().fillOval(x, y, marker.getDiameter(), marker.getDiameter());
        } else if (listStyle == IdentValue.SQUARE) {
            c.getOutputDevice().fillRect(x, y, marker.getDiameter(), marker.getDiameter());
        } else if (listStyle == IdentValue.CIRCLE) {
            c.getOutputDevice().drawOval(x, y, marker.getDiameter(), marker.getDiameter());
        }
        c.getOutputDevice().setRenderingHint(RenderingHints.KEY_ANTIALIASING, Objects.requireNonNullElse(aa_key, RenderingHints.VALUE_ANTIALIAS_DEFAULT));
    }

    private static int getListItemCenterBaseline(RenderingContext c, BlockBox box) {
        return box.getAbsY() + ListItemPainter.getHeightOfFirstChild(box) / 2 + (int)box.getMargin(c).top() / 2 - (int)box.getMargin(c).bottom() / 2 + (int)box.getPadding(c).top() / 2 - (int)box.getPadding(c).bottom() / 2;
    }

    private static int getHeightOfFirstChild(Box box) {
        if (box.getChildCount() > 1) {
            return ListItemPainter.getHeightOfFirstChild(box.getChild(0));
        }
        return box.getHeight();
    }

    private static void drawText(RenderingContext c, BlockBox box) {
        MarkerData.TextMarker text = box.getMarkerData().getTextMarker();
        int x = ListItemPainter.getReferenceX(c, box) - text.getLayoutWidth();
        int y = ListItemPainter.getReferenceBaseline(box);
        c.getOutputDevice().setColor(box.getStyle().getColor());
        c.getOutputDevice().setFont(box.getStyle().getFSFont(c));
        c.getTextRenderer().drawString(c.getOutputDevice(), text.getText(), x, y);
    }

    private static int getReferenceBaseline(BlockBox box) {
        MarkerData markerData = box.getMarkerData();
        StrutMetrics strutMetrics = markerData.getStructMetrics();
        if (markerData.getReferenceLine() != null) {
            return markerData.getReferenceLine().getAbsY() + strutMetrics.getBaseline();
        }
        return box.getAbsY() + box.getTy() + strutMetrics.getBaseline();
    }
}

