/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.pdf;

import java.awt.Rectangle;
import org.openpdf.extend.FSGlyphVector;
import org.openpdf.extend.FontContext;
import org.openpdf.extend.OutputDevice;
import org.openpdf.extend.TextRenderer;
import org.openpdf.pdf.FontDescription;
import org.openpdf.pdf.ITextFSFont;
import org.openpdf.pdf.ITextFSFontMetrics;
import org.openpdf.pdf.ITextOutputDevice;
import org.openpdf.render.FSFont;
import org.openpdf.render.FSFontMetrics;
import org.openpdf.render.JustificationInfo;
import org.openpdf.text.pdf.BaseFont;

public class ITextTextRenderer
implements TextRenderer {
    private static final float TEXT_MEASURING_DELTA = 0.01f;

    @Override
    public void setup(FontContext context) {
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        ((ITextOutputDevice)outputDevice).drawString(string, x, y, null);
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string, float x, float y, JustificationInfo info) {
        ((ITextOutputDevice)outputDevice).drawString(string, x, y, info);
    }

    @Override
    public FSFontMetrics getFSFontMetrics(FontContext context, FSFont font, String string) {
        FontDescription description = ((ITextFSFont)font).getFontDescription();
        BaseFont bf = description.getFont();
        float size = font.getSize2D();
        float strikethroughThickness = description.getYStrikeoutSize() != 0.0f ? description.getYStrikeoutSize() / 1000.0f * size : size / 12.0f;
        return new ITextFSFontMetrics(bf.getFontDescriptor(8, size), -bf.getFontDescriptor(6, size), -description.getYStrikeoutPosition() / 1000.0f * size, strikethroughThickness, -description.getUnderlinePosition() / 1000.0f * size, description.getUnderlineThickness() / 1000.0f * size);
    }

    @Override
    public int getWidth(FontContext context, FSFont font, String string) {
        BaseFont bf = ((ITextFSFont)font).getFontDescription().getFont();
        float result = bf.getWidthPoint(string, font.getSize2D());
        if ((double)result - Math.floor(result) < (double)0.01f) {
            return (int)result;
        }
        return (int)Math.ceil(result);
    }

    @Override
    public void setFontScale(float scale) {
    }

    @Override
    public float getFontScale() {
        return 1.0f;
    }

    @Override
    public void setSmoothingThreshold(float fontsize) {
    }

    @Override
    public Rectangle getGlyphBounds(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector, int index, float x, float y) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphBounds");
    }

    @Override
    public float[] getGlyphPositions(OutputDevice outputDevice, FSFont font, FSGlyphVector fsGlyphVector) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphPositions");
    }

    @Override
    public FSGlyphVector getGlyphVector(OutputDevice outputDevice, FSFont font, String string) {
        throw new UnsupportedOperationException("Unsupported operation: getGlyphVector");
    }

    @Override
    public void drawGlyphVector(OutputDevice outputDevice, FSGlyphVector vector, float x, float y) {
        throw new UnsupportedOperationException("Unsupported operation: drawGlyphVector");
    }
}

