/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.pdf;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openpdf.pdf.ITextRenderer;
import org.openpdf.resource.FSEntityResolver;
import org.openpdf.text.DocumentException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Html2Pdf {
    public static byte[] fromClasspathResource(String fileName) {
        URL htmlUrl = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(fileName), () -> "Resource not found in classpath: " + fileName);
        return Html2Pdf.fromUrl(htmlUrl);
    }

    public static byte[] fromUrl(URL html) {
        ITextRenderer renderer = new ITextRenderer();
        renderer.getSharedContext().setMedia("pdf");
        renderer.getSharedContext().setInteractive(false);
        renderer.getSharedContext().getTextRenderer().setSmoothingThreshold(0.0f);
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setEntityResolver(FSEntityResolver.instance());
            Document doc = builder.parse(html.toString());
            return renderer.createPDF(doc);
        }
        catch (IOException | ParserConfigurationException | DocumentException | SAXException e) {
            throw new IllegalArgumentException("Failed to parse XML from " + String.valueOf(html), e);
        }
    }
}

