/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.html;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.openpdf.layout.SharedContext;
import org.openpdf.pdf.ITextRenderer;
import org.openpdf.text.utils.PdfBatch;
import org.w3c.dom.Document;

public final class HtmlToPdfBatchUtils {
    public static final String CSS_A4_20MM = "@page { size: A4; margin: 20mm; }";
    public static final String CSS_LETTER_HALF_IN = "@page { size: Letter; margin: 0.5in; }";

    private HtmlToPdfBatchUtils() {
    }

    public static Path renderHtmlString(String html, String baseUri, Path output, String injectCss, Consumer<ITextRenderer> rendererCustomizer) throws IOException {
        Objects.requireNonNull(html, "html");
        Objects.requireNonNull(output, "output");
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        String finalHtml = injectCss != null && !injectCss.isEmpty() ? (String)HtmlToPdfBatchUtils.injectCssBlock(injectCss).apply(html) : html;
        try (FileOutputStream out = new FileOutputStream(output.toFile());){
            ITextRenderer renderer = new ITextRenderer();
            SharedContext sc = renderer.getSharedContext();
            sc.setUserAgentCallback(renderer.getOutputDevice().getSharedContext().getUserAgentCallback());
            if (rendererCustomizer != null) {
                rendererCustomizer.accept(renderer);
            }
            if (baseUri != null && !baseUri.isBlank()) {
                renderer.setDocumentFromString(finalHtml, baseUri);
            } else {
                renderer.setDocumentFromString(finalHtml);
            }
            renderer.layout();
            renderer.createPDF(out, true);
        }
        return output;
    }

    public static Path renderHtmlFile(Path htmlFile, Path baseDir, Path output, String injectCss, Consumer<ITextRenderer> rendererCustomizer) throws IOException {
        Objects.requireNonNull(htmlFile, "htmlFile");
        Objects.requireNonNull(output, "output");
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        String html = Files.readString(htmlFile, StandardCharsets.UTF_8);
        String base = baseDir != null ? baseDir.toUri().toString() : htmlFile.getParent().toUri().toString();
        return HtmlToPdfBatchUtils.renderHtmlString(html, base, output, injectCss, rendererCustomizer);
    }

    public static Path renderUrl(String url, Path output, String injectCss, Consumer<ITextRenderer> rendererCustomizer) throws IOException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(output, "output");
        Files.createDirectories(output.getParent(), new FileAttribute[0]);
        try (FileOutputStream out = new FileOutputStream(output.toFile());){
            ITextRenderer renderer = new ITextRenderer();
            if (rendererCustomizer != null) {
                rendererCustomizer.accept(renderer);
            }
            if (injectCss == null || injectCss.isEmpty()) {
                Document doc = renderer.getSharedContext().getUac().getXMLResource(url).getDocument();
                renderer.setDocument(doc, url);
            } else {
                String html;
                try (InputStream in = URI.create(url).toURL().openStream();){
                    html = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                }
                String finalHtml = (String)HtmlToPdfBatchUtils.injectCssBlock(injectCss).apply(html);
                renderer.setDocumentFromString(finalHtml, url);
            }
            renderer.layout();
            renderer.createPDF(out, true);
        }
        return output;
    }

    public static PdfBatch.BatchResult<Path> batchHtmlStrings(List<HtmlStringJob> jobs, Consumer<Path> onSuccess, Consumer<Throwable> onFailure) {
        return PdfBatch.run(jobs.stream().map(j -> () -> HtmlToPdfBatchUtils.renderHtmlString(j.html, j.baseUri, j.output, j.injectCss.orElse(null), j.rendererCustomizer.orElse(null))).toList(), onSuccess, onFailure);
    }

    public static PdfBatch.BatchResult<Path> batchHtmlFiles(List<HtmlFileJob> jobs, Consumer<Path> onSuccess, Consumer<Throwable> onFailure) {
        return PdfBatch.run(jobs.stream().map(j -> () -> HtmlToPdfBatchUtils.renderHtmlFile(j.htmlFile, j.baseDir, j.output, j.injectCss.orElse(null), j.rendererCustomizer.orElse(null))).toList(), onSuccess, onFailure);
    }

    public static PdfBatch.BatchResult<Path> batchUrls(List<UrlJob> jobs, Consumer<Path> onSuccess, Consumer<Throwable> onFailure) {
        return PdfBatch.run(jobs.stream().map(j -> () -> HtmlToPdfBatchUtils.renderUrl(j.url, j.output, j.injectCss.orElse(null), j.rendererCustomizer.orElse(null))).toList(), onSuccess, onFailure);
    }

    public static UnaryOperator<String> injectCssBlock(String css) {
        return html -> {
            String style = "<style>" + css + "</style>";
            String lower = html.toLowerCase();
            int headIdx = lower.indexOf("<head>");
            if (headIdx >= 0) {
                int insertPos = headIdx + "<head>".length();
                return html.substring(0, insertPos) + style + html.substring(insertPos);
            }
            return "<html><head>" + style + "</head><body>" + html + "</body></html>";
        };
    }

    public static Consumer<ITextRenderer> setDpi(int dpi) {
        return renderer -> renderer.getSharedContext().setDPI(dpi);
    }

    public static Consumer<ITextRenderer> registerFontDir(Path dir) {
        return renderer -> {
            try {
                renderer.getFontResolver().addFontDirectory(dir.toString(), true);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to register fonts from: " + String.valueOf(dir), e);
            }
        };
    }

    public record UrlJob(String url, Path output, Optional<String> injectCss, Optional<Consumer<ITextRenderer>> rendererCustomizer) {
    }

    public record HtmlFileJob(Path htmlFile, Path baseDir, Path output, Optional<String> injectCss, Optional<Consumer<ITextRenderer>> rendererCustomizer) {
    }

    public record HtmlStringJob(String html, String baseUri, Path output, Optional<String> injectCss, Optional<Consumer<ITextRenderer>> rendererCustomizer) {
    }
}

