/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.constants;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.jspecify.annotations.Nullable;
import org.openpdf.util.GeneralUtil;
import org.openpdf.util.XRLog;
import org.openpdf.util.XRRuntimeException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public final class ValueConstants {
    private static final List<String> TYPE_DESCRIPTIONS = new ArrayList<String>();
    private static final Map<Short, String> sacTypesStrings = new HashMap<Short, String>(25);

    public static String cssType(int cssType, int primitiveValueType) {
        if (cssType == 1) {
            if (primitiveValueType >= TYPE_DESCRIPTIONS.size()) {
                return "{unknown: " + primitiveValueType + "}";
            }
            String desc = TYPE_DESCRIPTIONS.get(primitiveValueType);
            return desc == null ? "{UNKNOWN VALUE TYPE}" : desc;
        }
        return "{value list}";
    }

    public static short sacPrimitiveTypeForString(@Nullable String type) {
        if ("deg".equals(type)) {
            return 11;
        }
        if ("rad".equals(type)) {
            return 12;
        }
        if (type == null) {
            return 5;
        }
        return switch (type) {
            case "em" -> 3;
            case "ex" -> 4;
            case "px" -> 5;
            case "%" -> 2;
            case "in" -> 8;
            case "cm" -> 6;
            case "mm" -> 7;
            case "pt" -> 9;
            case "pc" -> 10;
            default -> throw new XRRuntimeException("Unknown type on CSS value: " + type);
        };
    }

    public static String stringForSACPrimitiveType(short type) {
        return sacTypesStrings.get(type);
    }

    public static boolean isAbsoluteUnit(CSSPrimitiveValue primitive) {
        short type = primitive.getPrimitiveType();
        return ValueConstants.isAbsoluteUnit(type);
    }

    public static boolean isAbsoluteUnit(short type) {
        switch (type) {
            case 2: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
            case 0: {
                XRLog.cascade(Level.WARNING, "Asked whether type was absolute, given CSS_UNKNOWN as the type. Might be one of those funny values like background-position.");
                GeneralUtil.dumpShortException(new Exception("Taking a thread dump..."));
            }
        }
        return false;
    }

    public static String getCssValueTypeDesc(CSSValue cssValue) {
        return switch (cssValue.getCssValueType()) {
            case 3 -> "CSS_CUSTOM";
            case 0 -> "CSS_INHERIT";
            case 1 -> "CSS_PRIMITIVE_VALUE";
            case 2 -> "CSS_VALUE_LIST";
            default -> "UNKNOWN";
        };
    }

    public static boolean isNumber(short cssPrimitiveType) {
        return switch (cssPrimitiveType) {
            case 2, 3, 4 -> false;
            case 5, 6, 7, 8, 9, 10 -> true;
            default -> false;
        };
    }

    public static short guessType(@Nullable String value) {
        if (value != null && value.length() > 1) {
            if (value.endsWith("%")) {
                return 2;
            }
            if (value.startsWith("rgb") || value.startsWith("#")) {
                return 25;
            }
            String hmm = value.substring(value.length() - 2);
            return ValueConstants.guessTypeByFont(value, hmm);
        }
        return 19;
    }

    private static short guessTypeByFont(String value, String hmm) {
        switch (hmm) {
            case "pt": {
                return 9;
            }
            case "px": {
                return 5;
            }
            case "em": {
                return 3;
            }
            case "ex": {
                return 4;
            }
            case "in": {
                return 8;
            }
            case "cm": {
                return 6;
            }
            case "mm": {
                return 7;
            }
        }
        if (Character.isDigit(value.charAt(value.length() - 1))) {
            try {
                Float.parseFloat(value);
                return 1;
            }
            catch (NumberFormatException ex) {
                return 19;
            }
        }
        return 19;
    }

    static {
        TreeMap<Short, String> map = new TreeMap<Short, String>();
        try {
            Field[] fields;
            for (Field f : fields = CSSPrimitiveValue.class.getFields()) {
                int mod = f.getModifiers();
                if (!Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !Modifier.isPublic(mod)) continue;
                Short val = (Short)f.get(null);
                String name = f.getName();
                if (!name.startsWith("CSS_") || name.equals("CSS_INHERIT") || name.equals("CSS_PRIMITIVE_VALUE") || name.equals("CSS_VALUE_LIST") || name.equals("CSS_CUSTOM")) continue;
                map.put(val, name.substring("CSS_".length()));
            }
            ArrayList keys = new ArrayList(map.keySet());
            Collections.sort(keys);
            for (Short key : keys) {
                TYPE_DESCRIPTIONS.add((String)map.get(key));
            }
        }
        catch (Exception ex) {
            throw new XRRuntimeException("Could not build static list of CSS type descriptions.", ex);
        }
        sacTypesStrings.put((short)3, "em");
        sacTypesStrings.put((short)4, "ex");
        sacTypesStrings.put((short)5, "px");
        sacTypesStrings.put((short)2, "%");
        sacTypesStrings.put((short)8, "in");
        sacTypesStrings.put((short)6, "cm");
        sacTypesStrings.put((short)7, "mm");
        sacTypesStrings.put((short)9, "pt");
        sacTypesStrings.put((short)10, "pc");
    }
}

