/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.util;

import com.google.errorprone.annotations.CheckReturnValue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;
import org.openpdf.util.Configuration;
import org.openpdf.util.LoggerUtil;
import org.openpdf.util.XRLog;
import org.openpdf.util.XRLogger;
import org.openpdf.util.XRRuntimeException;

public class JDKXRLogger
implements XRLogger {
    @Override
    public void log(String where, Level level, String msg) {
        JDKXRLogger.getLogger(where).log(level, msg);
    }

    @Override
    public void log(String where, Level level, String msg, @Nullable Throwable th) {
        JDKXRLogger.getLogger(where).log(level, msg, th);
    }

    @Override
    public void setLevel(String logger, Level level) {
        JDKXRLogger.getLogger(logger).setLevel(level);
    }

    @CheckReturnValue
    private static Logger getLogger(String log) {
        return Logger.getLogger(log);
    }

    public JDKXRLogger() {
        Properties props = JDKXRLogger.retrieveLoggingProperties();
        if (!XRLog.isLoggingEnabled()) {
            Configuration.setConfigLogger(Logger.getLogger(XRLog.CONFIG));
            return;
        }
        JDKXRLogger.initializeJDKLogManager(props);
        Configuration.setConfigLogger(Logger.getLogger(XRLog.CONFIG));
    }

    @CheckReturnValue
    private static Properties retrieveLoggingProperties() {
        String prefix = "xr.util-logging.";
        Properties props = new Properties();
        Iterator<String> iter = Configuration.keysByPrefix(prefix);
        while (iter.hasNext()) {
            String fullKey = iter.next();
            String key = fullKey.substring(prefix.length());
            String value = Configuration.valueFor(fullKey);
            props.setProperty(key, value);
        }
        return props;
    }

    private static void initializeJDKLogManager(Properties fsLoggingProperties) {
        List<Logger> loggers = JDKXRLogger.retrieveLoggers();
        JDKXRLogger.configureLoggerHandlerForwarding(fsLoggingProperties, loggers);
        Map<String, Handler> handlers = new HashMap<String, Handler>();
        HashMap<String, String> handlerFormatterMap = new HashMap<String, String>();
        for (Object object : fsLoggingProperties.keySet()) {
            String key = (String)object;
            String prop = fsLoggingProperties.getProperty(key);
            if (key.endsWith("level")) {
                JDKXRLogger.configureLogLevel(key.substring(0, key.lastIndexOf(46)), prop);
                continue;
            }
            if (key.endsWith("handlers")) {
                handlers = JDKXRLogger.configureLogHandlers(loggers, prop);
                continue;
            }
            if (!key.endsWith("formatter")) continue;
            String k2 = key.substring(0, key.length() - ".formatter".length());
            handlerFormatterMap.put(k2, prop);
        }
        for (Map.Entry entry : handlerFormatterMap.entrySet()) {
            String formatterClassName = (String)entry.getValue();
            JDKXRLogger.assignFormatter(handlers, (String)entry.getKey(), formatterClassName);
        }
    }

    private static void configureLoggerHandlerForwarding(Properties fsLoggingProperties, List<Logger> loggers) {
        String val = fsLoggingProperties.getProperty("use-parent-handler");
        boolean flag = Boolean.parseBoolean(val);
        for (Logger logger : loggers) {
            logger.setUseParentHandlers(flag);
        }
    }

    private static void assignFormatter(Map<String, Handler> handlers, String handlerClassName, String formatterClassName) {
        Handler handler = handlers.get(handlerClassName);
        if (handler != null) {
            try {
                Class<?> fclass = Class.forName(formatterClassName);
                Formatter formatter = (Formatter)fclass.getConstructor(new Class[0]).newInstance(new Object[0]);
                handler.setFormatter(formatter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Can't instantiate Formatter class " + formatterClassName + ": " + e.getClass().getSimpleName(), e);
            }
        }
    }

    @CheckReturnValue
    private static List<Logger> retrieveLoggers() {
        List<String> loggerNames = XRLog.listRegisteredLoggers();
        ArrayList<Logger> loggers = new ArrayList<Logger>(loggerNames.size());
        for (String loggerName : loggerNames) {
            loggers.add(Logger.getLogger(loggerName));
        }
        return loggers;
    }

    @CheckReturnValue
    private static Map<String, Handler> configureLogHandlers(List<Logger> loggers, String handlerClassList) {
        String[] names = handlerClassList.split(" ");
        HashMap<String, Handler> handlers = new HashMap<String, Handler>(names.length);
        for (String name : names) {
            try {
                Class<?> handlerClass = Class.forName(name);
                Handler handler = (Handler)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                handlers.put(name, handler);
                String hl = Configuration.valueFor("xr.util-logging." + name + ".level", "INFO");
                handler.setLevel(LoggerUtil.parseLogLevel(hl, Level.INFO));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new XRRuntimeException("Could not initialize logging properties; Can't instantiate Handler class " + name + ": " + e.getClass().getSimpleName(), e);
            }
        }
        for (Logger logger : loggers) {
            for (Handler handler : handlers.values()) {
                logger.addHandler(handler);
            }
        }
        return handlers;
    }

    private static void configureLogLevel(String loggerName, String levelValue) {
        Level level = LoggerUtil.parseLogLevel(levelValue, Level.OFF);
        Logger logger = Logger.getLogger(loggerName);
        logger.setLevel(level);
    }
}

