/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.openpdf.event.DocumentListener;
import org.openpdf.extend.UserAgentCallback;
import org.openpdf.resource.CSSResource;
import org.openpdf.resource.ImageResource;
import org.openpdf.resource.XMLResource;
import org.openpdf.swing.ImageResourceLoader;
import org.openpdf.swing.RepaintListener;
import org.openpdf.swing.UriResolver;
import org.openpdf.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingUserAgent
implements UserAgentCallback,
DocumentListener {
    private static final Logger log = LoggerFactory.getLogger(DelegatingUserAgent.class);
    private final UriResolver _uriResolver = new UriResolver();
    private ImageResourceLoader _imageResourceLoader;

    public DelegatingUserAgent() {
        this(new ImageResourceLoader());
    }

    public DelegatingUserAgent(ImageResourceLoader imageResourceLoader) {
        this._imageResourceLoader = imageResourceLoader;
    }

    @Deprecated
    public void setImageResourceLoader(ImageResourceLoader loader) {
        this._imageResourceLoader = loader;
    }

    public void shrinkImageCache() {
        this._imageResourceLoader.shrink();
    }

    public void clearImageCache() {
        this._imageResourceLoader.clear();
    }

    @CheckReturnValue
    protected @Nullable InputStream resolveAndOpenStream(String uri) {
        return IOUtil.openStreamAtUrl(this._uriResolver.resolve(uri));
    }

    @Override
    @CheckReturnValue
    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.resolveAndOpenStream(uri));
    }

    @Override
    @CheckReturnValue
    public ImageResource getImageResource(String uri) {
        return this._imageResourceLoader.get(this.resolveURI(uri));
    }

    @Override
    @CheckReturnValue
    public @Nullable XMLResource getXMLResource(String uri) {
        XMLResource xMLResource;
        block8: {
            String resolvedUri = this._uriResolver.resolve(uri);
            InputStream in = IOUtil.getInputStream(resolvedUri);
            try {
                xMLResource = XMLResource.load(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Failed to load XML resource from {}", (Object)resolvedUri, (Object)e);
                    return null;
                }
            }
            in.close();
        }
        return xMLResource;
    }

    @Override
    @CheckReturnValue
    public byte @Nullable [] getBinaryResource(String uri) {
        String resolvedUri = this._uriResolver.resolve(uri);
        return IOUtil.readBytes(resolvedUri);
    }

    @Override
    public boolean isVisited(@Nullable String uri) {
        return false;
    }

    @Override
    public void setBaseURL(@Nullable String uri) {
        this._uriResolver.setBaseUri(uri);
    }

    @Override
    @CheckReturnValue
    public @Nullable String resolveURI(@Nullable String uri) {
        return this._uriResolver.resolve(uri);
    }

    @Override
    @CheckReturnValue
    public @Nullable String getBaseURL() {
        return this._uriResolver.getBaseUri();
    }

    @Override
    public void documentStarted() {
        this._imageResourceLoader.stopLoading();
        this.shrinkImageCache();
    }

    @Override
    public void documentLoaded() {
    }

    @Override
    public void onLayoutException(Throwable t) {
    }

    @Override
    public void onRenderException(Throwable t) {
    }

    public void setRepaintListener(RepaintListener listener) {
    }
}

