/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Locale;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.style.CalculatedStyle;
import org.openpdf.util.Uu;

public class TextUtil {
    public static String transformText(String text, CalculatedStyle style) {
        IdentValue transform = style.getIdent(CSSName.TEXT_TRANSFORM);
        IdentValue fontVariant = style.getIdent(CSSName.FONT_VARIANT);
        return TextUtil.transformText(text, transform, fontVariant);
    }

    static String transformText(String text, IdentValue transform, IdentValue fontVariant) {
        if (transform == IdentValue.LOWERCASE) {
            text = text.toLowerCase(Locale.ROOT);
        }
        if (transform == IdentValue.UPPERCASE) {
            text = text.toUpperCase(Locale.ROOT);
        }
        if (transform == IdentValue.CAPITALIZE) {
            text = TextUtil.capitalizeWords(text);
        }
        if (fontVariant == IdentValue.SMALL_CAPS) {
            text = text.toUpperCase(Locale.ROOT);
        }
        return text;
    }

    public static String transformFirstLetterText(String text, CalculatedStyle style) {
        if (!text.isEmpty()) {
            IdentValue transform = style.getIdent(CSSName.TEXT_TRANSFORM);
            IdentValue fontVariant = style.getIdent(CSSName.FONT_VARIANT);
            int end = text.length();
            for (int i = 0; i < end; ++i) {
                char currentChar = text.charAt(i);
                if (TextUtil.isFirstLetterSeparatorChar(currentChar)) continue;
                if (transform == IdentValue.LOWERCASE) {
                    currentChar = Character.toLowerCase(currentChar);
                    text = TextUtil.replaceChar(text, currentChar, i);
                    break;
                }
                if (transform != IdentValue.UPPERCASE && transform != IdentValue.CAPITALIZE && fontVariant != IdentValue.SMALL_CAPS) break;
                currentChar = Character.toUpperCase(currentChar);
                text = TextUtil.replaceChar(text, currentChar, i);
                break;
            }
        }
        return text;
    }

    public static String replaceChar(String text, char newChar, int index) {
        int textLength = text.length();
        StringBuilder b = new StringBuilder(textLength);
        for (int i = 0; i < textLength; ++i) {
            if (i == index) {
                b.append(newChar);
                continue;
            }
            b.append(text.charAt(i));
        }
        return b.toString();
    }

    public static boolean isFirstLetterSeparatorChar(char c) {
        return switch (Character.getType(c)) {
            case 12, 21, 22, 24, 29, 30 -> true;
            default -> false;
        };
    }

    private static String capitalizeWords(String text) {
        if (text.isEmpty()) {
            return text;
        }
        String result = TextUtil.doCapitalizeWords(text);
        if (result.length() != text.length()) {
            Uu.p("error! to strings arent the same length = -" + result + "-" + text + "-");
        }
        return result;
    }

    @CheckReturnValue
    private static String doCapitalizeWords(String text) {
        StringBuilder sb = new StringBuilder();
        boolean cap = true;
        for (int i = 0; i < text.length(); ++i) {
            String ch = text.substring(i, i + 1);
            if (cap) {
                sb.append(ch.toUpperCase(Locale.ROOT));
            } else {
                sb.append(ch);
            }
            cap = ch.equals(" ");
        }
        return sb.toString();
    }
}

