/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.layout;

import java.util.LinkedList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openpdf.extend.OutputDevice;
import org.openpdf.layout.BoxRangeData;
import org.openpdf.render.RenderingContext;
import org.openpdf.util.XRRuntimeException;

public class BoxRangeHelper {
    private final LinkedList<BoxRangeData> _clipRegionStack = new LinkedList();
    private final OutputDevice _outputDevice;
    private final List<BoxRangeData> _rangeList;
    private int _rangeIndex;
    private @Nullable BoxRangeData _current;

    public BoxRangeHelper(OutputDevice outputDevice, List<BoxRangeData> rangeList) {
        this._outputDevice = outputDevice;
        this._rangeList = rangeList;
        if (!rangeList.isEmpty()) {
            this._current = rangeList.get(0);
        }
    }

    public void checkFinished() {
        if (!this._clipRegionStack.isEmpty()) {
            throw new XRRuntimeException("internal error");
        }
    }

    public void pushClipRegion(RenderingContext c, int contentIndex) {
        while (this._current != null && this._current.getRange().getStart() == contentIndex) {
            this._current.setClip(this._outputDevice.getClip());
            this._clipRegionStack.add(this._current);
            this._outputDevice.clip(this._current.getBox().getChildrenClipEdge(c));
            if (this._rangeIndex == this._rangeList.size() - 1) {
                this._current = null;
                continue;
            }
            this._current = this._rangeList.get(++this._rangeIndex);
        }
    }

    public void popClipRegions(int contentIndex) {
        BoxRangeData data;
        while (!this._clipRegionStack.isEmpty() && (data = this._clipRegionStack.getLast()).getRange().getEnd() == contentIndex) {
            this._outputDevice.setClip(data.getClip());
            this._clipRegionStack.removeLast();
        }
    }
}

