/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.parser;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.IdentValue;
import org.openpdf.css.parser.FSColor;
import org.openpdf.css.parser.FSFunction;
import org.openpdf.css.parser.Token;
import org.openpdf.util.ArrayUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class PropertyValue
implements CSSPrimitiveValue {
    private final short _type;
    private final short _cssValueType;
    private final @Nullable String _stringValue;
    private float _floatValue;
    private final String @Nullable [] _stringArrayValue;
    private final String _cssText;
    private final @Nullable FSColor _FSColor;
    private @Nullable IdentValue _identValue;
    private final Type _propertyValueType;
    private final @Nullable Token _operator;
    private final List<?> _values;
    private final @Nullable FSFunction _function;

    public PropertyValue(short type, float floatValue, String cssText) {
        this(type, floatValue, cssText, null);
    }

    public PropertyValue(short type, float floatValue, String cssText, @Nullable Token operatorToken) {
        this._type = type;
        this._floatValue = floatValue;
        this._cssValueType = 1;
        this._cssText = cssText;
        this._propertyValueType = type == 1 && floatValue != 0.0f ? Type.VALUE_TYPE_NUMBER : Type.VALUE_TYPE_LENGTH;
        this._stringValue = null;
        this._stringArrayValue = null;
        this._values = Collections.emptyList();
        this._function = null;
        this._FSColor = null;
        this._operator = operatorToken;
    }

    public PropertyValue(FSColor color) {
        this(color, null);
    }

    public PropertyValue(FSColor color, @Nullable Token operatorToken) {
        this._type = (short)25;
        this._cssValueType = 1;
        this._cssText = color.toString();
        this._FSColor = color;
        this._propertyValueType = Type.VALUE_TYPE_COLOR;
        this._stringValue = null;
        this._stringArrayValue = null;
        this._values = Collections.emptyList();
        this._function = null;
        this._operator = operatorToken;
    }

    public PropertyValue(short type, String stringValue, String cssText) {
        this(type, stringValue, cssText, null);
    }

    public PropertyValue(short type, String stringValue, String cssText, @Nullable Token operatorToken) {
        this(type, stringValue, cssText, null, operatorToken);
    }

    public PropertyValue(short type, String stringValue, String cssText, String @Nullable [] stringArrayValue, @Nullable Token operatorToken) {
        this._type = type;
        this._stringValue = stringValue;
        this._cssValueType = this._stringValue.equalsIgnoreCase("inherit") ? (short)0 : 1;
        this._cssText = cssText;
        this._propertyValueType = type == 21 ? Type.VALUE_TYPE_IDENT : Type.VALUE_TYPE_STRING;
        this._stringArrayValue = ArrayUtil.cloneOrEmpty(stringArrayValue);
        this._values = Collections.emptyList();
        this._function = null;
        this._FSColor = null;
        this._operator = operatorToken;
    }

    public PropertyValue(IdentValue ident) {
        this._type = (short)21;
        this._stringValue = ident.toString();
        this._cssValueType = this._stringValue.equals("inherit") ? (short)0 : 1;
        this._cssText = ident.toString();
        this._propertyValueType = Type.VALUE_TYPE_IDENT;
        this._identValue = ident;
        this._stringArrayValue = null;
        this._values = Collections.emptyList();
        this._function = null;
        this._FSColor = null;
        this._operator = null;
    }

    public PropertyValue(List<?> values) {
        this._type = 0;
        this._cssValueType = (short)3;
        this._cssText = values.toString();
        this._values = values;
        this._propertyValueType = Type.VALUE_TYPE_LIST;
        this._stringValue = null;
        this._stringArrayValue = null;
        this._function = null;
        this._FSColor = null;
        this._operator = null;
    }

    public PropertyValue(FSFunction function) {
        this(function, null);
    }

    public PropertyValue(FSFunction function, @Nullable Token operatorToken) {
        this._type = 0;
        this._cssValueType = (short)3;
        this._cssText = function.toString();
        this._function = function;
        this._propertyValueType = Type.VALUE_TYPE_FUNCTION;
        this._values = Collections.emptyList();
        this._stringValue = null;
        this._stringArrayValue = null;
        this._FSColor = null;
        this._operator = operatorToken;
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        throw new UnsupportedOperationException("Unsupported operation: getCounterValue");
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        return this._floatValue;
    }

    public float getFloatValue() {
        return this._floatValue;
    }

    @Override
    public short getPrimitiveType() {
        return this._type;
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        throw new UnsupportedOperationException("Unsupported operation: getRGBColorValue");
    }

    @Override
    public Rect getRectValue() throws DOMException {
        throw new UnsupportedOperationException("Unsupported operation: getRectValue");
    }

    @Override
    public @Nullable String getStringValue() throws DOMException {
        return this._stringValue;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        throw new UnsupportedOperationException("Unsupported operation: setFloatValue");
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        throw new UnsupportedOperationException("Unsupported operation: setStringValue");
    }

    @Override
    public String getCssText() {
        return this._cssText;
    }

    @Override
    public short getCssValueType() {
        return this._cssValueType;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException("Unsupported operation: setCssText");
    }

    public @Nullable FSColor getFSColor() {
        return this._FSColor;
    }

    public @Nullable IdentValue getIdentValue() {
        return this._identValue;
    }

    public void setIdentValue(IdentValue identValue) {
        this._identValue = identValue;
    }

    public Type getPropertyValueType() {
        return this._propertyValueType;
    }

    public @Nullable Token getOperator() {
        return this._operator;
    }

    public String[] getStringArrayValue() {
        return ArrayUtil.cloneOrEmpty(this._stringArrayValue);
    }

    public String toString() {
        return this._cssText;
    }

    public <T> List<T> getValues() {
        return Collections.unmodifiableList(this._values);
    }

    public @Nullable FSFunction getFunction() {
        return this._function;
    }

    @CheckReturnValue
    public String getFingerprint() {
        return switch (this.getPropertyValueType().ordinal()) {
            case 3 -> {
                if (this._identValue == null) {
                    this._identValue = IdentValue.getByIdentString(this.getStringValue());
                }
                yield "I" + this._identValue.FS_ID;
            }
            default -> this.getCssText();
        };
    }

    public static enum Type {
        VALUE_TYPE_NUMBER,
        VALUE_TYPE_LENGTH,
        VALUE_TYPE_COLOR,
        VALUE_TYPE_IDENT,
        VALUE_TYPE_STRING,
        VALUE_TYPE_LIST,
        VALUE_TYPE_FUNCTION;

    }
}

