/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.css.constants;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.constants.CSSName;
import org.openpdf.css.parser.FSColor;
import org.openpdf.css.style.CssContext;
import org.openpdf.css.style.FSDerivedValue;
import org.openpdf.util.XRRuntimeException;

public class IdentValue
implements FSDerivedValue {
    private static final Map<String, IdentValue> ALL_IDENT_VALUES = new ConcurrentHashMap<String, IdentValue>();
    private static int maxAssigned;
    private final String ident;
    public final int FS_ID;
    public static final IdentValue ABSOLUTE;
    public static final IdentValue ALWAYS;
    public static final IdentValue ARMENIAN;
    public static final IdentValue AUTO;
    public static final IdentValue AVOID;
    public static final IdentValue BASELINE;
    public static final IdentValue BLINK;
    public static final IdentValue BLOCK;
    public static final IdentValue BOLD;
    public static final IdentValue BOLDER;
    public static final IdentValue BORDER_BOX;
    public static final IdentValue BOTH;
    public static final IdentValue BOTTOM;
    public static final IdentValue BREAK_ALL;
    public static final IdentValue CAPITALIZE;
    public static final IdentValue CENTER;
    public static final IdentValue CIRCLE;
    public static final IdentValue CJK_IDEOGRAPHIC;
    public static final IdentValue CLOSE_QUOTE;
    public static final IdentValue COLLAPSE;
    public static final IdentValue COMPACT;
    public static final IdentValue CONTAIN;
    public static final IdentValue CONTENT_BOX;
    public static final IdentValue COVER;
    public static final IdentValue CREATE;
    public static final IdentValue DASHED;
    public static final IdentValue DECIMAL;
    public static final IdentValue DECIMAL_LEADING_ZERO;
    public static final IdentValue DISC;
    public static final IdentValue DOTTED;
    public static final IdentValue DOUBLE;
    public static final IdentValue DYNAMIC;
    public static final IdentValue FIXED;
    public static final IdentValue FONT_WEIGHT_100;
    public static final IdentValue FONT_WEIGHT_200;
    public static final IdentValue FONT_WEIGHT_300;
    public static final IdentValue FONT_WEIGHT_400;
    public static final IdentValue FONT_WEIGHT_500;
    public static final IdentValue FONT_WEIGHT_600;
    public static final IdentValue FONT_WEIGHT_700;
    public static final IdentValue FONT_WEIGHT_800;
    public static final IdentValue FONT_WEIGHT_900;
    public static final IdentValue FS_CONTENT_PLACEHOLDER;
    public static final IdentValue FS_INITIAL_VALUE;
    public static final IdentValue GEORGIAN;
    public static final IdentValue GROOVE;
    public static final IdentValue HEBREW;
    public static final IdentValue HIDDEN;
    public static final IdentValue HIDE;
    public static final IdentValue HIRAGANA;
    public static final IdentValue HIRAGANA_IROHA;
    public static final IdentValue INHERIT;
    public static final IdentValue INLINE;
    public static final IdentValue INLINE_BLOCK;
    public static final IdentValue INLINE_TABLE;
    public static final IdentValue INSET;
    public static final IdentValue INSIDE;
    public static final IdentValue ITALIC;
    public static final IdentValue JUSTIFY;
    public static final IdentValue KATAKANA;
    public static final IdentValue KATAKANA_IROHA;
    public static final IdentValue KEEP;
    public static final IdentValue LANDSCAPE;
    public static final IdentValue LEFT;
    public static final IdentValue LIGHTER;
    public static final IdentValue LINE;
    public static final IdentValue LINEAR_GRADIENT;
    public static final IdentValue LINE_THROUGH;
    public static final IdentValue LIST_ITEM;
    public static final IdentValue LOWER_ALPHA;
    public static final IdentValue LOWER_GREEK;
    public static final IdentValue LOWER_LATIN;
    public static final IdentValue LOWER_ROMAN;
    public static final IdentValue LOWERCASE;
    public static final IdentValue LTR;
    public static final IdentValue MARKER;
    public static final IdentValue MIDDLE;
    public static final IdentValue NO_CLOSE_QUOTE;
    public static final IdentValue NO_OPEN_QUOTE;
    public static final IdentValue NO_REPEAT;
    public static final IdentValue NONE;
    public static final IdentValue NORMAL;
    public static final IdentValue NOWRAP;
    public static final IdentValue BREAK_WORD;
    public static final IdentValue OBLIQUE;
    public static final IdentValue OPEN_QUOTE;
    public static final IdentValue OUTSET;
    public static final IdentValue OUTSIDE;
    public static final IdentValue OVERLINE;
    public static final IdentValue PAGINATE;
    public static final IdentValue POINTER;
    public static final IdentValue PORTRAIT;
    public static final IdentValue PRE;
    public static final IdentValue PRE_LINE;
    public static final IdentValue PRE_WRAP;
    public static final IdentValue RELATIVE;
    public static final IdentValue REPEAT;
    public static final IdentValue REPEAT_X;
    public static final IdentValue REPEAT_Y;
    public static final IdentValue RIDGE;
    public static final IdentValue RIGHT;
    public static final IdentValue RUN_IN;
    public static final IdentValue SCROLL;
    public static final IdentValue SEPARATE;
    public static final IdentValue SHOW;
    public static final IdentValue SMALL_CAPS;
    public static final IdentValue SOLID;
    public static final IdentValue SQUARE;
    public static final IdentValue STATIC;
    public static final IdentValue SUB;
    public static final IdentValue SUPER;
    public static final IdentValue TABLE;
    public static final IdentValue TABLE_CAPTION;
    public static final IdentValue TABLE_CELL;
    public static final IdentValue TABLE_COLUMN;
    public static final IdentValue TABLE_COLUMN_GROUP;
    public static final IdentValue TABLE_FOOTER_GROUP;
    public static final IdentValue TABLE_HEADER_GROUP;
    public static final IdentValue TABLE_ROW;
    public static final IdentValue TABLE_ROW_GROUP;
    public static final IdentValue TEXT_BOTTOM;
    public static final IdentValue TEXT_TOP;
    public static final IdentValue THICK;
    public static final IdentValue THIN;
    public static final IdentValue TOP;
    public static final IdentValue TRANSPARENT;
    public static final IdentValue UNDERLINE;
    public static final IdentValue UPPER_ALPHA;
    public static final IdentValue UPPER_LATIN;
    public static final IdentValue UPPER_ROMAN;
    public static final IdentValue UPPERCASE;
    public static final IdentValue VISIBLE;
    public static final IdentValue CROSSHAIR;
    public static final IdentValue DEFAULT;
    public static final IdentValue EMBED;
    public static final IdentValue E_RESIZE;
    public static final IdentValue HELP;
    public static final IdentValue LARGE;
    public static final IdentValue LARGER;
    public static final IdentValue MEDIUM;
    public static final IdentValue MOVE;
    public static final IdentValue N_RESIZE;
    public static final IdentValue NE_RESIZE;
    public static final IdentValue NW_RESIZE;
    public static final IdentValue PROGRESS;
    public static final IdentValue S_RESIZE;
    public static final IdentValue SE_RESIZE;
    public static final IdentValue SMALL;
    public static final IdentValue SMALLER;
    public static final IdentValue START;
    public static final IdentValue SW_RESIZE;
    public static final IdentValue TEXT;
    public static final IdentValue W_RESIZE;
    public static final IdentValue WAIT;
    public static final IdentValue X_LARGE;
    public static final IdentValue X_SMALL;
    public static final IdentValue XX_LARGE;
    public static final IdentValue XX_SMALL;
    public static final IdentValue MANUAL;

    private IdentValue(String ident) {
        this.ident = ident;
        this.FS_ID = maxAssigned++;
    }

    public String toString() {
        return this.ident;
    }

    public static IdentValue getByIdentString(String ident) {
        IdentValue val = ALL_IDENT_VALUES.get(ident);
        if (val == null) {
            throw new XRRuntimeException("Ident named " + ident + " has no IdentValue instance assigned to it.");
        }
        return val;
    }

    public static boolean looksLikeIdent(String ident) {
        return ALL_IDENT_VALUES.get(ident) != null;
    }

    public static @Nullable IdentValue valueOf(String ident) {
        return ALL_IDENT_VALUES.get(ident);
    }

    public static int getIdentCount() {
        return ALL_IDENT_VALUES.size();
    }

    private static IdentValue addValue(String ident) {
        IdentValue val = new IdentValue(ident);
        ALL_IDENT_VALUES.put(ident, val);
        return val;
    }

    @Override
    public boolean isDeclaredInherit() {
        return this == INHERIT;
    }

    public FSDerivedValue computedValue() {
        return this;
    }

    @Override
    public float asFloat() {
        throw new XRRuntimeException("Ident value is never a float; wrong class used for derived value.");
    }

    @Override
    public FSColor asColor() {
        throw new XRRuntimeException("Ident value is never a color; wrong class used for derived value.");
    }

    @Override
    public float getFloatProportionalTo(CSSName cssName, float baseValue, CssContext ctx) {
        throw new XRRuntimeException("Ident value (" + String.valueOf(this) + ") is never a length; wrong class used for derived value.");
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public String[] asStringArray() {
        throw new XRRuntimeException("Ident value is never a string array; wrong class used for derived value.");
    }

    @Override
    public IdentValue asIdentValue() {
        return this;
    }

    @Override
    public boolean hasAbsoluteUnit() {
        throw new XRRuntimeException("Ident value is never an absolute unit; wrong class used for derived value; this ident value is a " + this.asString());
    }

    @Override
    public boolean isIdent() {
        return true;
    }

    @Override
    public boolean isDependentOnFontSize() {
        return false;
    }

    static {
        ABSOLUTE = IdentValue.addValue("absolute");
        ALWAYS = IdentValue.addValue("always");
        ARMENIAN = IdentValue.addValue("armenian");
        AUTO = IdentValue.addValue("auto");
        AVOID = IdentValue.addValue("avoid");
        BASELINE = IdentValue.addValue("baseline");
        BLINK = IdentValue.addValue("blink");
        BLOCK = IdentValue.addValue("block");
        BOLD = IdentValue.addValue("bold");
        BOLDER = IdentValue.addValue("bolder");
        BORDER_BOX = IdentValue.addValue("border-box");
        BOTH = IdentValue.addValue("both");
        BOTTOM = IdentValue.addValue("bottom");
        BREAK_ALL = IdentValue.addValue("break-all");
        CAPITALIZE = IdentValue.addValue("capitalize");
        CENTER = IdentValue.addValue("center");
        CIRCLE = IdentValue.addValue("circle");
        CJK_IDEOGRAPHIC = IdentValue.addValue("cjk-ideographic");
        CLOSE_QUOTE = IdentValue.addValue("close-quote");
        COLLAPSE = IdentValue.addValue("collapse");
        COMPACT = IdentValue.addValue("compact");
        CONTAIN = IdentValue.addValue("contain");
        CONTENT_BOX = IdentValue.addValue("content-box");
        COVER = IdentValue.addValue("cover");
        CREATE = IdentValue.addValue("create");
        DASHED = IdentValue.addValue("dashed");
        DECIMAL = IdentValue.addValue("decimal");
        DECIMAL_LEADING_ZERO = IdentValue.addValue("decimal-leading-zero");
        DISC = IdentValue.addValue("disc");
        DOTTED = IdentValue.addValue("dotted");
        DOUBLE = IdentValue.addValue("double");
        DYNAMIC = IdentValue.addValue("dynamic");
        FIXED = IdentValue.addValue("fixed");
        FONT_WEIGHT_100 = IdentValue.addValue("100");
        FONT_WEIGHT_200 = IdentValue.addValue("200");
        FONT_WEIGHT_300 = IdentValue.addValue("300");
        FONT_WEIGHT_400 = IdentValue.addValue("400");
        FONT_WEIGHT_500 = IdentValue.addValue("500");
        FONT_WEIGHT_600 = IdentValue.addValue("600");
        FONT_WEIGHT_700 = IdentValue.addValue("700");
        FONT_WEIGHT_800 = IdentValue.addValue("800");
        FONT_WEIGHT_900 = IdentValue.addValue("900");
        FS_CONTENT_PLACEHOLDER = IdentValue.addValue("-fs-content-placeholder");
        FS_INITIAL_VALUE = IdentValue.addValue("-fs-initial-value");
        GEORGIAN = IdentValue.addValue("georgian");
        GROOVE = IdentValue.addValue("groove");
        HEBREW = IdentValue.addValue("hebrew");
        HIDDEN = IdentValue.addValue("hidden");
        HIDE = IdentValue.addValue("hide");
        HIRAGANA = IdentValue.addValue("hiragana");
        HIRAGANA_IROHA = IdentValue.addValue("hiragana-iroha");
        INHERIT = IdentValue.addValue("inherit");
        INLINE = IdentValue.addValue("inline");
        INLINE_BLOCK = IdentValue.addValue("inline-block");
        INLINE_TABLE = IdentValue.addValue("inline-table");
        INSET = IdentValue.addValue("inset");
        INSIDE = IdentValue.addValue("inside");
        ITALIC = IdentValue.addValue("italic");
        JUSTIFY = IdentValue.addValue("justify");
        KATAKANA = IdentValue.addValue("katakana");
        KATAKANA_IROHA = IdentValue.addValue("katakana-iroha");
        KEEP = IdentValue.addValue("keep");
        LANDSCAPE = IdentValue.addValue("landscape");
        LEFT = IdentValue.addValue("left");
        LIGHTER = IdentValue.addValue("lighter");
        LINE = IdentValue.addValue("line");
        LINEAR_GRADIENT = IdentValue.addValue("linear-gradient");
        LINE_THROUGH = IdentValue.addValue("line-through");
        LIST_ITEM = IdentValue.addValue("list-item");
        LOWER_ALPHA = IdentValue.addValue("lower-alpha");
        LOWER_GREEK = IdentValue.addValue("lower-greek");
        LOWER_LATIN = IdentValue.addValue("lower-latin");
        LOWER_ROMAN = IdentValue.addValue("lower-roman");
        LOWERCASE = IdentValue.addValue("lowercase");
        LTR = IdentValue.addValue("ltr");
        MARKER = IdentValue.addValue("marker");
        MIDDLE = IdentValue.addValue("middle");
        NO_CLOSE_QUOTE = IdentValue.addValue("no-close-quote");
        NO_OPEN_QUOTE = IdentValue.addValue("no-open-quote");
        NO_REPEAT = IdentValue.addValue("no-repeat");
        NONE = IdentValue.addValue("none");
        NORMAL = IdentValue.addValue("normal");
        NOWRAP = IdentValue.addValue("nowrap");
        BREAK_WORD = IdentValue.addValue("break-word");
        OBLIQUE = IdentValue.addValue("oblique");
        OPEN_QUOTE = IdentValue.addValue("open-quote");
        OUTSET = IdentValue.addValue("outset");
        OUTSIDE = IdentValue.addValue("outside");
        OVERLINE = IdentValue.addValue("overline");
        PAGINATE = IdentValue.addValue("paginate");
        POINTER = IdentValue.addValue("pointer");
        PORTRAIT = IdentValue.addValue("portrait");
        PRE = IdentValue.addValue("pre");
        PRE_LINE = IdentValue.addValue("pre-line");
        PRE_WRAP = IdentValue.addValue("pre-wrap");
        RELATIVE = IdentValue.addValue("relative");
        REPEAT = IdentValue.addValue("repeat");
        REPEAT_X = IdentValue.addValue("repeat-x");
        REPEAT_Y = IdentValue.addValue("repeat-y");
        RIDGE = IdentValue.addValue("ridge");
        RIGHT = IdentValue.addValue("right");
        RUN_IN = IdentValue.addValue("run-in");
        SCROLL = IdentValue.addValue("scroll");
        SEPARATE = IdentValue.addValue("separate");
        SHOW = IdentValue.addValue("show");
        SMALL_CAPS = IdentValue.addValue("small-caps");
        SOLID = IdentValue.addValue("solid");
        SQUARE = IdentValue.addValue("square");
        STATIC = IdentValue.addValue("static");
        SUB = IdentValue.addValue("sub");
        SUPER = IdentValue.addValue("super");
        TABLE = IdentValue.addValue("table");
        TABLE_CAPTION = IdentValue.addValue("table-caption");
        TABLE_CELL = IdentValue.addValue("table-cell");
        TABLE_COLUMN = IdentValue.addValue("table-column");
        TABLE_COLUMN_GROUP = IdentValue.addValue("table-column-group");
        TABLE_FOOTER_GROUP = IdentValue.addValue("table-footer-group");
        TABLE_HEADER_GROUP = IdentValue.addValue("table-header-group");
        TABLE_ROW = IdentValue.addValue("table-row");
        TABLE_ROW_GROUP = IdentValue.addValue("table-row-group");
        TEXT_BOTTOM = IdentValue.addValue("text-bottom");
        TEXT_TOP = IdentValue.addValue("text-top");
        THICK = IdentValue.addValue("thick");
        THIN = IdentValue.addValue("thin");
        TOP = IdentValue.addValue("top");
        TRANSPARENT = IdentValue.addValue("transparent");
        UNDERLINE = IdentValue.addValue("underline");
        UPPER_ALPHA = IdentValue.addValue("upper-alpha");
        UPPER_LATIN = IdentValue.addValue("upper-latin");
        UPPER_ROMAN = IdentValue.addValue("upper-roman");
        UPPERCASE = IdentValue.addValue("uppercase");
        VISIBLE = IdentValue.addValue("visible");
        CROSSHAIR = IdentValue.addValue("crosshair");
        DEFAULT = IdentValue.addValue("default");
        EMBED = IdentValue.addValue("embed");
        E_RESIZE = IdentValue.addValue("e-resize");
        HELP = IdentValue.addValue("help");
        LARGE = IdentValue.addValue("large");
        LARGER = IdentValue.addValue("larger");
        MEDIUM = IdentValue.addValue("medium");
        MOVE = IdentValue.addValue("move");
        N_RESIZE = IdentValue.addValue("n-resize");
        NE_RESIZE = IdentValue.addValue("ne-resize");
        NW_RESIZE = IdentValue.addValue("nw-resize");
        PROGRESS = IdentValue.addValue("progress");
        S_RESIZE = IdentValue.addValue("s-resize");
        SE_RESIZE = IdentValue.addValue("se-resize");
        SMALL = IdentValue.addValue("small");
        SMALLER = IdentValue.addValue("smaller");
        START = IdentValue.addValue("start");
        SW_RESIZE = IdentValue.addValue("sw-resize");
        TEXT = IdentValue.addValue("text");
        W_RESIZE = IdentValue.addValue("w-resize");
        WAIT = IdentValue.addValue("wait");
        X_LARGE = IdentValue.addValue("x-large");
        X_SMALL = IdentValue.addValue("x-small");
        XX_LARGE = IdentValue.addValue("xx-large");
        XX_SMALL = IdentValue.addValue("xx-small");
        MANUAL = IdentValue.addValue("manual");
    }
}

