/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.simple.extend;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Locale;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openpdf.simple.extend.XhtmlCssOnlyNamespaceHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XhtmlNamespaceHandler
extends XhtmlCssOnlyNamespaceHandler {
    private static final Pattern RE_MANGLED_COLOR = Pattern.compile("[0-9a-f]{6}");

    @Override
    @CheckReturnValue
    public boolean isImageElement(Element e) {
        return e.getNodeName().equalsIgnoreCase("img");
    }

    @Override
    @CheckReturnValue
    public boolean isFormElement(Element e) {
        return e.getNodeName().equalsIgnoreCase("form");
    }

    @Override
    @CheckReturnValue
    public String getImageSourceURI(Element e) {
        return e.getAttribute("src");
    }

    @Override
    @CheckReturnValue
    public String getNonCssStyling(Element e) {
        return switch (e.getNodeName()) {
            case "table" -> this.applyTableStyles(e);
            case "td", "th" -> this.applyTableCellStyles(e);
            case "tr" -> this.applyTableRowStyles(e);
            case "img" -> this.applyImgStyles(e);
            case "p", "div" -> this.applyBlockAlign(e);
            default -> "";
        };
    }

    private String applyBlockAlign(Element e) {
        String s;
        return switch (s = e.getAttribute("align").trim().toLowerCase(Locale.ROOT)) {
            case "left", "right", "center", "justify" -> "text-align: " + s + ";";
            default -> "";
        };
    }

    private String applyImgStyles(Element e) {
        StringBuilder style = new StringBuilder();
        this.applyFloatingAlign(e, style);
        return style.toString();
    }

    private String applyTableCellStyles(Element e) {
        String s;
        StringBuilder style = new StringBuilder();
        Element table = this.findTable(e);
        if (table != null) {
            s = this.getAttribute(table, "cellpadding");
            if (s != null) {
                style.append("padding: ");
                style.append(this.convertToLength(s));
                style.append(";");
            }
            if ((s = this.getAttribute(table, "border")) != null && !s.equals("0")) {
                style.append("border: 1px outset black;");
            }
        }
        if ((s = this.getAttribute(e, "width")) != null) {
            style.append("width: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e, "height")) != null) {
            style.append("height: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        this.applyTableContentAlign(e, style);
        s = this.getAttribute(e, "bgcolor");
        if (s != null) {
            s = s.toLowerCase(Locale.ROOT);
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s)) {
                style.append('#');
                style.append(s);
            } else {
                style.append(s);
            }
            style.append(';');
        }
        if ((s = this.getAttribute(e, "background")) != null) {
            style.append("background-image: url(");
            style.append(s);
            style.append(");");
        }
        return style.toString();
    }

    private String applyTableStyles(Element e) {
        StringBuilder style = new StringBuilder();
        String s = this.getAttribute(e, "width");
        if (s != null) {
            style.append("width: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e, "border")) != null) {
            style.append("border: ");
            style.append(this.convertToLength(s));
            style.append(" inset black;");
        }
        if ((s = this.getAttribute(e, "cellspacing")) != null) {
            style.append("border-collapse: separate; border-spacing: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e, "bgcolor")) != null) {
            s = s.toLowerCase(Locale.ROOT);
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s)) {
                style.append('#');
                style.append(s);
            } else {
                style.append(s);
            }
            style.append(';');
        }
        if ((s = this.getAttribute(e, "background")) != null) {
            style.append("background-image: url(");
            style.append(s);
            style.append(");");
        }
        this.applyFloatingAlign(e, style);
        return style.toString();
    }

    private String applyTableRowStyles(Element e) {
        StringBuilder style = new StringBuilder();
        this.applyTableContentAlign(e, style);
        return style.toString();
    }

    private void applyFloatingAlign(Element e, StringBuilder style) {
        String s = this.getAttribute(e, "align");
        if (s != null) {
            switch (s = s.toLowerCase(Locale.ROOT).trim()) {
                case "left": {
                    style.append("float: left;");
                    break;
                }
                case "right": {
                    style.append("float: right;");
                    break;
                }
                case "center": {
                    style.append("margin-left: auto; margin-right: auto;");
                }
            }
        }
    }

    private void applyTableContentAlign(Element e, StringBuilder style) {
        String s = this.getAttribute(e, "align");
        if (s != null) {
            style.append("text-align: ");
            style.append(s.toLowerCase(Locale.ROOT));
            style.append(";");
        }
        if ((s = this.getAttribute(e, "valign")) != null) {
            style.append("vertical-align: ");
            style.append(s.toLowerCase(Locale.ROOT));
            style.append(";");
        }
    }

    boolean looksLikeAMangledColor(String s) {
        return RE_MANGLED_COLOR.matcher(s).matches();
    }

    @Nullable Element findTable(Node cell) {
        return this.ancestor(cell, "table", 5);
    }

    @Nullable Element ancestor(Node element, String tagName, int maxDepth) {
        Node parent = element.getParentNode();
        if (parent == null || maxDepth <= 0) {
            return null;
        }
        return parent.getNodeType() == 1 && parent.getNodeName().equals(tagName) ? (Element)parent : this.ancestor(parent, tagName, maxDepth - 1);
    }
}

