/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.resource;

import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.jspecify.annotations.Nullable;
import org.openpdf.resource.AbstractResource;
import org.openpdf.resource.FSEntityResolver;
import org.openpdf.util.Configuration;
import org.openpdf.util.InputSources;
import org.openpdf.util.XRLog;
import org.openpdf.util.XRRuntimeException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLResource
extends AbstractResource {
    private static final XMLResourceBuilder XML_RESOURCE_BUILDER = new XMLResourceBuilder();
    private static final AtomicBoolean useConfiguredParser = new AtomicBoolean(true);
    private final Document document;
    private final long elapsedLoadTime;
    private static boolean useHtmlUnitCyberNekoParser = true;

    private XMLResource(@Nullable InputSource source, Document document, long elapsedLoadTime) {
        super(source);
        this.document = document;
        this.elapsedLoadTime = elapsedLoadTime;
        useHtmlUnitCyberNekoParser = true;
    }

    public static XMLResource load(URL source) {
        return XMLResource.load(InputSources.fromURL(source));
    }

    public static XMLResource load(InputStream stream) {
        return XML_RESOURCE_BUILDER.createXMLResource(InputSources.fromStream(stream));
    }

    public static XMLResource load(InputSource source) {
        return XML_RESOURCE_BUILDER.createXMLResource(source);
    }

    public static XMLResource load(Reader reader) {
        return XML_RESOURCE_BUILDER.createXMLResource(new InputSource(reader));
    }

    public static XMLResource load(String xml) {
        return XMLResource.load(new StringReader(xml));
    }

    public static XMLResource load(Source source) {
        return XML_RESOURCE_BUILDER.createXMLResource(source);
    }

    public Document getDocument() {
        return this.document;
    }

    @CheckReturnValue
    public long getElapsedLoadTime() {
        return this.elapsedLoadTime;
    }

    public static XMLReader newXMLReader() {
        XMLReader xmlReader = null;
        String xmlReaderClass = Configuration.valueFor("xr.load.xml-reader");
        if (useConfiguredParser.get()) {
            try {
                if (xmlReaderClass != null && !xmlReaderClass.equalsIgnoreCase("default")) {
                    try {
                        Class<?> readerClass = Class.forName(xmlReaderClass);
                        xmlReader = (XMLReader)readerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception ex) {
                        useConfiguredParser.set(false);
                        XRLog.load(Level.SEVERE, "The XMLReader class could not be found: '%s'.\nCaused by: %s.\nFalling back to JDK default xml reader.\nHint: Use value 'default' in FS configuration if necessary.\n".formatted(xmlReaderClass, ex));
                    }
                }
            }
            catch (Exception ex) {
                XRLog.load(Level.WARNING, "Could not instantiate custom XMLReader class for XML parsing: " + xmlReaderClass + ". Please check classpath. Use value 'default' in FS configuration if necessary. Will now try JDK default.", ex);
            }
        }
        if ((xmlReaderClass = "org.htmlunit.cyberneko.parsers.SAXParser") != null && useHtmlUnitCyberNekoParser) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader(xmlReaderClass);
            }
            catch (Exception ex) {
                useHtmlUnitCyberNekoParser = false;
            }
        }
        if (xmlReader == null) {
            try {
                xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (Exception ex) {
                XRLog.general(ex.getMessage());
            }
        }
        if (xmlReader == null) {
            try {
                XRLog.load(Level.WARNING, "falling back on the default parser");
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                xmlReader = parser.getXMLReader();
            }
            catch (Exception ex) {
                XRLog.general(Level.WARNING, ex.getMessage(), ex);
            }
        }
        if (xmlReader == null) {
            throw new XRRuntimeException("Could not instantiate any SAX 2 parser, including JDK default. The name of the class to use should have been read from the org.xml.sax.driver System property, which is set to: ");
        }
        XRLog.load("SAX XMLReader in use (parser): " + xmlReader.getClass().getName());
        return xmlReader;
    }

    private static class XMLResourceBuilder {
        private final XMLReaderPool parserPool = new XMLReaderPool();
        private final IdentityTransformerPool transformerPool = new IdentityTransformerPool();

        private XMLResourceBuilder() {
        }

        private XMLResource createXMLResource(InputSource inputSource) {
            long start = System.currentTimeMillis();
            Document document = this.parse(inputSource);
            long elapsedLoadTime = System.currentTimeMillis() - start;
            XRLog.load("Loaded document in " + elapsedLoadTime + "ms");
            return new XMLResource(inputSource, document, elapsedLoadTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Document parse(InputSource inputSource) {
            XMLReader xmlReader = (XMLReader)this.parserPool.get();
            try {
                Document document = this.transform(new SAXSource(xmlReader, inputSource));
                return document;
            }
            finally {
                this.parserPool.release(xmlReader);
            }
        }

        XMLResource createXMLResource(Source source) {
            long start = System.currentTimeMillis();
            Document document = this.transform(source);
            long elapsedLoadTime = System.currentTimeMillis() - start;
            XMLResource target = new XMLResource(null, document, elapsedLoadTime);
            XRLog.load("Loaded document in " + elapsedLoadTime + " ms.");
            return target;
        }

        private Document transform(Source source) {
            DOMResult result = new DOMResult();
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = factory.newTransformer();
                transformer.transform(source, result);
                return (Document)result.getNode();
            }
            catch (IllegalArgumentException | TransformerException ex) {
                throw new XRRuntimeException("Can't load the XML resource (using TrAX transformer). " + ex.getMessage(), ex);
            }
        }
    }

    private static abstract class ObjectPool<T> {
        private final Queue<Reference<T>> pool;

        private ObjectPool(int capacity) {
            this.pool = new ArrayBlockingQueue<Reference<T>>(capacity);
        }

        protected abstract T newValue();

        T get() {
            T obj = null;
            Reference<T> ref = this.pool.poll();
            if (ref != null) {
                obj = ref.get();
            }
            if (obj == null) {
                obj = this.newValue();
            }
            return obj;
        }

        void release(T obj) {
            this.pool.offer(new SoftReference<T>(obj));
        }
    }

    private static class IdentityTransformerPool
    extends ObjectPool<Transformer> {
        private final TransformerFactory transformerFactory;

        private IdentityTransformerPool(int capacity) {
            super(capacity);
            TransformerFactory tf = TransformerFactory.newInstance();
            try {
                tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (TransformerConfigurationException e) {
                XRLog.init(Level.WARNING, "Problem configuring TrAX factory", e);
            }
            this.transformerFactory = tf;
        }

        private IdentityTransformerPool() {
            this(Configuration.valueAsInt("xr.load.parser-pool-capacity", 3));
        }

        @Override
        protected Transformer newValue() {
            try {
                return this.transformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException ex) {
                throw new XRRuntimeException("Failed on configuring TrAX transformer.", ex);
            }
        }
    }

    private static class WhitespacePreservingFilter
    extends XMLFilterImpl
    implements EntityResolver2 {
        private WhitespacePreservingFilter(XMLReader parent) {
            super(parent);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.getContentHandler().characters(ch, start, length);
        }

        @Override
        public @Nullable InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
            EntityResolver resolver = this.getEntityResolver();
            if (resolver instanceof EntityResolver2) {
                return ((EntityResolver2)resolver).getExternalSubset(name, baseURI);
            }
            return null;
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            EntityResolver resolver = this.getEntityResolver();
            if (resolver instanceof EntityResolver2) {
                return ((EntityResolver2)resolver).resolveEntity(name, publicId, baseURI, systemId);
            }
            return this.resolveEntity(publicId, systemId);
        }
    }

    private static class XMLReaderPool
    extends ObjectPool<XMLReader> {
        private final boolean preserveElementContentWhitespace = Configuration.isFalse("xr.load.ignore-element-content-whitespace", true);

        private XMLReaderPool() {
            this(Configuration.valueAsInt("xr.load.parser-pool-capacity", 3));
        }

        private XMLReaderPool(int capacity) {
            super(capacity);
        }

        @Override
        protected XMLReader newValue() {
            XMLReader xmlReader = XMLResource.newXMLReader();
            if (this.preserveElementContentWhitespace) {
                xmlReader = new WhitespacePreservingFilter(xmlReader);
            }
            this.addHandlers(xmlReader);
            this.setParserFeatures(xmlReader);
            return xmlReader;
        }

        private void addHandlers(XMLReader xmlReader) {
            xmlReader.setEntityResolver(FSEntityResolver.instance());
            xmlReader.setErrorHandler(new ErrorHandler(this){

                @Override
                public void error(SAXParseException ex) {
                    XRLog.load(ex.getMessage());
                }

                @Override
                public void fatalError(SAXParseException ex) {
                    XRLog.load(ex.getMessage());
                }

                @Override
                public void warning(SAXParseException ex) {
                    XRLog.load(ex.getMessage());
                }
            });
        }

        private void setParserFeatures(XMLReader xmlReader) {
            try {
                xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            }
            catch (SAXException s) {
                XRLog.load(Level.WARNING, "Could not set validation/namespace features for XML parser,exception thrown.", s);
            }
            if (Configuration.isFalse("xr.load.configure-features", false)) {
                XRLog.load(Level.FINE, "SAX Parser: by request, not changing any parser features.");
                return;
            }
            this.setFeature(xmlReader, "http://xml.org/sax/features/validation", "xr.load.validation");
            this.setFeature(xmlReader, "http://xml.org/sax/features/string-interning", "xr.load.string-interning");
            this.setFeature(xmlReader, "http://xml.org/sax/features/namespaces", "xr.load.namespaces");
            this.setFeature(xmlReader, "http://xml.org/sax/features/namespace-prefixes", "xr.load.namespace-prefixes");
            this.setFeature(xmlReader, "http://xml.org/sax/features/use-entity-resolver2", true);
            this.setFeature(xmlReader, "http://xml.org/sax/features/xmlns-uris", true);
        }

        private void setFeature(XMLReader xmlReader, String featureUri, String configName) {
            this.setFeature(xmlReader, featureUri, Configuration.isTrue(configName, false));
        }

        private void setFeature(XMLReader xmlReader, String featureUri, boolean value) {
            try {
                xmlReader.setFeature(featureUri, value);
                XRLog.load(Level.FINE, "SAX Parser feature: " + featureUri.substring(featureUri.lastIndexOf(47)) + " set to " + xmlReader.getFeature(featureUri));
            }
            catch (SAXNotSupportedException ex) {
                XRLog.load(Level.WARNING, "SAX feature not supported on this XMLReader: " + featureUri, ex);
            }
            catch (SAXNotRecognizedException ex) {
                XRLog.load(Level.WARNING, "SAX feature not recognized on this XMLReader: " + featureUri + ". Feature may be properly named, but not recognized by this parser.", ex);
            }
        }
    }
}

