/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.layout;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import org.openpdf.css.style.CssContext;
import org.openpdf.layout.BoxRange;
import org.openpdf.layout.BoxRangeData;
import org.openpdf.layout.BoxRangeLists;
import org.openpdf.layout.Layer;
import org.openpdf.layout.PaintingInfo;
import org.openpdf.newtable.TableBox;
import org.openpdf.render.BlockBox;
import org.openpdf.render.Box;
import org.openpdf.render.InlineLayoutBox;
import org.openpdf.render.LineBox;
import org.openpdf.render.RenderingContext;

public class BoxCollector {
    public void collect(CssContext c, Shape clip, Layer layer, List<Box> blockContent, List<Box> inlineContent, BoxRangeLists rangeLists) {
        if (layer.isInline()) {
            this.collectInlineLayer(c, clip, layer, blockContent, inlineContent, rangeLists);
        } else {
            this.collect(c, clip, layer, layer.getMaster(), blockContent, inlineContent, rangeLists);
        }
    }

    public boolean intersectsAny(CssContext c, Shape clip, Box master) {
        return this.intersectsAny(c, clip, master, master);
    }

    private void collectInlineLayer(CssContext c, Shape clip, Layer layer, List<Box> blockContent, List<Box> inlineContent, BoxRangeLists rangeLists) {
        InlineLayoutBox iB = (InlineLayoutBox)layer.getMaster();
        List<Box> content = iB.getElementWithContent();
        for (Box b : content) {
            if (!b.intersects(c, clip)) continue;
            if (b instanceof InlineLayoutBox) {
                inlineContent.add(b);
                continue;
            }
            BlockBox bb = (BlockBox)b;
            if (bb.isInline()) {
                if (!this.intersectsAny(c, clip, b)) continue;
                inlineContent.add(bb);
                continue;
            }
            this.collect(c, clip, layer, bb, blockContent, inlineContent, rangeLists);
        }
    }

    private boolean intersectsAggregateBounds(Shape clip, Box box) {
        if (clip == null) {
            return true;
        }
        PaintingInfo info = box.getPaintingInfo();
        if (info == null) {
            return false;
        }
        Rectangle bounds = info.getAggregateBounds();
        return clip.intersects(bounds);
    }

    public void collect(CssContext c, Shape clip, Layer layer, Box container, List<Box> blockContent, List<Box> inlineContent, BoxRangeLists rangeLists) {
        if (layer != container.getContainingLayer()) {
            return;
        }
        boolean isBlock = container instanceof BlockBox;
        int blockStart = 0;
        int inlineStart = 0;
        int blockRangeStart = 0;
        int inlineRangeStart = 0;
        if (isBlock) {
            blockStart = blockContent.size();
            inlineStart = inlineContent.size();
            blockRangeStart = rangeLists.getBlock().size();
            inlineRangeStart = rangeLists.getInline().size();
        }
        if (container instanceof LineBox) {
            if (this.intersectsAggregateBounds(clip, container) || container.getPaintingInfo() == null && container.intersects(c, clip)) {
                inlineContent.add(container);
                ((LineBox)container).addAllChildren(inlineContent, layer);
            }
        } else {
            boolean intersectsAggregateBounds = this.intersectsAggregateBounds(clip, container);
            if ((container.getLayer() == null || !(container instanceof BlockBox)) && (intersectsAggregateBounds || container.getPaintingInfo() == null && container.intersects(c, clip))) {
                blockContent.add(container);
                if (container.getStyle().isTable() && c instanceof RenderingContext) {
                    assert (container instanceof TableBox);
                    TableBox table = (TableBox)container;
                    if (table.hasContentLimitContainer()) {
                        table.updateHeaderFooterPosition((RenderingContext)c);
                    }
                }
            }
            if (!(container.getPaintingInfo() != null && !intersectsAggregateBounds || container.getLayer() != null && container != layer.getMaster())) {
                for (int i = 0; i < container.getChildCount(); ++i) {
                    Box child = container.getChild(i);
                    this.collect(c, clip, layer, child, blockContent, inlineContent, rangeLists);
                }
            }
        }
        this.saveRangeData(c, container, blockContent, inlineContent, rangeLists, isBlock, blockStart, inlineStart, blockRangeStart, inlineRangeStart);
    }

    private void saveRangeData(CssContext c, Box container, List<Box> blockContent, List<Box> inlineContent, BoxRangeLists rangeLists, boolean isBlock, int blockStart, int inlineStart, int blockRangeStart, int inlineRangeStart) {
        BlockBox blockBox;
        if (isBlock && c instanceof RenderingContext && (blockBox = (BlockBox)container).isNeedsClipOnPaint((RenderingContext)c)) {
            int inlineEnd;
            int blockEnd = blockContent.size();
            if (blockStart != blockEnd) {
                BoxRange range = new BoxRange(blockStart, blockEnd);
                rangeLists.getBlock().add(blockRangeStart, new BoxRangeData(blockBox, range));
            }
            if (inlineStart != (inlineEnd = inlineContent.size())) {
                BoxRange range = new BoxRange(inlineStart, inlineEnd);
                rangeLists.getInline().add(inlineRangeStart, new BoxRangeData(blockBox, range));
            }
        }
    }

    private boolean intersectsAny(CssContext c, Shape clip, Box master, Box container) {
        if (container instanceof LineBox) {
            return container.intersects(c, clip);
        }
        if ((container.getLayer() == null || !(container instanceof BlockBox)) && container.intersects(c, clip)) {
            return true;
        }
        if (container.getLayer() == null || container == master) {
            for (int i = 0; i < container.getChildCount(); ++i) {
                Box child = container.getChild(i);
                boolean possibleResult = this.intersectsAny(c, clip, master, child);
                if (!possibleResult) continue;
                return true;
            }
        }
        return false;
    }
}

